/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.jdbc.internal.spi.analyzer;

import com.facebook.presto.jdbc.internal.common.QualifiedObjectName;
import com.facebook.presto.jdbc.internal.common.Subfield;
import com.facebook.presto.jdbc.internal.spi.analyzer.AccessControlInfo;
import com.facebook.presto.jdbc.internal.spi.analyzer.AccessControlInfoForTable;
import com.facebook.presto.jdbc.internal.spi.analyzer.AccessControlRole;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

public class AccessControlReferences {
    private final Map<AccessControlRole, Set<AccessControlInfoForTable>> tableReferences = new LinkedHashMap<AccessControlRole, Set<AccessControlInfoForTable>>();
    private final Map<AccessControlInfo, Map<QualifiedObjectName, Set<Subfield>>> tableColumnAndSubfieldReferencesForAccessControl = new LinkedHashMap<AccessControlInfo, Map<QualifiedObjectName, Set<Subfield>>>();

    public Map<AccessControlRole, Set<AccessControlInfoForTable>> getTableReferences() {
        return Collections.unmodifiableMap(this.tableReferences);
    }

    public void addTableReference(AccessControlRole role, AccessControlInfoForTable accessControlInfoForTable) {
        this.tableReferences.computeIfAbsent(role, r -> new LinkedHashSet()).add(accessControlInfoForTable);
    }

    public Map<AccessControlInfo, Map<QualifiedObjectName, Set<Subfield>>> getTableColumnAndSubfieldReferencesForAccessControl() {
        return this.tableColumnAndSubfieldReferencesForAccessControl;
    }

    public void addTableColumnAndSubfieldReferencesForAccessControl(Map<AccessControlInfo, Map<QualifiedObjectName, Set<Subfield>>> tableColumnAndSubfieldReferencesForAccessControl) {
        this.tableColumnAndSubfieldReferencesForAccessControl.putAll(Objects.requireNonNull(tableColumnAndSubfieldReferencesForAccessControl, "tableColumnAndSubfieldReferencesForAccessControl is null"));
    }
}

