/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.jdbc.internal.spi;

import com.facebook.presto.jdbc.internal.jackson.annotation.JsonCreator;
import com.facebook.presto.jdbc.internal.jackson.annotation.JsonProperty;
import java.util.Objects;

public class SourceLocation {
    private final int line;
    private final int column;

    @JsonCreator
    public SourceLocation(@JsonProperty(value="line") int line, @JsonProperty(value="column") int column) {
        this.line = line;
        this.column = column;
    }

    public String toString() {
        return this.line + ":" + this.column;
    }

    @JsonProperty
    public int getLine() {
        return this.line;
    }

    @JsonProperty
    public int getColumn() {
        return this.column;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SourceLocation that = (SourceLocation)obj;
        return this.line == that.line && this.column == that.column;
    }

    public int hashCode() {
        return Objects.hash(this.line, this.column);
    }
}

