/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.jdbc.internal.common.type;

import com.facebook.presto.jdbc.internal.common.block.Block;
import com.facebook.presto.jdbc.internal.common.function.SqlFunctionProperties;
import com.facebook.presto.jdbc.internal.common.type.AbstractLongType;
import com.facebook.presto.jdbc.internal.common.type.SqlTimestamp;
import com.facebook.presto.jdbc.internal.common.type.TypeSignature;
import java.util.Objects;
import java.util.concurrent.TimeUnit;

public final class TimestampType
extends AbstractLongType {
    public static final TimestampType TIMESTAMP = new TimestampType(TimeUnit.MILLISECONDS);
    public static final TimestampType TIMESTAMP_MICROSECONDS = new TimestampType(TimeUnit.MICROSECONDS);
    private final TimeUnit precision;

    private TimestampType(TimeUnit precision) {
        super(TypeSignature.parseTypeSignature(TimestampType.getType(precision)));
        this.precision = precision;
    }

    @Override
    public Object getObjectValue(SqlFunctionProperties properties, Block block, int position) {
        if (block.isNull(position)) {
            return null;
        }
        if (properties.isLegacyTimestamp()) {
            return new SqlTimestamp(block.getLong(position), properties.getTimeZoneKey(), this.precision);
        }
        return new SqlTimestamp(block.getLong(position), this.precision);
    }

    public TimeUnit getPrecision() {
        return this.precision;
    }

    @Override
    public boolean equals(Object other) {
        if (this.precision == TimeUnit.MICROSECONDS) {
            return other == TIMESTAMP_MICROSECONDS;
        }
        if (this.precision == TimeUnit.MILLISECONDS) {
            return other == TIMESTAMP;
        }
        throw new UnsupportedOperationException("Unsupported precision " + (Object)((Object)this.precision));
    }

    @Override
    public int hashCode() {
        return Objects.hash(new Object[]{this.getClass(), this.precision});
    }

    public long getEpochSecond(long timestamp) {
        return this.precision.toSeconds(timestamp);
    }

    public int getNanos(long timestamp) {
        long unitsPerSecond = this.precision.convert(1L, TimeUnit.SECONDS);
        return (int)this.precision.toNanos(timestamp % unitsPerSecond);
    }

    private static String getType(TimeUnit precision) {
        if (precision == TimeUnit.MICROSECONDS) {
            return "timestamp microseconds";
        }
        if (precision == TimeUnit.MILLISECONDS) {
            return "timestamp";
        }
        throw new IllegalArgumentException("Unsupported precision " + (Object)((Object)precision));
    }
}

