/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.jdbc.internal.common.block;

import com.facebook.presto.jdbc.internal.common.block.Block;
import com.facebook.presto.jdbc.internal.common.block.BlockEncoding;
import com.facebook.presto.jdbc.internal.common.block.BlockEncodingSerde;
import com.facebook.presto.jdbc.internal.common.block.ByteArrayBlock;
import com.facebook.presto.jdbc.internal.common.block.EncoderUtil;
import com.facebook.presto.jdbc.internal.io.airlift.slice.SliceInput;
import com.facebook.presto.jdbc.internal.io.airlift.slice.SliceOutput;

public class ByteArrayBlockEncoding
implements BlockEncoding {
    public static final String NAME = "BYTE_ARRAY";

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public void writeBlock(BlockEncodingSerde blockEncodingSerde, SliceOutput sliceOutput, Block block) {
        int positionCount = block.getPositionCount();
        sliceOutput.appendInt(positionCount);
        EncoderUtil.encodeNullsAsBits(sliceOutput, block);
        boolean mayHaveNull = block.mayHaveNull();
        for (int position = 0; position < positionCount; ++position) {
            if (mayHaveNull && block.isNull(position)) continue;
            sliceOutput.writeByte(block.getByte(position));
        }
    }

    @Override
    public Block readBlock(BlockEncodingSerde blockEncodingSerde, SliceInput sliceInput) {
        int positionCount = sliceInput.readInt();
        boolean[] valueIsNull = EncoderUtil.decodeNullBits(sliceInput, positionCount).orElse(null);
        byte[] values2 = new byte[positionCount];
        if (valueIsNull == null) {
            sliceInput.readBytes(values2, 0, values2.length);
        } else {
            for (int position = 0; position < values2.length; ++position) {
                if (valueIsNull[position]) continue;
                values2[position] = sliceInput.readByte();
            }
        }
        return new ByteArrayBlock(0, positionCount, valueIsNull, values2);
    }
}

