/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.jdbc.internal.spi.statistics;

import com.facebook.presto.jdbc.internal.drift.annotations.ThriftConstructor;
import com.facebook.presto.jdbc.internal.drift.annotations.ThriftField;
import com.facebook.presto.jdbc.internal.drift.annotations.ThriftStruct;
import com.facebook.presto.jdbc.internal.jackson.annotation.JsonCreator;
import com.facebook.presto.jdbc.internal.jackson.annotation.JsonProperty;
import com.facebook.presto.jdbc.internal.spi.statistics.Estimate;
import java.util.Objects;

@ThriftStruct
public class PlanStatistics {
    private static final PlanStatistics EMPTY = new PlanStatistics(Estimate.unknown(), Estimate.unknown(), 0.0);
    private final Estimate rowCount;
    private final Estimate outputSize;
    private final double confidence;

    public static PlanStatistics empty() {
        return EMPTY;
    }

    @JsonCreator
    @ThriftConstructor
    public PlanStatistics(@JsonProperty(value="rowCount") Estimate rowCount, @JsonProperty(value="outputSize") Estimate outputSize, @JsonProperty(value="confidence") double confidence) {
        this.rowCount = Objects.requireNonNull(rowCount, "rowCount is null");
        this.outputSize = Objects.requireNonNull(outputSize, "outputSize is null");
        PlanStatistics.checkArgument(confidence >= 0.0 && confidence <= 1.0, "confidence should be between 0 and 1");
        this.confidence = confidence;
    }

    @JsonProperty
    @ThriftField(value=1)
    public Estimate getRowCount() {
        return this.rowCount;
    }

    @JsonProperty
    @ThriftField(value=2)
    public Estimate getOutputSize() {
        return this.outputSize;
    }

    @JsonProperty
    @ThriftField(value=3)
    public double getConfidence() {
        return this.confidence;
    }

    private static void checkArgument(boolean condition, String message) {
        if (!condition) {
            throw new IllegalArgumentException(message);
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PlanStatistics that = (PlanStatistics)o;
        return Double.compare(that.confidence, this.confidence) == 0 && Objects.equals(this.rowCount, that.rowCount) && Objects.equals(this.outputSize, that.outputSize);
    }

    public int hashCode() {
        return Objects.hash(this.rowCount, this.outputSize, this.confidence);
    }

    public String toString() {
        return "PlanStatistics{rowCount=" + this.rowCount + ", outputSize=" + this.outputSize + ", confidence=" + this.confidence + '}';
    }
}

