/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.jdbc.internal.spi.plan;

import com.facebook.presto.jdbc.internal.jackson.annotation.JsonCreator;
import com.facebook.presto.jdbc.internal.jackson.annotation.JsonProperty;
import com.facebook.presto.jdbc.internal.javax.annotation.concurrent.Immutable;
import com.facebook.presto.jdbc.internal.spi.ErrorCodeSupplier;
import com.facebook.presto.jdbc.internal.spi.PrestoException;
import com.facebook.presto.jdbc.internal.spi.SourceLocation;
import com.facebook.presto.jdbc.internal.spi.StandardErrorCode;
import com.facebook.presto.jdbc.internal.spi.plan.LogicalProperties;
import com.facebook.presto.jdbc.internal.spi.plan.LogicalPropertiesProvider;
import com.facebook.presto.jdbc.internal.spi.plan.OrderingScheme;
import com.facebook.presto.jdbc.internal.spi.plan.PlanNode;
import com.facebook.presto.jdbc.internal.spi.plan.PlanNodeId;
import com.facebook.presto.jdbc.internal.spi.plan.PlanVisitor;
import com.facebook.presto.jdbc.internal.spi.relation.VariableReferenceExpression;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

@Immutable
public final class TopNNode
extends PlanNode {
    private final PlanNode source;
    private final long count;
    private final OrderingScheme orderingScheme;
    private final Step step;

    @JsonCreator
    public TopNNode(Optional<SourceLocation> sourceLocation, @JsonProperty(value="id") PlanNodeId id, @JsonProperty(value="source") PlanNode source, @JsonProperty(value="count") long count, @JsonProperty(value="orderingScheme") OrderingScheme orderingScheme, @JsonProperty(value="step") Step step) {
        this(sourceLocation, id, Optional.empty(), source, count, orderingScheme, step);
    }

    public TopNNode(Optional<SourceLocation> sourceLocation, PlanNodeId id, Optional<PlanNode> statsEquivalentPlanNode, PlanNode source, long count, OrderingScheme orderingScheme, Step step) {
        super(sourceLocation, id, statsEquivalentPlanNode);
        Objects.requireNonNull(source, "source is null");
        TopNNode.checkArgument(count >= 0L, "count must be positive");
        TopNNode.checkCondition(count <= Integer.MAX_VALUE, StandardErrorCode.NOT_SUPPORTED, "ORDER BY LIMIT > %s is not supported", Integer.MAX_VALUE);
        Objects.requireNonNull(orderingScheme, "orderingScheme is null");
        this.source = source;
        this.count = count;
        this.orderingScheme = orderingScheme;
        this.step = Objects.requireNonNull(step, "step is null");
    }

    @Override
    public List<PlanNode> getSources() {
        return Collections.singletonList(this.source);
    }

    @JsonProperty(value="source")
    public PlanNode getSource() {
        return this.source;
    }

    @Override
    public LogicalProperties computeLogicalProperties(LogicalPropertiesProvider logicalPropertiesProvider) {
        Objects.requireNonNull(logicalPropertiesProvider, "logicalPropertiesProvider cannot be null.");
        return logicalPropertiesProvider.getTopNProperties(this);
    }

    @Override
    public List<VariableReferenceExpression> getOutputVariables() {
        return this.source.getOutputVariables();
    }

    @JsonProperty(value="count")
    public long getCount() {
        return this.count;
    }

    @JsonProperty(value="orderingScheme")
    public OrderingScheme getOrderingScheme() {
        return this.orderingScheme;
    }

    @JsonProperty(value="step")
    public Step getStep() {
        return this.step;
    }

    @Override
    public <R, C> R accept(PlanVisitor<R, C> visitor, C context) {
        return visitor.visitTopN(this, context);
    }

    @Override
    public PlanNode assignStatsEquivalentPlanNode(Optional<PlanNode> statsEquivalentPlanNode) {
        return new TopNNode(this.getSourceLocation(), this.getId(), statsEquivalentPlanNode, this.source, this.count, this.orderingScheme, this.step);
    }

    @Override
    public PlanNode replaceChildren(List<PlanNode> newChildren) {
        TopNNode.checkCondition(newChildren != null && newChildren.size() == 1, StandardErrorCode.GENERIC_INTERNAL_ERROR, "Expect exactly 1 child PlanNode", new Object[0]);
        return new TopNNode(this.getSourceLocation(), this.getId(), this.getStatsEquivalentPlanNode(), newChildren.get(0), this.count, this.orderingScheme, this.step);
    }

    private static void checkArgument(boolean condition, String message) {
        if (!condition) {
            throw new IllegalArgumentException(message);
        }
    }

    private static void checkCondition(boolean condition, ErrorCodeSupplier errorCode, String formatString, Object ... args) {
        if (!condition) {
            throw new PrestoException(errorCode, String.format(formatString, args));
        }
    }

    public static enum Step {
        SINGLE,
        PARTIAL,
        FINAL;

    }
}

