/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.jdbc.internal.spi.function.aggregation;

import com.facebook.presto.jdbc.internal.common.block.Block;
import com.facebook.presto.jdbc.internal.common.block.BlockBuilder;
import com.facebook.presto.jdbc.internal.common.type.BigintType;
import com.facebook.presto.jdbc.internal.io.airlift.slice.Slice;
import com.facebook.presto.jdbc.internal.io.airlift.slice.SliceOutput;
import com.facebook.presto.jdbc.internal.jol.info.ClassLayout;
import java.util.Objects;
import java.util.OptionalInt;
import java.util.function.ObjLongConsumer;

public class GroupByIdBlock
implements Block {
    private static final int INSTANCE_SIZE = ClassLayout.parseClass(GroupByIdBlock.class).instanceSize();
    private final long groupCount;
    private final Block block;

    public GroupByIdBlock(long groupCount, Block block) {
        Objects.requireNonNull(block, "block is null");
        this.groupCount = groupCount;
        this.block = block;
    }

    public long getGroupCount() {
        return this.groupCount;
    }

    public long getGroupId(int position) {
        return BigintType.BIGINT.getLong(this.block, position);
    }

    @Override
    public Block getRegion(int positionOffset, int length) {
        return this.block.getRegion(positionOffset, length);
    }

    @Override
    public long getRegionSizeInBytes(int positionOffset, int length) {
        return this.block.getRegionSizeInBytes(positionOffset, length);
    }

    @Override
    public long getPositionsSizeInBytes(boolean[] positions, int usedPositionCount) {
        return this.block.getPositionsSizeInBytes(positions, usedPositionCount);
    }

    @Override
    public Block copyRegion(int positionOffset, int length) {
        return this.block.copyRegion(positionOffset, length);
    }

    @Override
    public int getSliceLength(int position) {
        return this.block.getSliceLength(position);
    }

    @Override
    public byte getByte(int position) {
        return this.block.getByte(position);
    }

    @Override
    public short getShort(int position) {
        return this.block.getShort(position);
    }

    @Override
    public int getInt(int position) {
        return this.block.getInt(position);
    }

    @Override
    public long getLong(int position) {
        return this.block.getLong(position);
    }

    @Override
    public long getLong(int position, int offset) {
        return this.block.getLong(position, offset);
    }

    @Override
    public Slice getSlice(int position, int offset, int length) {
        return this.block.getSlice(position, offset, length);
    }

    @Override
    public Block getBlock(int position) {
        return this.block.getBlock(position);
    }

    @Override
    public boolean bytesEqual(int position, int offset, Slice otherSlice, int otherOffset, int length) {
        return this.block.bytesEqual(position, offset, otherSlice, otherOffset, length);
    }

    @Override
    public int bytesCompare(int position, int offset, int length, Slice otherSlice, int otherOffset, int otherLength) {
        return this.block.bytesCompare(position, offset, length, otherSlice, otherOffset, otherLength);
    }

    @Override
    public void writeBytesTo(int position, int offset, int length, BlockBuilder blockBuilder) {
        this.block.writeBytesTo(position, offset, length, blockBuilder);
    }

    @Override
    public void writeBytesTo(int position, int offset, int length, SliceOutput sliceOutput) {
        this.block.writeBytesTo(position, offset, length, sliceOutput);
    }

    @Override
    public void writePositionTo(int position, BlockBuilder blockBuilder) {
        this.block.writePositionTo(position, blockBuilder);
    }

    @Override
    public void writePositionTo(int position, SliceOutput output) {
        this.block.writePositionTo(position, output);
    }

    @Override
    public boolean equals(int position, int offset, Block otherBlock, int otherPosition, int otherOffset, int length) {
        return this.block.equals(position, offset, otherBlock, otherPosition, otherOffset, length);
    }

    @Override
    public long hash(int position, int offset, int length) {
        return this.block.hash(position, offset, length);
    }

    @Override
    public int compareTo(int leftPosition, int leftOffset, int leftLength, Block rightBlock, int rightPosition, int rightOffset, int rightLength) {
        return this.block.compareTo(leftPosition, leftOffset, leftLength, rightBlock, rightPosition, rightOffset, rightLength);
    }

    @Override
    public Block getSingleValueBlock(int position) {
        return this.block.getSingleValueBlock(position);
    }

    @Override
    public boolean isNull(int position) {
        return this.block.isNull(position);
    }

    @Override
    public boolean mayHaveNull() {
        return this.block.mayHaveNull();
    }

    @Override
    public int getPositionCount() {
        return this.block.getPositionCount();
    }

    @Override
    public long getSizeInBytes() {
        return this.block.getSizeInBytes();
    }

    @Override
    public OptionalInt fixedSizeInBytesPerPosition() {
        return this.block.fixedSizeInBytesPerPosition();
    }

    @Override
    public long getRetainedSizeInBytes() {
        return (long)INSTANCE_SIZE + this.block.getRetainedSizeInBytes();
    }

    @Override
    public long getEstimatedDataSizeForStats(int position) {
        return this.block.getEstimatedDataSizeForStats(position);
    }

    @Override
    public void retainedBytesForEachPart(ObjLongConsumer<Object> consumer) {
        consumer.accept(this.block, this.block.getRetainedSizeInBytes());
        consumer.accept(this, INSTANCE_SIZE);
    }

    @Override
    public String getEncodingName() {
        throw new UnsupportedOperationException("GroupByIdBlock does not support serialization");
    }

    @Override
    public Block copyPositions(int[] positions, int offset, int length) {
        return this.block.copyPositions(positions, offset, length);
    }

    public String toString() {
        return "GroupByIdBlock{groupCount=" + this.groupCount + ", positionCount=" + this.getPositionCount() + '}';
    }

    @Override
    public Block getLoadedBlock() {
        return this.block.getLoadedBlock();
    }

    @Override
    public byte getByteUnchecked(int internalPosition) {
        return this.block.getByte(internalPosition);
    }

    @Override
    public short getShortUnchecked(int internalPosition) {
        return this.block.getShort(internalPosition);
    }

    @Override
    public int getIntUnchecked(int internalPosition) {
        return this.block.getInt(internalPosition);
    }

    @Override
    public long getLongUnchecked(int internalPosition) {
        return this.block.getLong(internalPosition);
    }

    @Override
    public long getLongUnchecked(int internalPosition, int offset) {
        return this.block.getLong(internalPosition, offset);
    }

    @Override
    public Slice getSliceUnchecked(int internalPosition, int offset, int length) {
        return this.block.getSlice(internalPosition, offset, length);
    }

    @Override
    public int getSliceLengthUnchecked(int internalPosition) {
        return this.block.getSliceLength(internalPosition);
    }

    @Override
    public Block getBlockUnchecked(int internalPosition) {
        return this.block.getBlock(internalPosition);
    }

    @Override
    public int getOffsetBase() {
        return 0;
    }

    @Override
    public boolean isNullUnchecked(int internalPosition) {
        return this.block.isNull(internalPosition);
    }

    @Override
    public Block appendNull() {
        throw new UnsupportedOperationException("GroupByIdBlock does not support appendNull()");
    }
}

