/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.jdbc.internal.spi;

import com.facebook.presto.jdbc.internal.spi.ColumnHandle;
import com.facebook.presto.jdbc.internal.spi.connector.ConnectorPartitioningHandle;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

public class ConnectorTablePartitioning {
    private final ConnectorPartitioningHandle partitioningHandle;
    private final List<ColumnHandle> partitioningColumns;

    public ConnectorTablePartitioning(ConnectorPartitioningHandle partitioningHandle, List<ColumnHandle> partitioningColumns) {
        this.partitioningHandle = Objects.requireNonNull(partitioningHandle, "partitioningHandle is null");
        this.partitioningColumns = Collections.unmodifiableList(new ArrayList(Objects.requireNonNull(partitioningColumns, "partitioningColumns is null")));
    }

    public ConnectorPartitioningHandle getPartitioningHandle() {
        return this.partitioningHandle;
    }

    public List<ColumnHandle> getPartitioningColumns() {
        return this.partitioningColumns;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ConnectorTablePartitioning that = (ConnectorTablePartitioning)o;
        return Objects.equals(this.partitioningHandle, that.partitioningHandle) && Objects.equals(this.partitioningColumns, that.partitioningColumns);
    }

    public int hashCode() {
        return Objects.hash(this.partitioningHandle, this.partitioningColumns);
    }
}

