/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.jdbc.internal.io.airlift.slice.testing;

import com.facebook.presto.jdbc.internal.io.airlift.slice.Slice;

public final class SliceAssertions {
    private SliceAssertions() {
    }

    public static void assertSlicesEqual(Slice actual, Slice expected) {
        if (actual == null && expected == null) {
            return;
        }
        if (actual == null) {
            throw new AssertionError((Object)"Actual is null");
        }
        if (expected == null) {
            throw new AssertionError((Object)"Expected actual to be null");
        }
        if (actual.length() != expected.length()) {
            throw new AssertionError((Object)String.format("Slices differ in size. Actual: %s, expected: %s", actual.length(), expected.length()));
        }
        for (int i = 0; i < actual.length(); ++i) {
            if (actual.getByte(i) != expected.getByte(i)) {
                throw new AssertionError((Object)String.format("Slices differ at index %s. Actual: 0x%02x, expected: 0x%02x", i, actual.getUnsignedByte(i), expected.getUnsignedByte(i)));
            }
        }
    }
}

