/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.jdbc.internal.common.block;

import com.facebook.presto.jdbc.internal.common.block.ArrayAllocator;
import com.facebook.presto.jdbc.internal.common.block.Block;
import com.facebook.presto.jdbc.internal.common.block.BlockLease;
import com.facebook.presto.jdbc.internal.common.block.ClosingBlockLease;
import com.facebook.presto.jdbc.internal.common.block.DictionaryBlock;
import com.facebook.presto.jdbc.internal.common.block.RunLengthEncodedBlock;
import java.util.Arrays;
import java.util.Objects;

public class BlockFlattener {
    private final ArrayAllocator allocator;

    public BlockFlattener(ArrayAllocator allocator) {
        this.allocator = Objects.requireNonNull(allocator, "allocator is null");
    }

    public BlockLease flatten(Block block) {
        Objects.requireNonNull(block, "block is null");
        if (block instanceof DictionaryBlock) {
            return this.flattenDictionaryBlock((DictionaryBlock)block);
        }
        if (block instanceof RunLengthEncodedBlock) {
            return BlockFlattener.flattenRunLengthEncodedBlock((RunLengthEncodedBlock)block);
        }
        return ClosingBlockLease.newLease(block, new ClosingBlockLease.Closer[0]);
    }

    private BlockLease flattenDictionaryBlock(DictionaryBlock dictionaryBlock) {
        Block dictionary = dictionaryBlock.getDictionary();
        int positionCount = dictionaryBlock.getPositionCount();
        int[] currentRemappedIds = dictionaryBlock.getRawIds();
        int currentIdsOffset = dictionaryBlock.getOffsetBase();
        int[] newRemappedIds = null;
        while (true) {
            if (dictionary instanceof DictionaryBlock) {
                dictionaryBlock = (DictionaryBlock)dictionary;
                int[] ids = dictionaryBlock.getRawIds();
                if (newRemappedIds == null) {
                    newRemappedIds = this.allocator.borrowIntArray(positionCount);
                }
                for (int i = 0; i < positionCount; ++i) {
                    newRemappedIds[i] = ids[currentRemappedIds[i + currentIdsOffset] + dictionaryBlock.getOffsetBase()];
                }
                currentRemappedIds = newRemappedIds;
                currentIdsOffset = 0;
                dictionary = dictionaryBlock.getDictionary();
                continue;
            }
            if (!(dictionary instanceof RunLengthEncodedBlock)) break;
            RunLengthEncodedBlock rle = (RunLengthEncodedBlock)dictionary;
            if (newRemappedIds == null) {
                newRemappedIds = this.allocator.borrowIntArray(positionCount);
            }
            Arrays.fill(newRemappedIds, 0, positionCount, 0);
            currentRemappedIds = newRemappedIds;
            currentIdsOffset = 0;
            dictionary = rle.getValue();
        }
        if (newRemappedIds == null) {
            return ClosingBlockLease.newLease(dictionaryBlock, new ClosingBlockLease.Closer[0]);
        }
        dictionary = new DictionaryBlock(positionCount, dictionary, currentRemappedIds);
        int[] leasedMapToReturn = newRemappedIds;
        return ClosingBlockLease.newLease(dictionary, () -> this.allocator.returnArray(leasedMapToReturn));
    }

    private static BlockLease flattenRunLengthEncodedBlock(RunLengthEncodedBlock rleBLock) {
        Block block = rleBLock;
        while (true) {
            if (block instanceof RunLengthEncodedBlock) {
                RunLengthEncodedBlock rle = block;
                block = rle.getValue();
                continue;
            }
            if (!(block instanceof DictionaryBlock)) break;
            DictionaryBlock dictionaryBlock = (DictionaryBlock)block;
            block = dictionaryBlock.getDictionary().copyRegion(dictionaryBlock.getId(0), 1);
        }
        return ClosingBlockLease.newLease(new RunLengthEncodedBlock(block, rleBLock.getPositionCount()), new ClosingBlockLease.Closer[0]);
    }
}

