/*
 * Decompiled with CFR 0.152.
 */
package com.dtflys.forest.ssl;

import com.dtflys.forest.exceptions.ForestRuntimeException;
import com.dtflys.forest.ssl.SSLKeyStore;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import org.springframework.core.io.ClassPathResource;

public class SpringSSLKeyStore
extends SSLKeyStore {
    public SpringSSLKeyStore(String id, String keystoreType, String filePath, String keystorePass, String certPass) {
        super(id, keystoreType, filePath, keystorePass, certPass);
    }

    public void init() {
        if (this.filePath.indexOf(":/") == 1 || this.filePath.indexOf(":\\") == 1 || this.filePath.startsWith("/")) {
            File file = new File(this.filePath);
            if (!file.exists()) {
                throw new ForestRuntimeException("The file of SSL KeyStore \"" + this.id + "\" " + this.filePath + " cannot be found!");
            }
            try {
                this.inputStream = new FileInputStream(file);
            }
            catch (FileNotFoundException e) {
                throw new ForestRuntimeException("An error occurred while reading he file of SSL KeyStore \"\" + id + \"\"", (Throwable)e);
            }
        }
        ClassPathResource resource = new ClassPathResource(this.filePath);
        if (!resource.exists()) {
            throw new ForestRuntimeException("The file of SSL KeyStore \"" + this.id + "\" " + this.filePath + " cannot be found!");
        }
        try {
            this.inputStream = resource.getInputStream();
        }
        catch (IOException e) {
            throw new ForestRuntimeException("An error occurred while reading he file of SSL KeyStore \"\" + id + \"\"", (Throwable)e);
        }
    }

    public InputStream getInputStream() {
        return this.inputStream;
    }
}

