/*
 * Decompiled with CFR 0.152.
 */
package com.dtflys.forest.schema;

import com.dtflys.forest.config.ForestConfiguration;
import com.dtflys.forest.exceptions.ForestRuntimeException;
import com.dtflys.forest.logging.ForestLogHandler;
import com.dtflys.forest.ssl.SpringSSLKeyStore;
import com.dtflys.forest.utils.ClientFactoryBeanUtils;
import com.dtflys.forest.utils.ForestDataType;
import com.dtflys.forest.utils.StringUtils;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.ConstructorArgumentValues;
import org.springframework.beans.factory.support.GenericBeanDefinition;
import org.springframework.beans.factory.support.ManagedMap;
import org.springframework.beans.factory.support.RootBeanDefinition;
import org.springframework.beans.factory.xml.BeanDefinitionParser;
import org.springframework.beans.factory.xml.ParserContext;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ForestConfigurationBeanDefinitionParser
implements BeanDefinitionParser {
    private static Logger log = LoggerFactory.getLogger(ForestConfigurationBeanDefinitionParser.class);
    private static final Class configurationBeanClass = ForestConfiguration.class;
    private static final Class sslKeyStoreBeanClass = SpringSSLKeyStore.class;

    public BeanDefinition parse(Element element, ParserContext parserContext) {
        Method[] methods;
        RootBeanDefinition beanDefinition = new RootBeanDefinition();
        beanDefinition.setBeanClass(configurationBeanClass);
        beanDefinition.setLazyInit(false);
        beanDefinition.setFactoryMethodName("configuration");
        String id = element.getAttribute("id");
        id = ClientFactoryBeanUtils.getBeanId(id, configurationBeanClass, parserContext);
        if (id != null && id.length() > 0) {
            if (parserContext.getRegistry().containsBeanDefinition(id)) {
                throw new IllegalStateException("Duplicate spring bean id " + id);
            }
            parserContext.getRegistry().registerBeanDefinition(id, (BeanDefinition)beanDefinition);
        }
        for (Method method : methods = configurationBeanClass.getMethods()) {
            String attributeName;
            String attributeValue;
            Class<?> paramType;
            String methodName = method.getName();
            Class<?>[] paramTypes = method.getParameterTypes();
            if (paramTypes.length == 0 || paramTypes.length > 1 || Collections.class.isAssignableFrom(paramType = paramTypes[0]) || Map.class.isAssignableFrom(paramType) || methodName.length() < 3 || !methodName.startsWith("set") || !StringUtils.isNotEmpty((String)(attributeValue = element.getAttribute(attributeName = methodName.substring(3, 4).toLowerCase() + methodName.substring(4))))) continue;
            if ("backend".equals(attributeName)) {
                beanDefinition.getPropertyValues().addPropertyValue("backendName", (Object)attributeValue);
                continue;
            }
            if ("logHandler".equals(attributeName)) {
                try {
                    Class<?> clazz = Class.forName(attributeValue);
                    if (!ForestLogHandler.class.isAssignableFrom(clazz)) {
                        throw new ForestRuntimeException("property 'logHandler' must be a class extending from com.dtflys.forest.logging.ForestLogHandler");
                    }
                    ForestLogHandler handler = (ForestLogHandler)clazz.newInstance();
                    beanDefinition.getPropertyValues().addPropertyValue("logHandler", (Object)handler);
                    continue;
                }
                catch (ClassNotFoundException e) {
                    throw new ForestRuntimeException((Throwable)e);
                }
                catch (IllegalAccessException e) {
                    throw new ForestRuntimeException((Throwable)e);
                }
                catch (InstantiationException e) {
                    throw new ForestRuntimeException((Throwable)e);
                }
            }
            beanDefinition.getPropertyValues().addPropertyValue(attributeName, (Object)attributeValue);
        }
        this.parseChildren(element.getChildNodes(), beanDefinition);
        log.info("[Forest] Created Forest Configuration Bean: " + beanDefinition);
        return beanDefinition;
    }

    public void parseChildren(NodeList nodeList, RootBeanDefinition beanDefinition) {
        int nodesLength = nodeList.getLength();
        if (nodesLength > 0) {
            ManagedMap varMap = new ManagedMap();
            ManagedMap sslKeyStoreMap = new ManagedMap();
            ManagedMap converterMap = new ManagedMap();
            for (int i = 0; i < nodesLength; ++i) {
                Node node = nodeList.item(i);
                if (!(node instanceof Element)) continue;
                Element elem = (Element)node;
                String elemName = elem.getLocalName();
                if (elemName.equals("var")) {
                    this.parseVariable(elem, (ManagedMap<String, Object>)varMap);
                    continue;
                }
                if (elemName.equals("ssl-keystore")) {
                    this.parseSSLKeyStore(elem, (ManagedMap<String, BeanDefinition>)sslKeyStoreMap);
                    continue;
                }
                if (!elemName.equals("converter")) continue;
                ForestConfigurationBeanDefinitionParser.parseConverter(elem, (ManagedMap<ForestDataType, BeanDefinition>)converterMap);
            }
            beanDefinition.getPropertyValues().addPropertyValue("variables", (Object)varMap);
            beanDefinition.getPropertyValues().addPropertyValue("sslKeyStores", (Object)sslKeyStoreMap);
            beanDefinition.getPropertyValues().addPropertyValue("converterMap", (Object)converterMap);
        }
    }

    public void parseVariable(Element elem, ManagedMap<String, Object> varMap) {
        String name = elem.getAttribute("name");
        String value = elem.getAttribute("value");
        varMap.put((Object)name, (Object)value);
    }

    public void parseSSLKeyStore(Element elem, ManagedMap<String, BeanDefinition> sslKeyStoreMap) {
        String id = elem.getAttribute("id");
        String filePath = elem.getAttribute("file");
        String keystoreType = elem.getAttribute("type");
        String keystorePass = elem.getAttribute("keystorePass");
        String certPass = elem.getAttribute("certPass");
        String protocolsStr = elem.getAttribute("protocols");
        String cipherSuitesStr = elem.getAttribute("cipher-suites");
        if (StringUtils.isEmpty((String)keystoreType)) {
            keystoreType = "jks";
        }
        if (StringUtils.isEmpty((String)filePath)) {
            throw new ForestRuntimeException("The file of SSL KeyStore \"" + id + "\" is empty!");
        }
        BeanDefinition beanDefinition = ForestConfigurationBeanDefinitionParser.createSSLKeyStoreBean(id, keystoreType, filePath, keystorePass, certPass, protocolsStr, cipherSuitesStr);
        sslKeyStoreMap.put((Object)id, (Object)beanDefinition);
    }

    public static BeanDefinition createSSLKeyStoreBean(String id, String keystoreType, String filePath, String keystorePass, String certPass, String protocolsStr, String cipherSuitesStr) {
        int i;
        String[] strs;
        GenericBeanDefinition beanDefinition = new GenericBeanDefinition();
        beanDefinition.setBeanClassName(sslKeyStoreBeanClass.getName());
        ConstructorArgumentValues beanDefValues = beanDefinition.getConstructorArgumentValues();
        beanDefValues.addGenericArgumentValue((Object)id);
        beanDefValues.addGenericArgumentValue((Object)keystoreType);
        beanDefValues.addGenericArgumentValue((Object)filePath);
        beanDefValues.addGenericArgumentValue((Object)keystorePass);
        beanDefValues.addGenericArgumentValue((Object)certPass);
        if (StringUtils.isNotEmpty((String)protocolsStr)) {
            strs = protocolsStr.split("[ /t]*,[ /t]*");
            String[] protocols = new String[strs.length];
            for (i = 0; i < strs.length; ++i) {
                protocols[i] = strs[i].trim();
            }
            beanDefinition.getPropertyValues().add("protocols", (Object)protocols);
        }
        if (StringUtils.isNotEmpty((String)cipherSuitesStr)) {
            strs = cipherSuitesStr.split("[ /t]*,[ /t]*");
            String[] cipherSuites = new String[strs.length];
            for (i = 0; i < strs.length; ++i) {
                cipherSuites[i] = strs[i].trim();
            }
            beanDefinition.getPropertyValues().add("cipherSuites", (Object)cipherSuites);
        }
        return beanDefinition;
    }

    private static void parseConverter(Element elem, ManagedMap<ForestDataType, BeanDefinition> converterMap) {
        String dataTypeName = elem.getAttribute("dataType");
        ForestDataType dataType = ForestDataType.findOrCreateDataType((String)dataTypeName);
        if (dataType == null) {
            throw new ForestRuntimeException("Cannot find data type named '" + dataTypeName + "'");
        }
        String className = elem.getAttribute("class");
        BeanDefinition definition = ForestConfigurationBeanDefinitionParser.createConverterBean(className);
        NodeList nodeList = elem.getChildNodes();
        int nodeLength = nodeList.getLength();
        if (nodeLength > 0) {
            for (int i = 0; i < nodeLength; ++i) {
                Element childElem;
                String childElemName;
                Node node = nodeList.item(i);
                if (!(node instanceof Element) || !(childElemName = (childElem = (Element)node).getLocalName()).equals("parameter")) continue;
                String paramName = childElem.getAttribute("name");
                String paramValue = childElem.getAttribute("value");
                definition.getPropertyValues().addPropertyValue(paramName, (Object)paramValue);
            }
        }
        converterMap.put((Object)dataType, (Object)definition);
    }

    public static BeanDefinition createConverterBean(String className) {
        GenericBeanDefinition beanDefinition = new GenericBeanDefinition();
        beanDefinition.setBeanClassName(className);
        return beanDefinition;
    }
}

