/*
 * Decompiled with CFR 0.152.
 */
package com.dtflys.forest.scanner;

import com.dtflys.forest.annotation.BaseLifeCycle;
import com.dtflys.forest.annotation.MethodLifeCycle;
import com.dtflys.forest.file.SpringResource;
import com.dtflys.forest.http.body.MultipartRequestBodyBuilder;
import com.dtflys.forest.http.body.RequestBodyBuilder;
import com.dtflys.forest.http.body.ResourceRequestBodyBuilder;
import com.dtflys.forest.multipart.ForestMultipartFactory;
import com.dtflys.forest.utils.ClientFactoryBeanUtils;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Set;
import org.springframework.beans.factory.annotation.AnnotatedBeanDefinition;
import org.springframework.beans.factory.config.BeanDefinitionHolder;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.GenericBeanDefinition;
import org.springframework.context.annotation.ClassPathBeanDefinitionScanner;
import org.springframework.core.io.Resource;
import org.springframework.core.type.classreading.MetadataReader;
import org.springframework.core.type.classreading.MetadataReaderFactory;
import org.springframework.core.type.filter.TypeFilter;

public class ClassPathClientScanner
extends ClassPathBeanDefinitionScanner {
    private final String configurationId;
    private boolean allInterfaces = true;

    public ClassPathClientScanner(String configurationId, BeanDefinitionRegistry registry) {
        super(registry, false);
        this.configurationId = configurationId;
        this.registerFilters();
        this.registerMultipartTypes();
    }

    public void registerMultipartTypes() {
        ForestMultipartFactory.registerFactory(Resource.class, SpringResource.class);
        RequestBodyBuilder.registerBodyBuilder(Resource.class, (RequestBodyBuilder)new ResourceRequestBodyBuilder());
        try {
            Class<?> multipartFileClass = Class.forName("org.springframework.web.multipart.MultipartFile");
            Class<?> springMultipartFileClass = Class.forName("com.dtflys.forest.file.SpringMultipartFile");
            ForestMultipartFactory.registerFactory(multipartFileClass, springMultipartFileClass);
            RequestBodyBuilder.registerBodyBuilder(multipartFileClass, (RequestBodyBuilder)new MultipartRequestBodyBuilder());
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
    }

    public void registerFilters() {
        if (this.allInterfaces) {
            this.addIncludeFilter(new TypeFilter(){

                public boolean match(MetadataReader metadataReader, MetadataReaderFactory metadataReaderFactory) throws IOException {
                    Method[] methods;
                    Annotation[] baseAnns;
                    String className = metadataReader.getClassMetadata().getClassName();
                    Class<?> clazz = null;
                    try {
                        clazz = Class.forName(className);
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        // empty catch block
                    }
                    if (clazz == null) {
                        return false;
                    }
                    for (Annotation ann : baseAnns = clazz.getAnnotations()) {
                        BaseLifeCycle lcAnn = ann.annotationType().getAnnotation(BaseLifeCycle.class);
                        if (lcAnn == null) continue;
                        return true;
                    }
                    for (Method method : methods = clazz.getMethods()) {
                        Annotation[] mthAnns;
                        for (Annotation ann : mthAnns = method.getAnnotations()) {
                            MethodLifeCycle mlcAnn = ann.annotationType().getAnnotation(MethodLifeCycle.class);
                            if (mlcAnn == null) continue;
                            return true;
                        }
                    }
                    return false;
                }
            });
        }
        this.addExcludeFilter(new TypeFilter(){

            public boolean match(MetadataReader metadataReader, MetadataReaderFactory metadataReaderFactory) throws IOException {
                String className = metadataReader.getClassMetadata().getClassName();
                return className.endsWith("package-info");
            }
        });
    }

    private void processBeanDefinitions(Set<BeanDefinitionHolder> beanDefinitions) {
        for (BeanDefinitionHolder holder : beanDefinitions) {
            GenericBeanDefinition definition = (GenericBeanDefinition)holder.getBeanDefinition();
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("[Forest] Creating Forest Client Bean with name '" + holder.getBeanName() + "' and Proxy of '" + definition.getBeanClassName() + "' client interface"));
            }
            String beanClassName = definition.getBeanClassName();
            ClientFactoryBeanUtils.setupClientFactoryBean((AbstractBeanDefinition)definition, this.configurationId, beanClassName);
            this.logger.info((Object)("[Forest] Created Forest Client Bean with name '" + holder.getBeanName() + "' and Proxy of '" + beanClassName + "' client interface"));
        }
    }

    public Set<BeanDefinitionHolder> doScan(String ... basePackages) {
        Set beanDefinitions = super.doScan(basePackages);
        if (beanDefinitions.isEmpty()) {
            this.logger.warn((Object)("[Forest] No Forest client is found in package '" + Arrays.toString(basePackages) + "'."));
        }
        this.processBeanDefinitions(beanDefinitions);
        return beanDefinitions;
    }

    protected boolean isCandidateComponent(AnnotatedBeanDefinition beanDefinition) {
        return beanDefinition.getMetadata().isInterface() && beanDefinition.getMetadata().isIndependent();
    }
}

