/*
 * Decompiled with CFR 0.152.
 */
package com.drew.metadata.icc;

import com.drew.lang.ByteArrayReader;
import com.drew.lang.annotations.NotNull;
import com.drew.lang.annotations.Nullable;
import com.drew.metadata.TagDescriptor;
import com.drew.metadata.icc.IccDirectory;
import com.drew.metadata.icc.IccReader;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.text.DecimalFormat;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IccDescriptor
extends TagDescriptor<IccDirectory> {
    private static final int ICC_TAG_TYPE_TEXT = 1952807028;
    private static final int ICC_TAG_TYPE_DESC = 1684370275;
    private static final int ICC_TAG_TYPE_SIG = 1936287520;
    private static final int ICC_TAG_TYPE_MEAS = 1835360627;
    private static final int ICC_TAG_TYPE_XYZ_ARRAY = 1482250784;
    private static final int ICC_TAG_TYPE_MLUC = 1835824483;
    private static final int ICC_TAG_TYPE_CURV = 1668641398;

    public IccDescriptor(@NotNull IccDirectory directory) {
        super(directory);
    }

    @Override
    public String getDescription(int tagType) {
        switch (tagType) {
            case 8: {
                return this.getProfileVersionDescription();
            }
            case 12: {
                return this.getProfileClassDescription();
            }
            case 40: {
                return this.getPlatformDescription();
            }
            case 64: {
                return this.getRenderingIntentDescription();
            }
        }
        if (tagType > 0x20202020 && tagType < 0x7A7A7A7A) {
            return this.getTagDataString(tagType);
        }
        return super.getDescription(tagType);
    }

    @Nullable
    private String getTagDataString(int tagType) {
        try {
            byte[] bytes = ((IccDirectory)this._directory).getByteArray(tagType);
            if (bytes == null) {
                return ((IccDirectory)this._directory).getString(tagType);
            }
            ByteArrayReader reader = new ByteArrayReader(bytes);
            int iccTagType = reader.getInt32(0);
            switch (iccTagType) {
                case 1952807028: {
                    try {
                        return new String(bytes, 8, bytes.length - 8 - 1, "ASCII");
                    }
                    catch (UnsupportedEncodingException ex) {
                        return new String(bytes, 8, bytes.length - 8 - 1);
                    }
                }
                case 1684370275: {
                    int stringLength = reader.getInt32(8);
                    return new String(bytes, 12, stringLength - 1);
                }
                case 1936287520: {
                    return IccReader.getStringFromInt32(reader.getInt32(8));
                }
                case 1835360627: {
                    String illuminantString;
                    String geometryString;
                    String observerString;
                    int observerType = reader.getInt32(8);
                    float x = reader.getS15Fixed16(12);
                    float y = reader.getS15Fixed16(16);
                    float z = reader.getS15Fixed16(20);
                    int geometryType = reader.getInt32(24);
                    float flare = reader.getS15Fixed16(28);
                    int illuminantType = reader.getInt32(32);
                    switch (observerType) {
                        case 0: {
                            observerString = "Unknown";
                            break;
                        }
                        case 1: {
                            observerString = "1931 2\u00b0";
                            break;
                        }
                        case 2: {
                            observerString = "1964 10\u00b0";
                            break;
                        }
                        default: {
                            observerString = String.format("Unknown %d", observerType);
                        }
                    }
                    switch (geometryType) {
                        case 0: {
                            geometryString = "Unknown";
                            break;
                        }
                        case 1: {
                            geometryString = "0/45 or 45/0";
                            break;
                        }
                        case 2: {
                            geometryString = "0/d or d/0";
                            break;
                        }
                        default: {
                            geometryString = String.format("Unknown %d", observerType);
                        }
                    }
                    switch (illuminantType) {
                        case 0: {
                            illuminantString = "unknown";
                            break;
                        }
                        case 1: {
                            illuminantString = "D50";
                            break;
                        }
                        case 2: {
                            illuminantString = "D65";
                            break;
                        }
                        case 3: {
                            illuminantString = "D93";
                            break;
                        }
                        case 4: {
                            illuminantString = "F2";
                            break;
                        }
                        case 5: {
                            illuminantString = "D55";
                            break;
                        }
                        case 6: {
                            illuminantString = "A";
                            break;
                        }
                        case 7: {
                            illuminantString = "Equi-Power (E)";
                            break;
                        }
                        case 8: {
                            illuminantString = "F8";
                            break;
                        }
                        default: {
                            illuminantString = String.format("Unknown %d", illuminantType);
                        }
                    }
                    DecimalFormat format = new DecimalFormat("0.###");
                    return String.format("%s Observer, Backing (%s, %s, %s), Geometry %s, Flare %d%%, Illuminant %s", observerString, format.format(x), format.format(y), format.format(z), geometryString, Math.round(flare * 100.0f), illuminantString);
                }
                case 1482250784: {
                    StringBuilder res = new StringBuilder();
                    DecimalFormat format = new DecimalFormat("0.####");
                    int count = (bytes.length - 8) / 12;
                    for (int i = 0; i < count; ++i) {
                        float x = reader.getS15Fixed16(8 + i * 12);
                        float y = reader.getS15Fixed16(8 + i * 12 + 4);
                        float z = reader.getS15Fixed16(8 + i * 12 + 8);
                        if (i > 0) {
                            res.append(", ");
                        }
                        res.append("(").append(format.format(x)).append(", ").append(format.format(y)).append(", ").append(format.format(z)).append(")");
                    }
                    return res.toString();
                }
                case 1835824483: {
                    int int1 = reader.getInt32(8);
                    StringBuilder res = new StringBuilder();
                    res.append(int1);
                    for (int i = 0; i < int1; ++i) {
                        String name;
                        String str = IccReader.getStringFromInt32(reader.getInt32(16 + i * 12));
                        int len = reader.getInt32(16 + i * 12 + 4);
                        int ofs = reader.getInt32(16 + i * 12 + 8);
                        try {
                            name = new String(bytes, ofs, len, "UTF-16BE");
                        }
                        catch (UnsupportedEncodingException ex) {
                            name = new String(bytes, ofs, len);
                        }
                        res.append(" ").append(str).append("(").append(name).append(")");
                    }
                    return res.toString();
                }
                case 1668641398: {
                    int num = reader.getInt32(8);
                    StringBuilder res = new StringBuilder();
                    for (int i = 0; i < num; ++i) {
                        if (i != 0) {
                            res.append(", ");
                        }
                        res.append(IccDescriptor.formatDoubleAsString((double)reader.getUInt16(12 + i * 2) / 65535.0, 7, false));
                    }
                    return res.toString();
                }
            }
            return String.format("%s (0x%08X): %d bytes", IccReader.getStringFromInt32(iccTagType), iccTagType, bytes.length);
        }
        catch (IOException e) {
            return null;
        }
    }

    @NotNull
    public static String formatDoubleAsString(double value, int precision, boolean zeroes) {
        long rest;
        if (precision < 1) {
            return "" + Math.round(value);
        }
        long intPart = Math.abs((long)value);
        long restKept = rest = (long)((int)Math.round((Math.abs(value) - (double)intPart) * Math.pow(10.0, precision)));
        String res = "";
        for (int i = precision; i > 0; --i) {
            byte cour = (byte)Math.abs(rest % 10L);
            rest /= 10L;
            if (res.length() <= 0 && !zeroes && cour == 0 && i != 1) continue;
            res = cour + res;
        }
        boolean isNegative = value < 0.0 && ((intPart += rest) != 0L || restKept != 0L);
        return (isNegative ? "-" : "") + intPart + "." + res;
    }

    @Nullable
    private String getRenderingIntentDescription() {
        return this.getIndexedDescription(64, "Perceptual", "Media-Relative Colorimetric", "Saturation", "ICC-Absolute Colorimetric");
    }

    @Nullable
    private String getPlatformDescription() {
        int i;
        String str = ((IccDirectory)this._directory).getString(40);
        if (str == null) {
            return null;
        }
        try {
            i = IccDescriptor.getInt32FromString(str);
        }
        catch (IOException e) {
            return str;
        }
        switch (i) {
            case 1095782476: {
                return "Apple Computer, Inc.";
            }
            case 1297303124: {
                return "Microsoft Corporation";
            }
            case 1397180704: {
                return "Silicon Graphics, Inc.";
            }
            case 1398099543: {
                return "Sun Microsystems, Inc.";
            }
            case 1413959252: {
                return "Taligent, Inc.";
            }
        }
        return String.format("Unknown (%s)", str);
    }

    @Nullable
    private String getProfileClassDescription() {
        int i;
        String str = ((IccDirectory)this._directory).getString(12);
        if (str == null) {
            return null;
        }
        try {
            i = IccDescriptor.getInt32FromString(str);
        }
        catch (IOException e) {
            return str;
        }
        switch (i) {
            case 1935896178: {
                return "Input Device";
            }
            case 1835955314: {
                return "Display Device";
            }
            case 1886549106: {
                return "Output Device";
            }
            case 1818848875: {
                return "DeviceLink";
            }
            case 1936744803: {
                return "ColorSpace Conversion";
            }
            case 1633842036: {
                return "Abstract";
            }
            case 1852662636: {
                return "Named Color";
            }
        }
        return String.format("Unknown (%s)", str);
    }

    @Nullable
    private String getProfileVersionDescription() {
        Integer value = ((IccDirectory)this._directory).getInteger(8);
        if (value == null) {
            return null;
        }
        int m = (value & 0xFF000000) >> 24;
        int r = (value & 0xF00000) >> 20;
        int R = (value & 0xF0000) >> 16;
        return String.format("%d.%d.%d", m, r, R);
    }

    private static int getInt32FromString(@NotNull String string) throws IOException {
        byte[] bytes = string.getBytes();
        return new ByteArrayReader(bytes).getInt32(0);
    }
}

