/*
 * Decompiled with CFR 0.152.
 */
package com.drew.metadata.exif.makernotes;

import com.drew.lang.Rational;
import com.drew.lang.annotations.NotNull;
import com.drew.lang.annotations.Nullable;
import com.drew.metadata.TagDescriptor;
import com.drew.metadata.exif.makernotes.NikonType2MakernoteDirectory;
import java.text.DecimalFormat;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NikonType2MakernoteDescriptor
extends TagDescriptor<NikonType2MakernoteDirectory> {
    public NikonType2MakernoteDescriptor(@NotNull NikonType2MakernoteDirectory directory) {
        super(directory);
    }

    @Override
    @Nullable
    public String getDescription(int tagType) {
        switch (tagType) {
            case 13: {
                return this.getProgramShiftDescription();
            }
            case 14: {
                return this.getExposureDifferenceDescription();
            }
            case 132: {
                return this.getLensDescription();
            }
            case 146: {
                return this.getHueAdjustmentDescription();
            }
            case 141: {
                return this.getColorModeDescription();
            }
            case 18: {
                return this.getAutoFlashCompensationDescription();
            }
            case 23: {
                return this.getFlashExposureCompensationDescription();
            }
            case 24: {
                return this.getFlashBracketCompensationDescription();
            }
            case 28: {
                return this.getExposureTuningDescription();
            }
            case 139: {
                return this.getLensStopsDescription();
            }
            case 30: {
                return this.getColorSpaceDescription();
            }
            case 34: {
                return this.getActiveDLightingDescription();
            }
            case 42: {
                return this.getVignetteControlDescription();
            }
            case 2: {
                return this.getIsoSettingDescription();
            }
            case 134: {
                return this.getDigitalZoomDescription();
            }
            case 135: {
                return this.getFlashUsedDescription();
            }
            case 136: {
                return this.getAutoFocusPositionDescription();
            }
            case 1: {
                return this.getFirmwareVersionDescription();
            }
            case 131: {
                return this.getLensTypeDescription();
            }
            case 137: {
                return this.getShootingModeDescription();
            }
            case 147: {
                return this.getNEFCompressionDescription();
            }
            case 177: {
                return this.getHighISONoiseReductionDescription();
            }
            case 182: {
                return this.getPowerUpTimeDescription();
            }
        }
        return super.getDescription(tagType);
    }

    @Nullable
    public String getPowerUpTimeDescription() {
        return this.getEpochTimeDescription(182);
    }

    @Nullable
    public String getHighISONoiseReductionDescription() {
        return this.getIndexedDescription(177, "Off", "Minimal", "Low", null, "Normal", null, "High");
    }

    @Nullable
    public String getFlashUsedDescription() {
        return this.getIndexedDescription(135, "Flash Not Used", "Manual Flash", null, "Flash Not Ready", null, null, null, "External Flash", "Fired, Commander Mode", "Fired, TTL Mode");
    }

    @Nullable
    public String getNEFCompressionDescription() {
        return this.getIndexedDescription(147, 1, "Lossy (Type 1)", null, "Uncompressed", null, null, null, "Lossless", "Lossy (Type 2)");
    }

    @Nullable
    public String getShootingModeDescription() {
        return this.getBitFlagDescription(137, new String[]{"Single Frame", "Continuous"}, "Delay", null, "PC Control", "Exposure Bracketing", "Auto ISO", "White-Balance Bracketing", "IR Control");
    }

    @Nullable
    public String getLensTypeDescription() {
        return this.getBitFlagDescription(131, new String[]{"AF", "MF"}, "D", "G", "VR");
    }

    @Nullable
    public String getColorSpaceDescription() {
        return this.getIndexedDescription(30, 1, "sRGB", "Adobe RGB");
    }

    @Nullable
    public String getActiveDLightingDescription() {
        Integer value = ((NikonType2MakernoteDirectory)this._directory).getInteger(34);
        if (value == null) {
            return null;
        }
        switch (value) {
            case 0: {
                return "Off";
            }
            case 1: {
                return "Light";
            }
            case 3: {
                return "Normal";
            }
            case 5: {
                return "High";
            }
            case 7: {
                return "Extra High";
            }
            case 65535: {
                return "Auto";
            }
        }
        return "Unknown (" + value + ")";
    }

    @Nullable
    public String getVignetteControlDescription() {
        Integer value = ((NikonType2MakernoteDirectory)this._directory).getInteger(42);
        if (value == null) {
            return null;
        }
        switch (value) {
            case 0: {
                return "Off";
            }
            case 1: {
                return "Low";
            }
            case 3: {
                return "Normal";
            }
            case 5: {
                return "High";
            }
        }
        return "Unknown (" + value + ")";
    }

    @Nullable
    public String getAutoFocusPositionDescription() {
        int[] values = ((NikonType2MakernoteDirectory)this._directory).getIntArray(136);
        if (values == null) {
            return null;
        }
        if (values.length != 4 || values[0] != 0 || values[2] != 0 || values[3] != 0) {
            return "Unknown (" + ((NikonType2MakernoteDirectory)this._directory).getString(136) + ")";
        }
        switch (values[1]) {
            case 0: {
                return "Centre";
            }
            case 1: {
                return "Top";
            }
            case 2: {
                return "Bottom";
            }
            case 3: {
                return "Left";
            }
            case 4: {
                return "Right";
            }
        }
        return "Unknown (" + values[1] + ")";
    }

    @Nullable
    public String getDigitalZoomDescription() {
        Rational value = ((NikonType2MakernoteDirectory)this._directory).getRational(134);
        if (value == null) {
            return null;
        }
        return value.intValue() == 1 ? "No digital zoom" : value.toSimpleString(true) + "x digital zoom";
    }

    @Nullable
    public String getProgramShiftDescription() {
        return this.getEVDescription(13);
    }

    @Nullable
    public String getExposureDifferenceDescription() {
        return this.getEVDescription(14);
    }

    @Nullable
    public String getAutoFlashCompensationDescription() {
        return this.getEVDescription(18);
    }

    @Nullable
    public String getFlashExposureCompensationDescription() {
        return this.getEVDescription(23);
    }

    @Nullable
    public String getFlashBracketCompensationDescription() {
        return this.getEVDescription(24);
    }

    @Nullable
    public String getExposureTuningDescription() {
        return this.getEVDescription(28);
    }

    @Nullable
    public String getLensStopsDescription() {
        return this.getEVDescription(139);
    }

    @Nullable
    private String getEVDescription(int tagType) {
        int[] values = ((NikonType2MakernoteDirectory)this._directory).getIntArray(tagType);
        if (values == null || values.length < 2) {
            return null;
        }
        if (values.length < 3 || values[2] == 0) {
            return null;
        }
        DecimalFormat decimalFormat = new DecimalFormat("0.##");
        double ev = (double)(values[0] * values[1]) / (double)values[2];
        return decimalFormat.format(ev) + " EV";
    }

    @Nullable
    public String getIsoSettingDescription() {
        int[] values = ((NikonType2MakernoteDirectory)this._directory).getIntArray(2);
        if (values == null) {
            return null;
        }
        if (values[0] != 0 || values[1] == 0) {
            return "Unknown (" + ((NikonType2MakernoteDirectory)this._directory).getString(2) + ")";
        }
        return "ISO " + values[1];
    }

    @Nullable
    public String getLensDescription() {
        return this.getLensSpecificationDescription(132);
    }

    @Nullable
    public String getHueAdjustmentDescription() {
        return this.getFormattedString(146, "%s degrees");
    }

    @Nullable
    public String getColorModeDescription() {
        String value = ((NikonType2MakernoteDirectory)this._directory).getString(141);
        return value == null ? null : (value.startsWith("MODE1") ? "Mode I (sRGB)" : value);
    }

    @Nullable
    public String getFirmwareVersionDescription() {
        return this.getVersionBytesDescription(1, 2);
    }
}

