/*
 * Decompiled with CFR 0.152.
 */
package com.drew.imaging.png;

import com.drew.imaging.png.PngChromaticities;
import com.drew.imaging.png.PngChunk;
import com.drew.imaging.png.PngChunkReader;
import com.drew.imaging.png.PngChunkType;
import com.drew.imaging.png.PngHeader;
import com.drew.imaging.png.PngProcessingException;
import com.drew.lang.ByteConvert;
import com.drew.lang.DateUtil;
import com.drew.lang.KeyValuePair;
import com.drew.lang.RandomAccessStreamReader;
import com.drew.lang.SequentialByteArrayReader;
import com.drew.lang.SequentialReader;
import com.drew.lang.StreamReader;
import com.drew.lang.StringUtil;
import com.drew.lang.annotations.NotNull;
import com.drew.metadata.Metadata;
import com.drew.metadata.file.FileMetadataReader;
import com.drew.metadata.icc.IccReader;
import com.drew.metadata.png.PngChromaticitiesDirectory;
import com.drew.metadata.png.PngDirectory;
import com.drew.metadata.xmp.XmpReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.zip.InflaterInputStream;

public class PngMetadataReader {
    private static Set<PngChunkType> _desiredChunkTypes;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public static Metadata readMetadata(@NotNull File file) throws PngProcessingException, IOException {
        Metadata metadata;
        FileInputStream inputStream = new FileInputStream(file);
        try {
            metadata = PngMetadataReader.readMetadata(inputStream);
        }
        finally {
            ((InputStream)inputStream).close();
        }
        new FileMetadataReader().read(file, metadata);
        return metadata;
    }

    @NotNull
    public static Metadata readMetadata(@NotNull InputStream inputStream) throws PngProcessingException, IOException {
        Iterable<PngChunk> chunks = new PngChunkReader().extract(new StreamReader(inputStream), _desiredChunkTypes);
        Metadata metadata = new Metadata();
        for (PngChunk chunk : chunks) {
            try {
                PngMetadataReader.processChunk(metadata, chunk);
            }
            catch (Exception e) {
                e.printStackTrace(System.err);
            }
        }
        return metadata;
    }

    private static void processChunk(@NotNull Metadata metadata, @NotNull PngChunk chunk) throws PngProcessingException, IOException {
        PngChunkType chunkType = chunk.getType();
        byte[] bytes = chunk.getBytes();
        if (chunkType.equals(PngChunkType.IHDR)) {
            PngHeader header = new PngHeader(bytes);
            PngDirectory directory = new PngDirectory(PngChunkType.IHDR);
            directory.setInt(1, header.getImageWidth());
            directory.setInt(2, header.getImageHeight());
            directory.setInt(3, header.getBitsPerSample());
            directory.setInt(4, header.getColorType().getNumericValue());
            directory.setInt(5, header.getCompressionType());
            directory.setInt(6, header.getFilterMethod());
            directory.setInt(7, header.getInterlaceMethod());
            metadata.addDirectory(directory);
        } else if (chunkType.equals(PngChunkType.PLTE)) {
            PngDirectory directory = new PngDirectory(PngChunkType.PLTE);
            directory.setInt(8, bytes.length / 3);
            metadata.addDirectory(directory);
        } else if (chunkType.equals(PngChunkType.tRNS)) {
            PngDirectory directory = new PngDirectory(PngChunkType.tRNS);
            directory.setInt(9, 1);
            metadata.addDirectory(directory);
        } else if (chunkType.equals(PngChunkType.sRGB)) {
            byte srgbRenderingIntent = bytes[0];
            PngDirectory directory = new PngDirectory(PngChunkType.sRGB);
            directory.setInt(10, srgbRenderingIntent);
            metadata.addDirectory(directory);
        } else if (chunkType.equals(PngChunkType.cHRM)) {
            PngChromaticities chromaticities = new PngChromaticities(bytes);
            PngChromaticitiesDirectory directory = new PngChromaticitiesDirectory();
            directory.setInt(1, chromaticities.getWhitePointX());
            directory.setInt(2, chromaticities.getWhitePointY());
            directory.setInt(3, chromaticities.getRedX());
            directory.setInt(4, chromaticities.getRedY());
            directory.setInt(5, chromaticities.getGreenX());
            directory.setInt(6, chromaticities.getGreenY());
            directory.setInt(7, chromaticities.getBlueX());
            directory.setInt(8, chromaticities.getBlueY());
            metadata.addDirectory(directory);
        } else if (chunkType.equals(PngChunkType.gAMA)) {
            int gammaInt = ByteConvert.toInt32BigEndian(bytes);
            new SequentialByteArrayReader(bytes).getInt32();
            PngDirectory directory = new PngDirectory(PngChunkType.gAMA);
            directory.setDouble(11, (double)gammaInt / 100000.0);
            metadata.addDirectory(directory);
        } else if (chunkType.equals(PngChunkType.iCCP)) {
            SequentialByteArrayReader reader = new SequentialByteArrayReader(bytes);
            String profileName = reader.getNullTerminatedString(79);
            PngDirectory directory = new PngDirectory(PngChunkType.iCCP);
            directory.setString(12, profileName);
            byte compressionMethod = reader.getInt8();
            if (compressionMethod == 0) {
                int bytesLeft = bytes.length - profileName.length() - 2;
                byte[] compressedProfile = ((SequentialReader)reader).getBytes(bytesLeft);
                InflaterInputStream inflateStream = new InflaterInputStream(new ByteArrayInputStream(compressedProfile));
                new IccReader().extract(new RandomAccessStreamReader(inflateStream), metadata, directory);
                inflateStream.close();
            } else {
                directory.addError("Invalid compression method value");
            }
            metadata.addDirectory(directory);
        } else if (chunkType.equals(PngChunkType.bKGD)) {
            PngDirectory directory = new PngDirectory(PngChunkType.bKGD);
            directory.setByteArray(15, bytes);
            metadata.addDirectory(directory);
        } else if (chunkType.equals(PngChunkType.tEXt)) {
            SequentialByteArrayReader reader = new SequentialByteArrayReader(bytes);
            String keyword = reader.getNullTerminatedString(79);
            int bytesLeft = bytes.length - keyword.length() - 1;
            String value = reader.getNullTerminatedString(bytesLeft);
            ArrayList<KeyValuePair> textPairs = new ArrayList<KeyValuePair>();
            textPairs.add(new KeyValuePair(keyword, value));
            PngDirectory directory = new PngDirectory(PngChunkType.iTXt);
            directory.setObject(13, textPairs);
            metadata.addDirectory(directory);
        } else if (chunkType.equals(PngChunkType.iTXt)) {
            PngDirectory directory;
            SequentialByteArrayReader reader = new SequentialByteArrayReader(bytes);
            String keyword = reader.getNullTerminatedString(79);
            byte compressionFlag = reader.getInt8();
            byte compressionMethod = reader.getInt8();
            String languageTag = reader.getNullTerminatedString(bytes.length);
            String translatedKeyword = reader.getNullTerminatedString(bytes.length);
            int bytesLeft = bytes.length - keyword.length() - 1 - 1 - 1 - languageTag.length() - 1 - translatedKeyword.length() - 1;
            String text = null;
            if (compressionFlag == 0) {
                text = reader.getNullTerminatedString(bytesLeft);
            } else if (compressionFlag == 1) {
                if (compressionMethod == 0) {
                    text = StringUtil.fromStream(new InflaterInputStream(new ByteArrayInputStream(bytes, bytes.length - bytesLeft, bytesLeft)));
                } else {
                    directory = new PngDirectory(PngChunkType.iTXt);
                    directory.addError("Invalid compression method value");
                    metadata.addDirectory(directory);
                }
            } else {
                directory = new PngDirectory(PngChunkType.iTXt);
                directory.addError("Invalid compression flag value");
                metadata.addDirectory(directory);
            }
            if (text != null) {
                if (keyword.equals("XML:com.adobe.xmp")) {
                    new XmpReader().extract(text, metadata);
                } else {
                    ArrayList<KeyValuePair> textPairs = new ArrayList<KeyValuePair>();
                    textPairs.add(new KeyValuePair(keyword, text));
                    PngDirectory directory2 = new PngDirectory(PngChunkType.iTXt);
                    directory2.setObject(13, textPairs);
                    metadata.addDirectory(directory2);
                }
            }
        } else if (chunkType.equals(PngChunkType.tIME)) {
            SequentialByteArrayReader reader = new SequentialByteArrayReader(bytes);
            int year = reader.getUInt16();
            short month = reader.getUInt8();
            short day = reader.getUInt8();
            short hour = reader.getUInt8();
            short minute = reader.getUInt8();
            short second = reader.getUInt8();
            PngDirectory directory = new PngDirectory(PngChunkType.tIME);
            if (DateUtil.isValidDate(year, month - 1, day) && DateUtil.isValidTime(hour, minute, second)) {
                String dateString = String.format("%04d:%02d:%02d %02d:%02d:%02d", year, (int)month, (int)day, (int)hour, (int)minute, (int)second);
                directory.setString(14, dateString);
            } else {
                directory.addError(String.format("PNG tIME data describes an invalid date/time: year=%d month=%d day=%d hour=%d minute=%d second=%d", year, (int)month, (int)day, (int)hour, (int)minute, (int)second));
            }
            metadata.addDirectory(directory);
        } else if (chunkType.equals(PngChunkType.pHYs)) {
            SequentialByteArrayReader reader = new SequentialByteArrayReader(bytes);
            int pixelsPerUnitX = reader.getInt32();
            int pixelsPerUnitY = reader.getInt32();
            byte unitSpecifier = reader.getInt8();
            PngDirectory directory = new PngDirectory(PngChunkType.pHYs);
            directory.setInt(16, pixelsPerUnitX);
            directory.setInt(17, pixelsPerUnitY);
            directory.setInt(18, unitSpecifier);
            metadata.addDirectory(directory);
        } else if (chunkType.equals(PngChunkType.sBIT)) {
            PngDirectory directory = new PngDirectory(PngChunkType.sBIT);
            directory.setByteArray(19, bytes);
            metadata.addDirectory(directory);
        }
    }

    static {
        HashSet<PngChunkType> desiredChunkTypes = new HashSet<PngChunkType>();
        desiredChunkTypes.add(PngChunkType.IHDR);
        desiredChunkTypes.add(PngChunkType.PLTE);
        desiredChunkTypes.add(PngChunkType.tRNS);
        desiredChunkTypes.add(PngChunkType.cHRM);
        desiredChunkTypes.add(PngChunkType.sRGB);
        desiredChunkTypes.add(PngChunkType.gAMA);
        desiredChunkTypes.add(PngChunkType.iCCP);
        desiredChunkTypes.add(PngChunkType.bKGD);
        desiredChunkTypes.add(PngChunkType.tEXt);
        desiredChunkTypes.add(PngChunkType.iTXt);
        desiredChunkTypes.add(PngChunkType.tIME);
        desiredChunkTypes.add(PngChunkType.pHYs);
        desiredChunkTypes.add(PngChunkType.sBIT);
        _desiredChunkTypes = Collections.unmodifiableSet(desiredChunkTypes);
    }
}

