/*
 * Decompiled with CFR 0.152.
 */
package com.diffplug.spotless.maven;

import com.diffplug.common.base.Strings;
import java.io.File;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileSystemNotFoundException;
import java.nio.file.Path;
import java.security.CodeSource;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Base64;
import java.util.Objects;
import org.codehaus.plexus.resource.ResourceManager;
import org.codehaus.plexus.resource.loader.FileResourceCreationException;
import org.codehaus.plexus.resource.loader.ResourceNotFoundException;
import org.codehaus.plexus.util.FileUtils;

public class FileLocator {
    static final String TMP_RESOURCE_FILE_PREFIX = "spotless-resource-";
    private final ResourceManager resourceManager;
    private final File baseDir;
    private final File buildDir;
    private final File dataDir;

    public FileLocator(ResourceManager resourceManager, File baseDir, File buildDir) {
        this.resourceManager = Objects.requireNonNull(resourceManager);
        this.baseDir = Objects.requireNonNull(baseDir);
        this.buildDir = Objects.requireNonNull(buildDir);
        this.dataDir = FileLocator.findDataDir();
    }

    public File locateFile(String path) {
        if (Strings.isNullOrEmpty((String)path)) {
            return null;
        }
        File localFile = new File(path);
        if (localFile.exists() && localFile.isFile()) {
            return localFile;
        }
        String outputFile = FileLocator.tmpOutputFileName(path);
        try {
            return this.resourceManager.getResourceAsFile(path, outputFile);
        }
        catch (ResourceNotFoundException e) {
            throw new RuntimeException("Unable to locate file with path: " + path, e);
        }
        catch (FileResourceCreationException e) {
            throw new RuntimeException("Unable to create temporary file '" + outputFile + "' in the output directory", e);
        }
    }

    public File getBaseDir() {
        return this.baseDir;
    }

    public File getBuildDir() {
        return this.buildDir;
    }

    public File getDataDir() {
        return this.dataDir;
    }

    private static String tmpOutputFileName(String path) {
        String extension = FileUtils.extension((String)path);
        byte[] pathHash = FileLocator.hash(path);
        String pathBase64 = Base64.getEncoder().encodeToString(pathHash);
        return TMP_RESOURCE_FILE_PREFIX + pathBase64 + "." + extension;
    }

    private static byte[] hash(String value) {
        MessageDigest messageDigest;
        try {
            messageDigest = MessageDigest.getInstance("SHA-256");
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalStateException("SHA-256 digest algorithm not available", e);
        }
        messageDigest.update(value.getBytes(StandardCharsets.UTF_8));
        return messageDigest.digest();
    }

    private static File findDataDir() {
        try {
            Path sub;
            CodeSource codeSource = FileLocator.class.getProtectionDomain().getCodeSource();
            URL location = codeSource != null ? codeSource.getLocation() : null;
            URI locationUri = location != null ? location.toURI() : null;
            Path jarPath = locationUri != null && "file".equals(locationUri.getScheme()) ? Path.of(locationUri) : null;
            Path parent1 = jarPath != null ? jarPath.getParent() : null;
            Path parent2 = parent1 != null ? parent1.getParent() : null;
            Path base = parent2 != null ? parent2.getParent() : null;
            Path path = sub = base != null ? base.resolve("spotless-data") : null;
            if (sub != null) {
                return sub.toAbsolutePath().toFile();
            }
            return FileLocator.findUserHome();
        }
        catch (SecurityException e) {
            return FileLocator.findUserHome();
        }
        catch (IllegalArgumentException | URISyntaxException | FileSystemNotFoundException e) {
            throw new RuntimeException("Unable to determine data directory in local Maven repository", e);
        }
    }

    private static File findUserHome() {
        Path home = Path.of(System.getenv("user.home"), new String[0]);
        return home.resolve(".rome").toAbsolutePath().toFile();
    }
}

