/*
 * Decompiled with CFR 0.152.
 */
package com.diffplug.common.swt.os;

import com.diffplug.common.swt.os.Arch;
import com.diffplug.common.swt.os.SwtPlatform;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.function.Function;

public enum OS {
    WIN_x64,
    WIN_x86,
    LINUX_x64,
    LINUX_x86,
    MAC_x64,
    MAC_silicon,
    WIN_unknown,
    LINUX_unknown,
    MAC_unknown;

    private static OS NATIVE_OS;
    private static OS RUNNING_OS;

    public boolean isWindows() {
        return this == WIN_x64 || this == WIN_x86 || this == WIN_unknown;
    }

    public boolean isLinux() {
        return this == LINUX_x64 || this == LINUX_x86 || this == LINUX_unknown;
    }

    public boolean isMac() {
        return this == MAC_x64 || this == MAC_silicon || this == MAC_unknown;
    }

    public boolean isMacOrLinux() {
        return this.isMac() || this.isLinux();
    }

    public <T> T winMacLinux(T win, T mac, T linux) {
        if (this.isWindows()) {
            return win;
        }
        if (this.isMac()) {
            return mac;
        }
        if (this.isLinux()) {
            return linux;
        }
        throw OS.unsupportedException(this);
    }

    public Arch getArch() {
        switch (this) {
            case WIN_x64: 
            case LINUX_x64: 
            case MAC_x64: {
                return Arch.x64;
            }
            case WIN_x86: 
            case LINUX_x86: {
                return Arch.x86;
            }
            case MAC_silicon: {
                return Arch.arm64;
            }
            case WIN_unknown: 
            case MAC_unknown: 
            case LINUX_unknown: {
                return Arch.unknown;
            }
        }
        throw OS.unsupportedException(this);
    }

    public String os() {
        return this.winMacLinux("win32", "linux", "macosx");
    }

    public String arch() {
        return this.getArch().x86x64arm64unknown("x86", "x86_64", "aarch64", "unknown");
    }

    public String osDotArch() {
        return this.os() + "." + this.arch();
    }

    public String toSwt() {
        return SwtPlatform.fromOS(this).toString();
    }

    public static OS getNative() {
        OS.detectPlatform();
        return NATIVE_OS;
    }

    public static OS getRunning() {
        OS.detectPlatform();
        return RUNNING_OS;
    }

    public static void detectPlatform(Function<String, String> systemProperty, Function<String, String> environmentVariable) {
        OS.detectPlatform(systemProperty, environmentVariable, OS::exec);
    }

    public static void detectPlatform(Function<String, String> systemProperty, Function<String, String> environmentVariable, Function<List<String>, String> executeCommand) {
        if (NATIVE_OS == null) {
            NATIVE_OS = OS.calculateNative(systemProperty, environmentVariable, executeCommand);
            RUNNING_OS = OS.calculateRunning(systemProperty);
        }
    }

    private static String exec(List<String> cmd) {
        try {
            Process process = Runtime.getRuntime().exec(cmd.toArray(new String[0]));
            ByteArrayOutputStream output = new ByteArrayOutputStream();
            OS.drain(process.getInputStream(), output);
            return new String(output.toByteArray(), StandardCharsets.UTF_8);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private static void detectPlatform() {
        if (NATIVE_OS == null) {
            OS.detectPlatform(System::getProperty, System::getenv);
        }
    }

    private static OS calculateNative(Function<String, String> systemProperty, Function<String, String> environmentVariable, Function<List<String>, String> executeCommand) {
        String os_name = systemProperty.apply("os.name").toLowerCase(Locale.getDefault());
        boolean isWin = os_name.contains("win");
        boolean isMac = os_name.contains("mac");
        boolean isLinux = Arrays.asList("nix", "nux", "aix").stream().anyMatch(os_name::contains);
        if (isMac) {
            return executeCommand.apply(Arrays.asList("uname", "-a")).contains("_ARM64_") ? MAC_silicon : MAC_x64;
        }
        if (isWin) {
            boolean is64bit = environmentVariable.apply("ProgramFiles(x86)") != null;
            return is64bit ? WIN_x64 : WIN_x86;
        }
        if (isLinux) {
            String os_arch;
            switch (os_arch = systemProperty.apply("os.arch")) {
                case "i386": 
                case "x86": {
                    return LINUX_x86;
                }
                case "x86_64": 
                case "amd64": {
                    return LINUX_x64;
                }
            }
            return LINUX_unknown;
        }
        throw new IllegalArgumentException("Unknown os.name '" + os_name + "'.");
    }

    private static void drain(InputStream input, OutputStream output) throws IOException {
        int numRead;
        byte[] buf = new byte[1024];
        while ((numRead = input.read(buf)) != -1) {
            output.write(buf, 0, numRead);
        }
    }

    private static OS calculateRunning(Function<String, String> systemProperty) {
        Arch runningArch = OS.runningJvm(systemProperty);
        return NATIVE_OS.winMacLinux(runningArch.x86x64arm64unknown(WIN_x86, WIN_x64, WIN_unknown, WIN_unknown), runningArch.x86x64arm64unknown(MAC_unknown, MAC_x64, MAC_silicon, MAC_unknown), runningArch.x86x64arm64unknown(LINUX_x86, LINUX_x64, LINUX_unknown, LINUX_unknown));
    }

    private static Arch runningJvm(Function<String, String> systemProperty) {
        String sunArchDataModel;
        switch (sunArchDataModel = systemProperty.apply("sun.arch.data.model")) {
            case "32": {
                return Arch.x86;
            }
            case "64": {
                return "aarch64".equals(systemProperty.apply("os.arch")) ? Arch.arm64 : Arch.x64;
            }
        }
        return Arch.unknown;
    }

    public static UnsupportedOperationException unsupportedException(OS os) {
        return new UnsupportedOperationException("Operating system '" + (Object)((Object)os) + "' is not supported.");
    }

    public static void main(String[] args) {
        System.out.println("native=" + (Object)((Object)OS.getNative()));
        System.out.println("running=" + (Object)((Object)OS.getRunning()));
    }
}

