/*
 * Decompiled with CFR 0.152.
 */
package com.deepoove.poi.policy;

import com.deepoove.poi.NiceXWPFDocument;
import com.deepoove.poi.XWPFTemplate;
import com.deepoove.poi.config.Configure;
import com.deepoove.poi.data.DocxRenderData;
import com.deepoove.poi.policy.AbstractRenderPolicy;
import com.deepoove.poi.render.RenderContext;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class DocxRenderPolicy
extends AbstractRenderPolicy<DocxRenderData> {
    @Override
    protected boolean validate(DocxRenderData data) {
        return null != data;
    }

    @Override
    protected void beforeRender(RenderContext<DocxRenderData> context) {
        DocxRenderPolicy.clearPlaceholder(context, false);
    }

    @Override
    public void doRender(RenderContext<DocxRenderData> context) throws Exception {
        NiceXWPFDocument doc = context.getXWPFDocument();
        XWPFTemplate template = context.getTemplate();
        List<NiceXWPFDocument> docMerges = this.getMergedDocxs(context.getData(), context.getConfig());
        doc = doc.merge(docMerges, context.getRun());
        template.reload(doc);
    }

    private List<NiceXWPFDocument> getMergedDocxs(DocxRenderData data, Configure configure) throws IOException {
        ArrayList<NiceXWPFDocument> docs = new ArrayList<NiceXWPFDocument>();
        byte[] docx = data.getDocx();
        List<?> dataList = data.getRenderDatas();
        if (null == dataList || dataList.isEmpty()) {
            docs.add(new NiceXWPFDocument(new ByteArrayInputStream(docx)));
        } else {
            for (int i = 0; i < dataList.size(); ++i) {
                XWPFTemplate temp = XWPFTemplate.compile(new ByteArrayInputStream(docx), configure);
                temp.render(dataList.get(i));
                docs.add(temp.getXWPFDocument());
            }
        }
        return docs;
    }
}

