/*
 * Decompiled with CFR 0.152.
 */
package com.deepoove.poi;

import com.deepoove.poi.NumberingWrapper;
import com.deepoove.poi.XWPFParagraphWrapper;
import com.deepoove.poi.util.StyleUtils;
import com.deepoove.poi.util.TableTools;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.poi.POIXMLDocumentPart;
import org.apache.poi.openxml4j.exceptions.InvalidFormatException;
import org.apache.poi.openxml4j.opc.PackageRelationship;
import org.apache.poi.openxml4j.opc.PackageRelationshipCollection;
import org.apache.poi.xwpf.usermodel.IBody;
import org.apache.poi.xwpf.usermodel.XWPFAbstractNum;
import org.apache.poi.xwpf.usermodel.XWPFDocument;
import org.apache.poi.xwpf.usermodel.XWPFNum;
import org.apache.poi.xwpf.usermodel.XWPFNumbering;
import org.apache.poi.xwpf.usermodel.XWPFParagraph;
import org.apache.poi.xwpf.usermodel.XWPFPictureData;
import org.apache.poi.xwpf.usermodel.XWPFRelation;
import org.apache.poi.xwpf.usermodel.XWPFRun;
import org.apache.poi.xwpf.usermodel.XWPFStyle;
import org.apache.poi.xwpf.usermodel.XWPFStyles;
import org.apache.poi.xwpf.usermodel.XWPFTable;
import org.apache.poi.xwpf.usermodel.XWPFTableCell;
import org.apache.poi.xwpf.usermodel.XWPFTableRow;
import org.apache.xmlbeans.XmlCursor;
import org.apache.xmlbeans.XmlException;
import org.apache.xmlbeans.XmlObject;
import org.apache.xmlbeans.XmlOptions;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTAbstractNum;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTBody;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTDocument1;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTLvl;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTP;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTTbl;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.STJc;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.STNumberFormat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NiceXWPFDocument
extends XWPFDocument {
    private static Logger logger = LoggerFactory.getLogger(NiceXWPFDocument.class);
    protected List<XWPFTable> allTables = new ArrayList<XWPFTable>();

    public NiceXWPFDocument() {
    }

    public NiceXWPFDocument(InputStream in) throws IOException {
        super(in);
        this.buildAllTables();
    }

    protected void onDocumentCreate() {
        super.onDocumentCreate();
        try {
            CTDocument1 ctDocument = this.getDocument();
            CTDocument1 parse = null;
            String doc = "<xml-fragment xmlns:wpc=\"http://schemas.microsoft.com/office/word/2010/wordprocessingCanvas\" \n    xmlns:mo=\"http://schemas.microsoft.com/office/mac/office/2008/main\" \n    xmlns:mc=\"http://schemas.openxmlformats.org/markup-compatibility/2006\" \n    xmlns:mv=\"urn:schemas-microsoft-com:mac:vml\" \n    xmlns:o=\"urn:schemas-microsoft-com:office:office\" \n    xmlns:r=\"http://schemas.openxmlformats.org/officeDocument/2006/relationships\" \n    xmlns:m=\"http://schemas.openxmlformats.org/officeDocument/2006/math\" \n    xmlns:v=\"urn:schemas-microsoft-com:vml\" \n    xmlns:wp14=\"http://schemas.microsoft.com/office/word/2010/wordprocessingDrawing\" \n    xmlns:wp=\"http://schemas.openxmlformats.org/drawingml/2006/wordprocessingDrawing\" \n    xmlns:w10=\"urn:schemas-microsoft-com:office:word\" \n    xmlns:w=\"http://schemas.openxmlformats.org/wordprocessingml/2006/main\" \n    xmlns:w14=\"http://schemas.microsoft.com/office/word/2010/wordml\" \n    xmlns:wpg=\"http://schemas.microsoft.com/office/word/2010/wordprocessingGroup\" \n    xmlns:wpi=\"http://schemas.microsoft.com/office/word/2010/wordprocessingInk\" \n    xmlns:wne=\"http://schemas.microsoft.com/office/word/2006/wordml\" \n    xmlns:wps=\"http://schemas.microsoft.com/office/word/2010/wordprocessingShape\" mc:Ignorable=\"w14 wp14\"><w:body></w:body></xml-fragment>";
            parse = CTDocument1.Factory.parse((String)doc);
            ctDocument.set((XmlObject)parse);
        }
        catch (XmlException e) {
            logger.warn("Create new document error and merge docx may produce bug: {}", (Object)e.getMessage());
        }
    }

    private void buildAllTables() {
        List tables = this.getTables();
        if (null == tables) {
            return;
        }
        this.allTables.addAll(tables);
        List rows = null;
        List cells = null;
        List cellTables = null;
        for (XWPFTable table : tables) {
            rows = table.getRows();
            if (null == rows) continue;
            for (XWPFTableRow row : rows) {
                cells = row.getTableCells();
                if (null == cells) continue;
                for (XWPFTableCell cell : cells) {
                    cellTables = cell.getTables();
                    if (null == cellTables) continue;
                    this.allTables.addAll(cellTables);
                }
            }
        }
    }

    public XWPFTable getTableByCTTbl(CTTbl ctTbl) {
        for (int i = 0; i < this.allTables.size(); ++i) {
            if (this.allTables.get(i).getCTTbl() != ctTbl) continue;
            return this.allTables.get(i);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public XWPFTable insertNewTable(XWPFRun run, int row, int col) {
        XmlCursor cursor = ((XWPFParagraph)run.getParent()).getCTP().newCursor();
        if (this.isCursorInBody(cursor)) {
            String uri = CTTbl.type.getName().getNamespaceURI();
            String localPart = "tbl";
            cursor.beginElement(localPart, uri);
            cursor.toParent();
            CTTbl t = (CTTbl)cursor.getObject();
            XWPFTable newT = new XWPFTable(t, (IBody)this, row, col);
            XmlObject o = null;
            while (!(o instanceof CTTbl) && cursor.toPrevSibling()) {
                o = cursor.getObject();
            }
            if (!(o instanceof CTTbl)) {
                this.tables.add(0, newT);
            } else {
                int pos = this.tables.indexOf(this.getTable((CTTbl)o)) + 1;
                this.tables.add(pos, newT);
            }
            int i = 0;
            XmlCursor tableCursor = t.newCursor();
            try {
                cursor.toCursor(tableCursor);
                while (cursor.toPrevSibling()) {
                    o = cursor.getObject();
                    if (!(o instanceof CTP) && !(o instanceof CTTbl)) continue;
                    ++i;
                }
                this.bodyElements.add(i > this.bodyElements.size() ? this.bodyElements.size() : i, newT);
                cursor.toCursor(tableCursor);
                cursor.toEndToken();
                XWPFTable xWPFTable = newT;
                return xWPFTable;
            }
            finally {
                tableCursor.dispose();
            }
        }
        return null;
    }

    public void widthTable(XWPFTable table, float widthCM, int rows, int cols) {
        TableTools.widthTable(table, widthCM, cols);
        TableTools.borderTable(table, 4);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public XWPFParagraph insertNewParagraph(XWPFRun run) {
        XmlCursor cursor = ((XWPFParagraph)run.getParent()).getCTP().newCursor();
        if (this.isCursorInBody(cursor)) {
            String uri = CTP.type.getName().getNamespaceURI();
            String localPart = "p";
            cursor.beginElement(localPart, uri);
            cursor.toParent();
            CTP p = (CTP)cursor.getObject();
            XWPFParagraph newP = new XWPFParagraph(p, (IBody)this);
            XmlObject o = null;
            while (!(o instanceof CTP) && cursor.toPrevSibling()) {
                o = cursor.getObject();
            }
            if (!(o instanceof CTP) || (CTP)o == p) {
                this.paragraphs.add(0, newP);
            } else {
                int pos = this.paragraphs.indexOf(this.getParagraph((CTP)o)) + 1;
                this.paragraphs.add(pos, newP);
            }
            XmlCursor newParaPos = p.newCursor();
            try {
                int i = 0;
                cursor.toCursor(newParaPos);
                while (cursor.toPrevSibling()) {
                    o = cursor.getObject();
                    if (!(o instanceof CTP) && !(o instanceof CTTbl)) continue;
                    ++i;
                }
                this.bodyElements.add(i > this.bodyElements.size() ? this.bodyElements.size() : i, newP);
                cursor.toCursor(newParaPos);
                cursor.toEndToken();
                XWPFParagraph xWPFParagraph = newP;
                return xWPFParagraph;
            }
            finally {
                newParaPos.dispose();
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isCursorInBody(XmlCursor cursor) {
        XmlCursor verify = cursor.newCursor();
        verify.toParent();
        try {
            boolean bl = true;
            return bl;
        }
        finally {
            verify.dispose();
        }
    }

    public static XWPFRun insertNewHyperLinkRun(XWPFRun run, String link) {
        XWPFParagraphWrapper paragraph = new XWPFParagraphWrapper((XWPFParagraph)run.getParent());
        int pos = -1;
        List runs = ((XWPFParagraph)run.getParent()).getRuns();
        for (int i = 0; i < runs.size(); ++i) {
            if (run != runs.get(i)) continue;
            pos = i;
            break;
        }
        XWPFRun hyperLinkRun = paragraph.insertNewHyperLinkRun(pos, link);
        StyleUtils.styleRun(hyperLinkRun, run);
        return hyperLinkRun;
    }

    public BigInteger addNewNumbericId(Pair<STNumberFormat.Enum, String> numFmt) {
        XWPFNumbering numbering = this.getNumbering();
        if (null == numbering) {
            numbering = this.createNumbering();
        }
        NumberingWrapper numberingWrapper = new NumberingWrapper(numbering);
        CTAbstractNum cTAbstractNum = CTAbstractNum.Factory.newInstance();
        cTAbstractNum.setAbstractNumId(BigInteger.valueOf(numberingWrapper.getAbstractNumsSize() + 10));
        STNumberFormat.Enum fmt = (STNumberFormat.Enum)numFmt.getLeft();
        String val = (String)numFmt.getRight();
        CTLvl cTLvl = cTAbstractNum.addNewLvl();
        cTLvl.addNewNumFmt().setVal(fmt);
        cTLvl.addNewLvlText().setVal(val);
        cTLvl.addNewStart().setVal(BigInteger.valueOf(1L));
        cTLvl.setIlvl(BigInteger.valueOf(0L));
        if (fmt == STNumberFormat.BULLET) {
            cTLvl.addNewLvlJc().setVal(STJc.LEFT);
        }
        XWPFAbstractNum abstractNum = new XWPFAbstractNum(cTAbstractNum);
        BigInteger abstractNumID = numbering.addAbstractNum(abstractNum);
        return numbering.addNum(abstractNumID);
    }

    public NiceXWPFDocument generate() throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        this.write(byteArrayOutputStream);
        this.close();
        return new NiceXWPFDocument(new ByteArrayInputStream(byteArrayOutputStream.toByteArray()));
    }

    public NiceXWPFDocument merge(List<NiceXWPFDocument> docMerges, XWPFRun run) throws Exception {
        if (null == docMerges || docMerges.isEmpty() || null == run) {
            return this;
        }
        XWPFParagraph paragraph = (XWPFParagraph)run.getParent();
        CTP ctp = paragraph.getCTP();
        CTBody body = this.getDocument().getBody();
        String srcString = body.xmlText();
        if (!srcString.startsWith("<xml-fragment")) {
            body.addNewSectPr();
            srcString = body.xmlText();
        }
        String prefix = srcString.substring(0, srcString.indexOf(">") + 1);
        String sufix = srcString.substring(srcString.lastIndexOf("<"));
        ArrayList<String> addParts = new ArrayList<String>();
        Map<String, String> styleMapCache = this.mergeStyles(docMerges.get(0));
        for (NiceXWPFDocument docMerge : docMerges) {
            addParts.add(this.extractMergePart(docMerge, styleMapCache));
        }
        CTP makeBody = CTP.Factory.parse((String)(prefix + StringUtils.join(addParts, (String)"") + sufix));
        ctp.set((XmlObject)makeBody);
        String xmlText = body.xmlText();
        xmlText = xmlText.replaceAll("<w:p><w:p>", "<w:p>").replaceAll("<w:p><w:p\\s", "<w:p ").replaceAll("<w:p><w:tbl>", "<w:tbl>").replaceAll("<w:p><w:tbl\\s", "<w:tbl ");
        xmlText = xmlText.replaceAll("</w:sectPr></w:p>", "</w:sectPr>").replaceAll("</w:p></w:p>", "</w:p>").replaceAll("</w:tbl></w:p>", "</w:tbl>").replaceAll("<w:p(\\s[A-Za-z0-9:\\s=\"]*)?/></w:p>", "").replaceAll("</w:p><w:bookmarkEnd(\\s[A-Za-z0-9:\\s=\"]*)?/></w:p>", "</w:p>");
        body.set((XmlObject)CTBody.Factory.parse((String)xmlText));
        return this.generate();
    }

    public NiceXWPFDocument merge(NiceXWPFDocument docMerge) throws Exception {
        return this.merge(Arrays.asList(docMerge), this.createParagraph().createRun());
    }

    private String extractMergePart(NiceXWPFDocument docMerge, Map<String, String> styleIdsMap) throws InvalidFormatException {
        CTBody bodyMerge = docMerge.getDocument().getBody();
        Map<BigInteger, BigInteger> numIdsMap = this.mergeNumbering(docMerge);
        Map<String, String> blipIdsMap = this.mergePicture(docMerge);
        Map<String, String> hyperlinkMap = this.mergeHyperlink(docMerge);
        Map<String, String> chartIdsMap = this.mergeChart(docMerge);
        XmlOptions optionsOuter = new XmlOptions();
        optionsOuter.setSaveOuter();
        String appendString = bodyMerge.xmlText(optionsOuter);
        String addPart = this.ridSectPr(appendString);
        for (String string : styleIdsMap.keySet()) {
            addPart = addPart.replaceAll("<w:pStyle\\sw:val=\"" + string + "\"", "<w:pStyle w:val=\"" + styleIdsMap.get(string) + "\"").replaceAll("<w:tblStyle\\sw:val=\"" + string + "\"", "<w:tblStyle w:val=\"" + styleIdsMap.get(string) + "\"").replaceAll("<w:rStyle\\sw:val=\"" + string + "\"", "<w:rStyle w:val=\"" + styleIdsMap.get(string) + "\"");
        }
        HashMap<String, String> placeHolderblipIdsMap = new HashMap<String, String>();
        for (String relaId : blipIdsMap.keySet()) {
            placeHolderblipIdsMap.put(relaId, blipIdsMap.get(relaId) + "@PoiTL@");
        }
        for (String relaId : placeHolderblipIdsMap.keySet()) {
            addPart = addPart.replaceAll("r:embed=\"" + relaId + "\"", "r:embed=\"" + (String)placeHolderblipIdsMap.get(relaId) + "\"");
            addPart = addPart.replaceAll("r:id=\"" + relaId + "\"", "r:id=\"" + (String)placeHolderblipIdsMap.get(relaId) + "\"");
        }
        for (String relaId : hyperlinkMap.keySet()) {
            hyperlinkMap.put(relaId, hyperlinkMap.get(relaId) + "@PoiTL@");
        }
        for (String relaId : hyperlinkMap.keySet()) {
            addPart = addPart.replaceAll("r:id=\"" + relaId + "\"", "r:id=\"" + hyperlinkMap.get(relaId) + "\"");
        }
        for (String relaId : chartIdsMap.keySet()) {
            chartIdsMap.put(relaId, chartIdsMap.get(relaId) + "@PoiTL@");
        }
        for (String relaId : chartIdsMap.keySet()) {
            addPart = addPart.replaceAll("r:id=\"" + relaId + "\"", "r:id=\"" + chartIdsMap.get(relaId) + "\"");
        }
        HashMap<BigInteger, String> hashMap = new HashMap<BigInteger, String>();
        for (BigInteger relaId : numIdsMap.keySet()) {
            hashMap.put(relaId, numIdsMap.get(relaId) + "@PoiTL@");
        }
        for (BigInteger numId : hashMap.keySet()) {
            addPart = addPart.replaceAll("<w:numId\\sw:val=\"" + numId + "\"", "<w:numId w:val=\"" + (String)hashMap.get(numId) + "\"");
        }
        addPart = addPart.replaceAll("@PoiTL@", "");
        try {
            docMerge.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return addPart;
    }

    private String ridSectPr(String appendString) {
        int lastIndexOf = appendString.lastIndexOf("<w:sectPr");
        String addPart = "";
        int begin = appendString.indexOf(">") + 1;
        int end = appendString.lastIndexOf("<");
        if (-1 != lastIndexOf) {
            String prefix = appendString.substring(begin, appendString.lastIndexOf("<w:sectPr"));
            String sufix = appendString.substring(appendString.lastIndexOf("</w:sectPr>") + 11, end);
            return prefix + sufix;
        }
        if (begin < end) {
            addPart = appendString.substring(begin, end);
        }
        return addPart;
    }

    private Map<String, String> mergePicture(NiceXWPFDocument docMerge) throws InvalidFormatException {
        HashMap<String, String> blipIdsMap = new HashMap<String, String>();
        List allPictures = docMerge.getAllPictures();
        for (XWPFPictureData xwpfPictureData : allPictures) {
            String relationId = docMerge.getRelationId((POIXMLDocumentPart)xwpfPictureData);
            String blidId = this.addPictureData(xwpfPictureData.getData(), xwpfPictureData.getPictureType());
            blipIdsMap.put(relationId, blidId);
        }
        return blipIdsMap;
    }

    private Map<BigInteger, BigInteger> mergeNumbering(NiceXWPFDocument docMerge) {
        HashMap<BigInteger, BigInteger> numIdsMap = new HashMap<BigInteger, BigInteger>();
        XWPFNumbering numberingMerge = docMerge.getNumbering();
        if (null == numberingMerge) {
            return numIdsMap;
        }
        NumberingWrapper wrapperMerge = new NumberingWrapper(numberingMerge);
        List<XWPFNum> nums = wrapperMerge.getNums();
        if (null == nums) {
            return numIdsMap;
        }
        XWPFNumbering numbering = this.getNumbering();
        if (null == numbering) {
            numbering = this.createNumbering();
        }
        NumberingWrapper wrapper = new NumberingWrapper(numbering);
        HashMap<BigInteger, CTAbstractNum> cache = new HashMap<BigInteger, CTAbstractNum>();
        for (XWPFNum xwpfNum : nums) {
            BigInteger mergeNumId = xwpfNum.getCTNum().getNumId();
            CTAbstractNum cTAbstractNum = (CTAbstractNum)cache.get(xwpfNum.getCTNum().getAbstractNumId().getVal());
            if (null == cTAbstractNum) {
                XWPFAbstractNum xwpfAbstractNum = numberingMerge.getAbstractNum(xwpfNum.getCTNum().getAbstractNumId().getVal());
                if (null == xwpfAbstractNum) {
                    logger.warn("cannot find cTAbstractNum by XWPFNum.");
                    continue;
                }
                cTAbstractNum = xwpfAbstractNum.getCTAbstractNum();
                cTAbstractNum.setAbstractNumId(BigInteger.valueOf(wrapper.getAbstractNumsSize() + 20));
                cache.put(xwpfNum.getCTNum().getAbstractNumId().getVal(), cTAbstractNum);
            }
            BigInteger numID = numbering.addNum(numbering.addAbstractNum(new XWPFAbstractNum(cTAbstractNum)));
            numIdsMap.put(mergeNumId, numID);
        }
        return numIdsMap;
    }

    private Map<String, String> mergeStyles(NiceXWPFDocument docMerge) {
        XWPFStyles stylesMerge;
        HashMap<String, String> styleIdsMap = new HashMap<String, String>();
        XWPFStyles styles = this.getStyles();
        if (null == styles) {
            styles = this.createStyles();
        }
        if (null == (stylesMerge = docMerge.getStyles())) {
            return styleIdsMap;
        }
        try {
            Field listStyleField = XWPFStyles.class.getDeclaredField("listStyle");
            listStyleField.setAccessible(true);
            List lists = (List)listStyleField.get(stylesMerge);
            for (XWPFStyle xwpfStyle : lists) {
                if (styles.styleExist(xwpfStyle.getStyleId())) {
                    String id = xwpfStyle.getStyleId();
                    xwpfStyle.setStyleId(UUID.randomUUID().toString());
                    styleIdsMap.put(id, xwpfStyle.getStyleId());
                }
                styles.addStyle(xwpfStyle);
            }
        }
        catch (Exception e) {
            logger.error("merge style error", (Throwable)e);
        }
        return styleIdsMap;
    }

    private Map<String, String> mergeHyperlink(NiceXWPFDocument docMerge) throws InvalidFormatException {
        HashMap<String, String> map = new HashMap<String, String>();
        PackageRelationshipCollection hyperlinks = docMerge.getPackagePart().getRelationshipsByType("http://schemas.openxmlformats.org/officeDocument/2006/relationships/hyperlink");
        for (PackageRelationship relationship : hyperlinks) {
            PackageRelationship relationshipNew = this.getPackagePart().addExternalRelationship(relationship.getTargetURI().toString(), XWPFRelation.HYPERLINK.getRelation());
            map.put(relationship.getId(), relationshipNew.getId());
        }
        return map;
    }

    private Map<String, String> mergeChart(NiceXWPFDocument docMerge) throws InvalidFormatException {
        HashMap<String, String> map = new HashMap<String, String>();
        return map;
    }
}

