/*
 * Decompiled with CFR 0.152.
 */
package com.deepoove.poi.data;

import com.deepoove.poi.data.BookmarkTextRenderData;
import com.deepoove.poi.data.HyperlinkTextRenderData;
import com.deepoove.poi.data.RenderDataBuilder;
import com.deepoove.poi.data.TextRenderData;
import com.deepoove.poi.data.style.Style;
import org.apache.poi.xwpf.usermodel.UnderlinePatterns;

public final class Texts {
    private Texts() {
    }

    public static TextBuilder of(String text) {
        return new TextBuilder(text);
    }

    public static class TextBuilder
    implements RenderDataBuilder<TextRenderData> {
        private String text;
        private Style style;
        private String url;
        private String bookmark;

        private TextBuilder(String text) {
            this.text = text;
        }

        public TextBuilder style(Style style) {
            this.style = style;
            return this;
        }

        public TextBuilder color(String color) {
            if (null != this.style) {
                this.style.setColor(color);
            } else {
                this.style = Style.builder().buildColor(color).build();
            }
            return this;
        }

        public TextBuilder bold() {
            if (null != this.style) {
                this.style.setBold(true);
            } else {
                this.style = Style.builder().buildBold().build();
            }
            return this;
        }

        public TextBuilder italic() {
            if (null != this.style) {
                this.style.setItalic(true);
            } else {
                this.style = Style.builder().buildItalic().build();
            }
            return this;
        }

        public TextBuilder sup() {
            if (null != this.style) {
                this.style.setVertAlign("superscript");
            } else {
                this.style = Style.builder().buildSuper().build();
            }
            return this;
        }

        public TextBuilder sub() {
            if (null != this.style) {
                this.style.setVertAlign("subscript");
            } else {
                this.style = Style.builder().buildSub().build();
            }
            return this;
        }

        public TextBuilder fontSize(double fontSize) {
            if (null != this.style) {
                this.style.setFontSize(fontSize);
            } else {
                this.style = Style.builder().buildFontSize(fontSize).build();
            }
            return this;
        }

        public TextBuilder fontFamily(String fontFamily) {
            if (null != this.style) {
                this.style.setFontFamily(fontFamily);
            } else {
                this.style = Style.builder().buildFontFamily(fontFamily).build();
            }
            return this;
        }

        public TextBuilder link(String url) {
            this.url = url;
            if (null == this.style) {
                this.style = Style.builder().buildColor("0000FF").buildUnderlinePatterns(UnderlinePatterns.SINGLE).build();
            }
            return this;
        }

        public TextBuilder bookmark(String name) {
            this.bookmark = name;
            return this;
        }

        public TextBuilder mailto(String address, String subject) {
            StringBuilder sb = new StringBuilder(128);
            sb.append("mailto:").append(address).append("?subject=").append(subject);
            return this.link(sb.toString());
        }

        public TextBuilder anchor(String anchorName) {
            StringBuilder sb = new StringBuilder(32);
            sb.append("anchor:").append(anchorName);
            return this.link(sb.toString());
        }

        @Override
        public TextRenderData create() {
            TextRenderData data = null;
            data = null != this.url ? new HyperlinkTextRenderData(this.text, this.url) : (null != this.bookmark ? new BookmarkTextRenderData(this.text, this.bookmark) : new TextRenderData(this.text));
            data.setStyle(this.style);
            return data;
        }
    }
}

