/*
 * Decompiled with CFR 0.152.
 */
package com.deepoove.poi.converter;

import com.deepoove.poi.converter.ToRenderDataConverter;
import com.deepoove.poi.data.DocumentRenderData;
import com.deepoove.poi.data.Documents;
import com.deepoove.poi.data.ParagraphRenderData;
import com.deepoove.poi.data.Paragraphs;
import com.deepoove.poi.data.PictureRenderData;
import com.deepoove.poi.data.RenderData;
import com.deepoove.poi.data.TextRenderData;
import com.deepoove.poi.data.Texts;
import com.deepoove.poi.data.style.Style;

public class ParagraphToDocumentRenderDataConverter
implements ToRenderDataConverter<ParagraphRenderData, DocumentRenderData> {
    protected final boolean SHOW_LINE;
    protected final int FIRST_LINE;

    public ParagraphToDocumentRenderDataConverter() {
        this(false);
    }

    public ParagraphToDocumentRenderDataConverter(boolean showLine) {
        this.SHOW_LINE = showLine;
        this.FIRST_LINE = 1;
    }

    @Override
    public DocumentRenderData convert(ParagraphRenderData para) throws Exception {
        int line = this.FIRST_LINE;
        Documents.DocumentBuilder of = Documents.of();
        Paragraphs.ParagraphBuilder paragraphBuilder = null;
        for (RenderData data : para.getContents()) {
            if (null == paragraphBuilder) {
                paragraphBuilder = this.createParagraphBuilder(para, line++);
            }
            if (data instanceof TextRenderData) {
                String text = ((TextRenderData)data).getText();
                Style style = ((TextRenderData)data).getStyle();
                int cursor = 0;
                int position = text.indexOf("\n", cursor);
                while (position != -1) {
                    paragraphBuilder.addText(Texts.of(text.substring(cursor, position)).style(style).create());
                    of.addParagraph(paragraphBuilder.create());
                    paragraphBuilder = this.createParagraphBuilder(para, line++);
                    cursor = position + 1;
                    position = text.indexOf("\n", cursor);
                }
                paragraphBuilder.addText(Texts.of(text.substring(cursor)).style(style).create());
                continue;
            }
            if (!(data instanceof PictureRenderData)) continue;
            paragraphBuilder.addPicture((PictureRenderData)data);
        }
        ParagraphRenderData lastPara = paragraphBuilder.create();
        if (lastPara.getContents().size() > 0) {
            of.addParagraph(lastPara);
        }
        return of.create();
    }

    private Paragraphs.ParagraphBuilder createParagraphBuilder(ParagraphRenderData para, int line) {
        Paragraphs.ParagraphBuilder of = Paragraphs.of().paraStyle(para.getParagraphStyle());
        if (this.SHOW_LINE) {
            of.addText(Texts.of((line <= 9 ? "  " : " ") + line + " ").create());
        }
        return of;
    }
}

