/*
 * Decompiled with CFR 0.152.
 */
package com.deepoove.poi.xwpf;

import com.deepoove.poi.xwpf.BodyContainer;
import com.deepoove.poi.xwpf.NiceXWPFDocument;
import com.deepoove.poi.xwpf.Page;
import com.deepoove.poi.xwpf.XWPFSection;
import java.util.List;
import org.apache.poi.xwpf.usermodel.IBody;
import org.apache.poi.xwpf.usermodel.IBodyElement;
import org.apache.poi.xwpf.usermodel.XWPFParagraph;
import org.apache.poi.xwpf.usermodel.XWPFRun;
import org.apache.poi.xwpf.usermodel.XWPFTable;
import org.apache.poi.xwpf.usermodel.XWPFTableRow;
import org.apache.xmlbeans.XmlCursor;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTBody;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTP;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTPPr;

public class DocumentBodyContainer
implements BodyContainer {
    private NiceXWPFDocument doc;

    public DocumentBodyContainer(NiceXWPFDocument doc) {
        this.doc = doc;
    }

    @Override
    public void removeBodyElement(int i) {
        this.doc.removeBodyElement(i);
    }

    @Override
    public void setParagraph(XWPFParagraph para, int paraPos) {
        this.doc.setParagraph(para, paraPos);
    }

    @Override
    public IBody getTarget() {
        return this.doc;
    }

    @Override
    public void setTable(int tablePos, XWPFTable table) {
        this.doc.setTable(tablePos, table);
    }

    @Override
    public XWPFTable insertNewTable(XWPFRun run, int row, int col) {
        XmlCursor cursor = ((XWPFParagraph)run.getParent()).getCTP().newCursor();
        XWPFTable table = this.insertNewTbl(cursor);
        for (int i = 0; i < row; ++i) {
            XWPFTableRow tabRow = table.getRow(i) == null ? table.createRow() : table.getRow(i);
            for (int k = 0; k < col; ++k) {
                if (tabRow.getCell(k) != null) continue;
                tabRow.createCell();
            }
        }
        return table;
    }

    @Override
    public XWPFSection closelySectPr(IBodyElement element) {
        List bodyElements = this.doc.getBodyElements();
        boolean isEncounter = false;
        for (IBodyElement ele : bodyElements) {
            if (isEncounter) {
                CTPPr pPr;
                XWPFParagraph para;
                CTP ctp;
                if (!(ele instanceof XWPFParagraph) || !(ctp = (para = (XWPFParagraph)ele).getCTP()).isSetPPr() || !(pPr = ctp.getPPr()).isSetSectPr()) continue;
                return new XWPFSection(pPr.getSectPr());
            }
            if (ele != element) continue;
            isEncounter = true;
        }
        CTBody body = this.doc.getDocument().getBody();
        if (body.isSetSectPr()) {
            return new XWPFSection(body.getSectPr());
        }
        return null;
    }

    @Override
    public int elementPageWidth(IBodyElement element) {
        XWPFSection section = this.closelySectPr(element);
        if (null == section) {
            return Page.A4_NORMAL.contentWidth().intValue();
        }
        return section.getPageContentWidth().intValue();
    }
}

