/*
 * Decompiled with CFR 0.152.
 */
package com.deepoove.poi.util;

import java.util.function.BiFunction;

public final class Preconditions {
    private Preconditions() {
    }

    public static void requireGreaterThan(int first, int second, String message) {
        if (first <= second) {
            throw new IllegalStateException(message);
        }
    }

    public static void checkMinimumVersion(String currentVer, String minimumVer, BiFunction<String, String, String> message) {
        int ret = 0;
        try {
            ComparableVersion currentVersion = new ComparableVersion(currentVer);
            ComparableVersion minimumVersion = new ComparableVersion(minimumVer);
            ret = currentVersion.compareTo(minimumVersion);
        }
        catch (Exception e) {
            return;
        }
        if (ret < 0) {
            throw new IllegalStateException(message.apply(currentVer, minimumVer));
        }
    }

    static class ComparableVersion
    implements Comparable<ComparableVersion> {
        private final int first;
        private final int second;
        private final int third;

        public ComparableVersion(String version) {
            int separator = version.indexOf(45);
            String actualVersion = separator == -1 ? version : version.substring(0, separator);
            String[] split = actualVersion.split("\\.");
            int length = split.length;
            this.first = Integer.valueOf(split[0]);
            this.second = length > 1 ? Integer.valueOf(split[1]) : 0;
            this.third = length > 2 ? Integer.valueOf(split[2]) : 0;
        }

        @Override
        public int compareTo(ComparableVersion obj) {
            if (this == obj) {
                return 0;
            }
            if (this.first == obj.first) {
                if (this.second == obj.second) {
                    return this.third - obj.third;
                }
                return this.second - obj.second;
            }
            return this.first - obj.first;
        }
    }
}

