/*
 * Decompiled with CFR 0.152.
 */
package com.deepoove.poi.data;

import com.deepoove.poi.data.CellRenderData;
import com.deepoove.poi.data.Cells;
import com.deepoove.poi.data.RenderDataBuilder;
import com.deepoove.poi.data.RowRenderData;
import com.deepoove.poi.data.TextRenderData;
import com.deepoove.poi.data.style.CellStyle;
import com.deepoove.poi.data.style.ParagraphStyle;
import com.deepoove.poi.data.style.RowStyle;
import com.deepoove.poi.data.style.Style;
import com.deepoove.poi.util.UnitUtils;
import java.util.Arrays;
import org.apache.poi.xwpf.usermodel.ParagraphAlignment;
import org.apache.poi.xwpf.usermodel.XWPFTableCell;

public class Rows {
    private Rows() {
    }

    public static RowBuilder of() {
        return new RowBuilder();
    }

    public static RowBuilder of(CellRenderData ... cell) {
        RowBuilder inst = Rows.of();
        if (null != cell) {
            Arrays.stream(cell).forEach(inst::addCell);
        }
        return inst;
    }

    public static RowBuilder of(String ... cell) {
        RowBuilder inst = Rows.of();
        if (null != cell) {
            Arrays.stream(cell).map(text -> Cells.of(text).create()).forEach(inst::addCell);
        }
        return inst;
    }

    public static RowBuilder of(TextRenderData ... cell) {
        RowBuilder inst = Rows.of();
        if (null != cell) {
            Arrays.stream(cell).map(text -> Cells.of(text).create()).forEach(inst::addCell);
        }
        return inst;
    }

    public static RowRenderData create(String ... cell) {
        return Rows.of(cell).create();
    }

    public static RowRenderData create(CellRenderData ... cell) {
        return Rows.of(cell).create();
    }

    public static class RowBuilder
    implements RenderDataBuilder<RowRenderData> {
        private RowRenderData data = new RowRenderData();

        private RowBuilder() {
        }

        public RowBuilder bgColor(String color) {
            CellStyle defaultCellStyle = this.getDefaultCellStyle();
            defaultCellStyle.setBackgroundColor(color);
            return this;
        }

        public RowBuilder center() {
            this.verticalCenter();
            this.horizontalCenter();
            return this;
        }

        public RowBuilder verticalCenter() {
            CellStyle defaultCellStyle = this.getDefaultCellStyle();
            defaultCellStyle.setVertAlign(XWPFTableCell.XWPFVertAlign.CENTER);
            return this;
        }

        public RowBuilder horizontalCenter() {
            ParagraphStyle defaultParaStyle = this.getDefaultParagraphStyle();
            defaultParaStyle.setAlign(ParagraphAlignment.CENTER);
            return this;
        }

        public RowBuilder rowHeight(double cm) {
            RowStyle rowStyle = this.getRowStyle();
            rowStyle.setHeight(UnitUtils.cm2Twips(cm));
            return this;
        }

        public RowBuilder rowExactHeight(double cm) {
            RowStyle rowStyle = this.getRowStyle();
            rowStyle.setHeight(UnitUtils.cm2Twips(cm));
            rowStyle.setHeightRule("exact");
            return this;
        }

        public RowBuilder rowAtleastHeight(double cm) {
            RowStyle rowStyle = this.getRowStyle();
            rowStyle.setHeight(UnitUtils.cm2Twips(cm));
            rowStyle.setHeightRule("atleast");
            return this;
        }

        public RowBuilder addCell(CellRenderData cell) {
            this.data.addCell(cell);
            return this;
        }

        public RowBuilder textColor(String color) {
            Style style = this.getDefaultTextStyle();
            style.setColor(color);
            return this;
        }

        public RowBuilder textBold() {
            Style style = this.getDefaultTextStyle();
            style.setBold(true);
            return this;
        }

        public RowBuilder textFontSize(int fontSize) {
            Style style = this.getDefaultTextStyle();
            style.setFontSize(fontSize);
            return this;
        }

        public RowBuilder textFontFamily(String fontFamily) {
            Style style = this.getDefaultTextStyle();
            style.setFontFamily(fontFamily);
            return this;
        }

        public RowBuilder rowStyle(RowStyle rowStyle) {
            this.data.setRowStyle(rowStyle);
            return this;
        }

        private CellStyle getDefaultCellStyle() {
            RowStyle rowStyle = this.getRowStyle();
            CellStyle defaultCellStyle = rowStyle.getDefaultCellStyle();
            if (null == defaultCellStyle) {
                defaultCellStyle = new CellStyle();
                rowStyle.setDefaultCellStyle(defaultCellStyle);
            }
            return defaultCellStyle;
        }

        private Style getDefaultTextStyle() {
            ParagraphStyle defaultParagraphStyle = this.getDefaultParagraphStyle();
            Style defaultTextStyle = defaultParagraphStyle.getDefaultTextStyle();
            if (null == defaultTextStyle) {
                defaultTextStyle = Style.builder().build();
                defaultParagraphStyle.setDefaultTextStyle(defaultTextStyle);
            }
            return defaultTextStyle;
        }

        private ParagraphStyle getDefaultParagraphStyle() {
            CellStyle cellStyle = this.getDefaultCellStyle();
            ParagraphStyle defaultParagraphStyle = cellStyle.getDefaultParagraphStyle();
            if (null == defaultParagraphStyle) {
                defaultParagraphStyle = ParagraphStyle.builder().build();
                cellStyle.setDefaultParagraphStyle(defaultParagraphStyle);
            }
            return defaultParagraphStyle;
        }

        private RowStyle getRowStyle() {
            RowStyle rowStyle = this.data.getRowStyle();
            if (null == rowStyle) {
                rowStyle = new RowStyle();
                this.data.setRowStyle(rowStyle);
            }
            return rowStyle;
        }

        @Override
        public RowRenderData create() {
            return this.data;
        }
    }
}

