/*
 * Decompiled with CFR 0.152.
 */
package com.deepoove.poi.plugin.highlight.converter;

import com.codewaves.codehighlight.core.StyleRenderer;
import com.deepoove.poi.data.ParagraphRenderData;
import com.deepoove.poi.data.Paragraphs;
import com.deepoove.poi.data.Texts;
import com.deepoove.poi.data.style.BorderStyle;
import com.deepoove.poi.data.style.ParagraphStyle;
import com.deepoove.poi.data.style.Style;
import com.deepoove.poi.plugin.highlight.HighlightStyle;
import com.deepoove.poi.plugin.highlight.converter.SelectorStyle;
import com.deepoove.poi.plugin.highlight.converter.StylesheetParser;
import com.deepoove.poi.util.StyleUtils;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import org.apache.poi.xwpf.usermodel.XWPFTable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ParagraphRenderer
implements StyleRenderer<ParagraphRenderData> {
    protected static final Logger LOGGER = LoggerFactory.getLogger(ParagraphRenderer.class);
    private Paragraphs.ParagraphBuilder of;
    private LinkedList<String> styleStack;
    private String blockResult;
    private String abortResult;
    private String fontFamily;
    private double fontSize;
    private List<SelectorStyle> cssStyle;

    public ParagraphRenderer(HighlightStyle style) {
        String theme = null == style || null == style.getTheme() ? "poitl" : style.getTheme();
        try {
            this.cssStyle = StylesheetParser.parse("highlightcss/" + theme + ".css");
            this.fontFamily = null == style ? null : style.getFontFamily();
            this.fontSize = null == style ? 0.0 : style.getFontSize();
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Illegal highlight theme:" + theme, e);
        }
        this.of = Paragraphs.of();
        this.style();
    }

    private void style() {
        HashMap<String, String> pv = new HashMap<String, String>();
        for (SelectorStyle css : this.cssStyle) {
            if (!".hljs".equals(css.getSelectorName())) continue;
            pv.putAll(css.getPropertyValues());
        }
        ParagraphStyle paragraphStyle = StyleUtils.retriveParagraphStyleFromCss(pv);
        if (this.fontFamily != null && this.fontSize != 0.0) {
            Style defaultTextStyle = paragraphStyle.getDefaultTextStyle();
            if (null == defaultTextStyle) {
                defaultTextStyle = Style.builder().build();
                paragraphStyle.setDefaultTextStyle(defaultTextStyle);
            }
            defaultTextStyle.setFontFamily(this.fontFamily);
            defaultTextStyle.setFontSize(this.fontSize);
        }
        if (null != paragraphStyle.getBackgroundColor()) {
            BorderStyle borderStyle = BorderStyle.builder().withColor(paragraphStyle.getBackgroundColor()).withType(XWPFTable.XWPFBorderType.SINGLE).withSize(48).build();
            paragraphStyle.setLeftBorder(borderStyle);
            paragraphStyle.setRightBorder(borderStyle);
            paragraphStyle.setBottomBorder(borderStyle);
            paragraphStyle.setTopBorder(borderStyle);
        }
        this.of.paraStyle(paragraphStyle).allowWordBreak().left();
    }

    public void onStart() {
        this.styleStack = new LinkedList();
        this.blockResult = "";
    }

    public void onFinish() {
        this.appendBlock();
    }

    public void onPushStyle(String style) {
        this.appendBlock();
        this.styleStack.push(style);
    }

    public void onPopStyle() {
        this.appendBlock();
        this.styleStack.pop();
    }

    public void onPushCodeBlock(CharSequence block) {
        this.blockResult = this.blockResult + block;
    }

    private void appendBlock() {
        if (this.blockResult.isEmpty()) {
            return;
        }
        Texts.TextBuilder ofText = Texts.of((String)this.blockResult.toString());
        HashMap<String, String> pv = new HashMap<String, String>();
        for (int i = this.styleStack.size() - 1; i >= 0; --i) {
            String clazz = this.styleStack.get(i);
            for (SelectorStyle css : this.cssStyle) {
                if (!(".hljs-" + clazz).equals(css.getSelectorName())) continue;
                pv.putAll(css.getPropertyValues());
            }
        }
        ofText.style(StyleUtils.retriveStyleFromCss(pv));
        this.of.addText(ofText.create());
        this.blockResult = "";
    }

    public void onPushSubLanguage(String name, ParagraphRenderData code) {
        this.of.addParagraph(code);
    }

    public void onPushOriginalSubLanguage(String name, CharSequence code) {
        this.of.addText(Texts.of((String)code.toString()).create());
    }

    public void onAbort(CharSequence code, Exception e) {
        LOGGER.debug("Unable parse highlight code", (Throwable)e);
        this.abortResult = code.toString();
    }

    public ParagraphRenderData getResult() {
        ParagraphRenderData data = this.of.create();
        if (null != this.abortResult) {
            data.getContents().clear();
            data.getContents().add(Texts.of((String)this.abortResult).create());
        }
        return data;
    }
}

