/*
 * Decompiled with CFR 0.152.
 */
package com.codewaves.codehighlight.renderer;

import com.codewaves.codehighlight.core.StyleRenderer;

public class HtmlRenderer
implements StyleRenderer<CharSequence> {
    private String mPrefix;
    private String mResult;

    public HtmlRenderer(String prefix) {
        this.mPrefix = prefix;
    }

    @Override
    public void onStart() {
        this.mResult = "";
    }

    @Override
    public void onFinish() {
    }

    @Override
    public void onPushStyle(String style) {
        this.mResult = this.mResult + "<span class=\"" + this.mPrefix + style + "\">";
    }

    @Override
    public void onPopStyle() {
        this.mResult = this.mResult + "</span>";
    }

    @Override
    public void onPushCodeBlock(CharSequence block) {
        this.mResult = this.mResult + this.escape(block.toString());
    }

    @Override
    public void onPushSubLanguage(String name, CharSequence code) {
        this.mResult = this.mResult + "<span class=\"" + name + "\">" + code + "</span>";
    }

    @Override
    public void onPushOriginalSubLanguage(String name, CharSequence code) {
        this.mResult = null == name ? this.mResult + code : this.mResult + "<span class=\"" + name + "\">" + code + "</span>";
    }

    @Override
    public void onAbort(CharSequence code, Exception e) {
        this.mResult = code.toString();
    }

    @Override
    public CharSequence getResult() {
        return this.mResult;
    }

    private String escape(String code) {
        return code.replace("&", "&amp;").replace("<", "&lt;").replace(">", "&gt;");
    }
}

