/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.protocol.internal.request.query;

import com.datastax.oss.protocol.internal.PrimitiveCodec;
import com.datastax.oss.protocol.internal.PrimitiveSizes;
import com.datastax.oss.protocol.internal.ProtocolConstants;
import com.datastax.oss.protocol.internal.util.collection.NullAllowingImmutableList;
import com.datastax.oss.protocol.internal.util.collection.NullAllowingImmutableMap;
import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public class Values {
    public static <B> void writePositionalValues(List<ByteBuffer> values, B dest, PrimitiveCodec<B> encoder) {
        encoder.writeUnsignedShort(values.size(), dest);
        for (ByteBuffer value : values) {
            Values.writeValue(value, dest, encoder);
        }
    }

    public static int sizeOfPositionalValues(List<ByteBuffer> values) {
        int size = 2;
        for (ByteBuffer value : values) {
            size += Values.sizeOfValue(value);
        }
        return size;
    }

    public static <B> void writeNamedValues(Map<String, ByteBuffer> values, B dest, PrimitiveCodec<B> encoder) {
        encoder.writeUnsignedShort(values.size(), dest);
        for (Map.Entry<String, ByteBuffer> entry : values.entrySet()) {
            encoder.writeString(entry.getKey(), dest);
            Values.writeValue(entry.getValue(), dest, encoder);
        }
    }

    public static int sizeOfNamedValues(Map<String, ByteBuffer> values) {
        int size = 2;
        for (Map.Entry<String, ByteBuffer> entry : values.entrySet()) {
            size += PrimitiveSizes.sizeOfString(entry.getKey());
            size += Values.sizeOfValue(entry.getValue());
        }
        return size;
    }

    private static <B> void writeValue(ByteBuffer value, B dest, PrimitiveCodec<B> encoder) {
        if (value == null) {
            encoder.writeInt(-1, dest);
        } else if (value == ProtocolConstants.UNSET_VALUE) {
            encoder.writeInt(-2, dest);
        } else {
            encoder.writeBytes(value, dest);
        }
    }

    private static int sizeOfValue(ByteBuffer value) {
        return value == null || value == ProtocolConstants.UNSET_VALUE ? 4 : PrimitiveSizes.sizeOfBytes(value);
    }

    public static <B> List<ByteBuffer> readPositionalValues(B source, PrimitiveCodec<B> decoder) {
        int size = decoder.readUnsignedShort(source);
        if (size == 0) {
            return Collections.emptyList();
        }
        NullAllowingImmutableList.Builder<ByteBuffer> values = NullAllowingImmutableList.builder(size);
        for (int i = 0; i < size; ++i) {
            values.add(Values.readValue(source, decoder));
        }
        return values.build();
    }

    public static <B> Map<String, ByteBuffer> readNamedValues(B source, PrimitiveCodec<B> decoder) {
        int size = decoder.readUnsignedShort(source);
        if (size == 0) {
            return Collections.emptyMap();
        }
        NullAllowingImmutableMap.Builder<String, ByteBuffer> values = NullAllowingImmutableMap.builder(size);
        for (int i = 0; i < size; ++i) {
            String key = decoder.readString(source);
            ByteBuffer value = Values.readValue(source, decoder);
            values.put(key, value);
        }
        return values.build();
    }

    public static <B> ByteBuffer readValue(B source, PrimitiveCodec<B> decoder) {
        return decoder.readBytes(source);
    }
}

