/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.internal.core.type.codec.extras.array;

import com.datastax.oss.driver.api.core.ProtocolVersion;
import com.datastax.oss.driver.api.core.type.DataTypes;
import com.datastax.oss.driver.api.core.type.reflect.GenericType;
import com.datastax.oss.driver.internal.core.type.codec.extras.array.AbstractPrimitiveListToArrayCodec;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.nio.ByteBuffer;
import java.util.Objects;
import net.jcip.annotations.Immutable;

@Immutable
public class LongListToArrayCodec
extends AbstractPrimitiveListToArrayCodec<long[]> {
    public LongListToArrayCodec() {
        super(DataTypes.listOf(DataTypes.BIGINT), GenericType.of(long[].class));
    }

    @Override
    public boolean accepts(@NonNull Class<?> javaClass) {
        Objects.requireNonNull(javaClass);
        return long[].class.equals(javaClass);
    }

    @Override
    public boolean accepts(@NonNull Object value) {
        Objects.requireNonNull(value);
        return value instanceof long[];
    }

    @Override
    protected int sizeOfComponentType() {
        return 8;
    }

    @Override
    protected void serializeElement(@NonNull ByteBuffer output, @NonNull long[] array, int index, @NonNull ProtocolVersion protocolVersion) {
        output.putLong(array[index]);
    }

    @Override
    protected void deserializeElement(@NonNull ByteBuffer input, @NonNull long[] array, int index, @NonNull ProtocolVersion protocolVersion) {
        array[index] = input.getLong();
    }

    @Override
    protected void formatElement(@NonNull StringBuilder output, @NonNull long[] array, int index) {
        output.append(array[index]);
    }

    @Override
    protected void parseElement(@NonNull String input, @NonNull long[] array, int index) {
        array[index] = Long.parseLong(input);
    }

    @Override
    @NonNull
    protected long[] newInstance(int size) {
        return new long[size];
    }
}

