/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.dse.driver.internal.core.auth;

import com.datastax.dse.driver.api.core.auth.DseGssApiAuthProviderBase;
import com.datastax.dse.driver.api.core.config.DseDriverOption;
import com.datastax.dse.driver.internal.core.auth.AuthUtils;
import com.datastax.oss.driver.api.core.config.DriverExecutionProfile;
import com.datastax.oss.driver.api.core.context.DriverContext;
import com.datastax.oss.driver.api.core.metadata.EndPoint;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.Map;
import net.jcip.annotations.ThreadSafe;

@ThreadSafe
public class DseGssApiAuthProvider
extends DseGssApiAuthProviderBase {
    private final DriverExecutionProfile config;

    public DseGssApiAuthProvider(DriverContext context) {
        super(context.getSessionName());
        this.config = context.getConfig().getDefaultProfile();
    }

    @Override
    @NonNull
    protected DseGssApiAuthProviderBase.GssApiOptions getOptions(@NonNull EndPoint endPoint, @NonNull String serverAuthenticator) {
        AuthUtils.validateConfigPresent(this.config, DseGssApiAuthProvider.class.getName(), endPoint, DseDriverOption.AUTH_PROVIDER_LOGIN_CONFIGURATION);
        DseGssApiAuthProviderBase.GssApiOptions.Builder optionsBuilder = DseGssApiAuthProviderBase.GssApiOptions.builder();
        if (this.config.isDefined(DseDriverOption.AUTH_PROVIDER_AUTHORIZATION_ID)) {
            optionsBuilder.withAuthorizationId(this.config.getString(DseDriverOption.AUTH_PROVIDER_AUTHORIZATION_ID));
        }
        if (this.config.isDefined(DseDriverOption.AUTH_PROVIDER_SERVICE)) {
            optionsBuilder.withSaslProtocol(this.config.getString(DseDriverOption.AUTH_PROVIDER_SERVICE));
        }
        if (this.config.isDefined(DseDriverOption.AUTH_PROVIDER_SASL_PROPERTIES)) {
            for (Map.Entry<String, String> entry : this.config.getStringMap(DseDriverOption.AUTH_PROVIDER_SASL_PROPERTIES).entrySet()) {
                optionsBuilder.addSaslProperty(entry.getKey(), entry.getValue());
            }
        }
        Map<String, String> loginConfigurationMap = this.config.getStringMap(DseDriverOption.AUTH_PROVIDER_LOGIN_CONFIGURATION);
        optionsBuilder.withLoginConfiguration(loginConfigurationMap);
        return optionsBuilder.build();
    }
}

