/*
 * Decompiled with CFR 0.152.
 */
package com.databend.jdbc.cloud;

import com.databend.jdbc.cloud.ExternalLocationS3;

public class DatabendStage {
    private static final String defaultStageName = "~";
    private final String stageName;
    private final String path;
    private final ExternalLocationS3 externalLocationS3;

    private DatabendStage(String stageName, String path, ExternalLocationS3 externalLocationS3) {
        this.stageName = stageName == null || stageName.isEmpty() ? defaultStageName : stageName;
        this.path = path;
        this.externalLocationS3 = externalLocationS3;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getStageName() {
        return this.stageName;
    }

    public String getPath() {
        return this.path;
    }

    public ExternalLocationS3 getExternalLocationS3() {
        return this.externalLocationS3;
    }

    public String toString() {
        if (this.externalLocationS3 != null) {
            return this.externalLocationS3.toString();
        }
        if (this.stageName != null) {
            return String.format("@%s/%s", this.stageName, this.path);
        }
        return this.path;
    }

    public static class Builder {
        private String stageName;
        private String path;
        private ExternalLocationS3 externalLocationS3;

        public Builder stageName(String stageName) {
            this.stageName = stageName;
            return this;
        }

        public Builder path(String path) {
            this.path = path;
            return this;
        }

        public Builder externalLocationS3(ExternalLocationS3 externalLocationS3) {
            this.externalLocationS3 = externalLocationS3;
            return this;
        }

        public DatabendStage build() {
            return new DatabendStage(this.stageName, this.path, this.externalLocationS3);
        }
    }
}

