/*
 * Decompiled with CFR 0.152.
 */
package com.databend.jdbc;

import com.databend.jdbc.ParamMarker;
import com.databend.jdbc.RawStatement;
import com.databend.jdbc.StatementType;
import com.databend.jdbc.StatementUtil;
import java.util.List;
import java.util.Optional;
import lombok.Generated;
import org.apache.commons.lang3.tuple.Pair;

public class QueryRawStatement
extends RawStatement {
    private final String database;
    private final String table;

    public QueryRawStatement(String sql, String cleanSql, List<ParamMarker> paramPositions) {
        super(sql, cleanSql, paramPositions);
        Pair<Optional<String>, Optional<String>> databaseAndTablePair = StatementUtil.extractDbNameAndTableNamePairFromCleanQuery(this.getCleanSql());
        this.database = databaseAndTablePair.getLeft().orElse(null);
        this.table = databaseAndTablePair.getRight().orElse(null);
    }

    @Override
    public StatementType getStatementType() {
        return StatementType.QUERY;
    }

    @Generated
    public String getDatabase() {
        return this.database;
    }

    @Generated
    public String getTable() {
        return this.table;
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof QueryRawStatement)) {
            return false;
        }
        QueryRawStatement other = (QueryRawStatement)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$database = this.getDatabase();
        String other$database = other.getDatabase();
        if (this$database == null ? other$database != null : !this$database.equals(other$database)) {
            return false;
        }
        String this$table = this.getTable();
        String other$table = other.getTable();
        return !(this$table == null ? other$table != null : !this$table.equals(other$table));
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof QueryRawStatement;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $database = this.getDatabase();
        result = result * 59 + ($database == null ? 43 : $database.hashCode());
        String $table = this.getTable();
        result = result * 59 + ($table == null ? 43 : $table.hashCode());
        return result;
    }
}

