/*
 * Decompiled with CFR 0.152.
 */
package com.databend.jdbc;

import com.databend.jdbc.DatabendColumnInfo;
import com.databend.jdbc.DatabendResultSetMetaData;
import com.databend.jdbc.JdbcTypeMapping;
import com.databend.jdbc.JdbcWrapper;
import java.sql.ParameterMetaData;
import java.sql.SQLException;
import java.util.List;
import java.util.Locale;
import java.util.Objects;

public class DatabendParameterMetaData
extends JdbcWrapper
implements ParameterMetaData {
    protected final List<DatabendColumnInfo> params;
    protected final JdbcTypeMapping mapper;

    protected DatabendParameterMetaData(List<DatabendColumnInfo> params, JdbcTypeMapping mapper) {
        this.params = Objects.requireNonNull(params, "connection is null");
        this.mapper = mapper;
    }

    protected DatabendColumnInfo getParameter(int param) throws SQLException {
        if (param < 1 || param > this.params.size()) {
            throw new RuntimeException(DatabendParameterMetaData.format("Parameter index should between 1 and %d but we got %d", this.params.size(), param));
        }
        return this.params.get(param - 1);
    }

    public static String format(String template, Object ... args2) {
        return String.format(Locale.ROOT, template, args2);
    }

    @Override
    public int getParameterCount() throws SQLException {
        return this.params.size();
    }

    @Override
    public int isNullable(int param) throws SQLException {
        DatabendColumnInfo p = this.getParameter(param);
        if (p == null) {
            return 2;
        }
        return p.getType().isNullable() ? 1 : 0;
    }

    @Override
    public boolean isSigned(int param) throws SQLException {
        DatabendColumnInfo p = this.getParameter(param);
        return p != null && p.isSigned();
    }

    @Override
    public int getPrecision(int param) throws SQLException {
        DatabendColumnInfo p = this.getParameter(param);
        return p != null ? p.getPrecision() : 0;
    }

    @Override
    public int getScale(int param) throws SQLException {
        DatabendColumnInfo p = this.getParameter(param);
        return p != null ? p.getScale() : 0;
    }

    @Override
    public int getParameterType(int param) throws SQLException {
        DatabendColumnInfo p = this.getParameter(param);
        return p != null ? this.mapper.toSqlType(p) : 1111;
    }

    @Override
    public String getParameterTypeName(int param) throws SQLException {
        DatabendColumnInfo p = this.getParameter(param);
        return p != null ? p.getColumnTypeName() : "<unknown>";
    }

    @Override
    public String getParameterClassName(int param) throws SQLException {
        DatabendColumnInfo p = this.getParameter(param);
        return DatabendResultSetMetaData.getTypeClassName(p.getColumnType());
    }

    @Override
    public int getParameterMode(int param) throws SQLException {
        return 1;
    }
}

