/*
 * Decompiled with CFR 0.152.
 */
package com.databend.jdbc;

import com.databend.client.ClientSettings;
import com.databend.client.DatabendClientV1;
import com.databend.client.DiscoveryNode;
import com.databend.jdbc.DatabendClientLoadBalancingPolicy;
import com.databend.jdbc.DatabendDriverUri;
import com.databend.jdbc.DatabendNodeRouter;
import java.net.URI;
import java.net.URISyntaxException;
import java.security.InvalidParameterException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.logging.Level;
import java.util.logging.Logger;
import lombok.Generated;
import okhttp3.OkHttpClient;

public class DatabendNodes
implements DatabendNodeRouter {
    private AtomicReference<List<URI>> query_nodes_uris;
    protected final AtomicInteger index;
    protected final AtomicReference<Long> lastDiscoveryTime = new AtomicReference<Long>(0L);
    private static final Logger logger = Logger.getLogger(DatabendNodes.class.getPackage().getName());
    private boolean debug = false;
    protected long discoveryInterval;
    protected DatabendClientLoadBalancingPolicy policy;
    private final String uriPath;
    private final String uriQuery;
    private final String uriFragment;
    private boolean useSecureConnection = false;
    private String sslmode = "disable";

    public DatabendNodes(List<URI> queryNodesUris, DatabendClientLoadBalancingPolicy policy, String UriPath, String UriQuery, String UriFragment, long discoveryInterval) {
        this.query_nodes_uris = new AtomicReference<List<URI>>(queryNodesUris);
        this.policy = policy;
        this.index = new AtomicInteger(0);
        this.uriPath = UriPath;
        this.uriQuery = UriQuery;
        this.uriFragment = UriFragment;
        this.discoveryInterval = discoveryInterval;
    }

    @Override
    public List<URI> getUris() {
        return this.query_nodes_uris.get();
    }

    public void setSSL(boolean useSecureConnection, String sslmode) {
        this.useSecureConnection = useSecureConnection;
        this.sslmode = sslmode;
    }

    public void setDiscoveryInterval(long discoveryInterval) {
        this.discoveryInterval = discoveryInterval;
    }

    public void updateNodes(List<URI> query_nodes_uris) {
        this.query_nodes_uris.set(query_nodes_uris);
    }

    public void updatePolicy(DatabendClientLoadBalancingPolicy policy) {
        this.policy = policy;
    }

    @Override
    public DatabendClientLoadBalancingPolicy getPolicy() {
        return this.policy;
    }

    @Override
    public void discoverUris(OkHttpClient client, ClientSettings settings2) throws UnsupportedOperationException {
        Long lastDiscoveryTime = this.lastDiscoveryTime.get();
        if (System.currentTimeMillis() - lastDiscoveryTime < this.discoveryInterval) {
            return;
        }
        List<URI> current_uris = this.query_nodes_uris.get();
        if (!this.lastDiscoveryTime.compareAndSet(lastDiscoveryTime, System.currentTimeMillis())) {
            return;
        }
        try {
            List<URI> new_uris;
            List<DiscoveryNode> new_nodes = DatabendClientV1.discoverNodes(client, settings2);
            if (!new_nodes.isEmpty() && this.query_nodes_uris.compareAndSet(current_uris, new_uris = this.parseURI(new_nodes))) {
                Level level = this.debug ? Level.INFO : Level.FINE;
                logger.log(level, "Automatic Discovery updated nodes: " + new_uris);
            }
        }
        catch (UnsupportedOperationException e) {
            throw e;
        }
        catch (RuntimeException e) {
            logger.log(Level.WARNING, "Error updating nodes: " + e.getMessage());
        }
    }

    @Override
    public boolean needDiscovery() {
        Long lastDiscoveryTime = this.lastDiscoveryTime.get();
        return System.currentTimeMillis() - lastDiscoveryTime >= this.discoveryInterval;
    }

    public List<URI> parseURI(List<DiscoveryNode> nodes) throws RuntimeException {
        String host = null;
        ArrayList<URI> uris = new ArrayList<URI>();
        try {
            for (DiscoveryNode node : nodes) {
                String raw_host = node.getAddress();
                String fullUri = raw_host.startsWith("http://") || raw_host.startsWith("https://") ? raw_host : "http://" + raw_host;
                URI uri = new URI(fullUri);
                String authority = uri.getAuthority();
                String[] hostAndPort = authority.split(":");
                if (hostAndPort.length == 2) {
                    host = hostAndPort[0];
                } else if (hostAndPort.length == 1) {
                    host = hostAndPort[0];
                } else {
                    throw new InvalidParameterException("Invalid host and port, url: " + uri);
                }
                if (host == null || host.isEmpty()) {
                    throw new InvalidParameterException("Invalid host " + host);
                }
                uris.add(new URI(uri.getScheme(), uri.getUserInfo(), uri.getHost(), uri.getPort(), this.uriPath, this.uriQuery, this.uriFragment));
            }
            return DatabendDriverUri.canonicalizeUris(uris, this.useSecureConnection, this.sslmode);
        }
        catch (URISyntaxException e) {
            throw new InvalidParameterException("Invalid URI " + e.getMessage());
        }
        catch (SQLException e) {
            throw new RuntimeException("Error parsing URI " + e.getMessage());
        }
    }

    public URI pickUri(String query_id) {
        return this.policy.pickUri(query_id, this);
    }

    public String toString() {
        return "DatabendNodes{query_nodes_uris=" + this.query_nodes_uris + ", policy=" + this.policy + '}';
    }

    @Generated
    public void setDebug(boolean debug) {
        this.debug = debug;
    }
}

