/*
 * Decompiled with CFR 0.152.
 */
package com.databend.jdbc;

import com.databend.jdbc.DatabendNodes;
import java.net.URI;
import java.util.List;

public class DatabendClientLoadBalancingPolicy {
    public static final String DISABLED = "disabled";
    public static final String RANDOM = "random";
    public static final String ROUND_ROBIN = "round_robin";

    static DatabendClientLoadBalancingPolicy create(String name) {
        DatabendClientLoadBalancingPolicy policy;
        if (RANDOM.equalsIgnoreCase(name)) {
            policy = new RandomPolicy();
        } else if (ROUND_ROBIN.equalsIgnoreCase(name)) {
            policy = new RoundRobinPolicy();
        } else if (DISABLED.equalsIgnoreCase(name)) {
            policy = new DisabledPolicy();
        } else {
            throw new IllegalArgumentException("Unknown load balancing policy: " + name);
        }
        return policy;
    }

    protected URI pickUri(String query_id, DatabendNodes nodes) {
        if (nodes == null || nodes.getUris() == null || nodes.getUris().isEmpty()) {
            return null;
        }
        return nodes.getUris().get(0);
    }

    private static int getQueryHash(String query_id) {
        if (query_id.isEmpty()) {
            return 0;
        }
        int hash = 202011;
        for (char c : query_id.toCharArray()) {
            hash = hash * 31 + c;
        }
        return hash;
    }

    static class RandomPolicy
    extends DatabendClientLoadBalancingPolicy {
        RandomPolicy() {
        }

        @Override
        protected URI pickUri(String query_id, DatabendNodes nodes) {
            List<URI> uris = nodes.getUris();
            if (uris == null || uris.isEmpty()) {
                return null;
            }
            int deterministicValue = DatabendClientLoadBalancingPolicy.getQueryHash(query_id);
            int index = Math.abs(deterministicValue) % uris.size();
            return uris.get(index);
        }

        public String toString() {
            return "Random";
        }
    }

    static class RoundRobinPolicy
    extends DatabendClientLoadBalancingPolicy {
        RoundRobinPolicy() {
        }

        @Override
        protected URI pickUri(String query_id, DatabendNodes nodes) {
            List<URI> uris = nodes.getUris();
            if (uris == null || uris.isEmpty()) {
                return null;
            }
            int index = nodes.index.getAndUpdate(v -> v + 1 >= uris.size() ? 0 : v + 1);
            return uris.get(index);
        }

        public String toString() {
            return "RoundRobin";
        }
    }

    static class DisabledPolicy
    extends DatabendClientLoadBalancingPolicy {
        DisabledPolicy() {
        }

        public String toString() {
            return "Disabled";
        }
    }
}

