/*
 * Decompiled with CFR 0.152.
 */
package com.databend.client;

import com.databend.client.DiscoveryNode;
import com.databend.client.errors.QueryErrors;
import com.databend.jdbc.com.fasterxml.jackson.core.JsonParser;
import com.databend.jdbc.com.fasterxml.jackson.core.JsonProcessingException;
import com.databend.jdbc.com.fasterxml.jackson.core.TreeNode;
import com.databend.jdbc.com.fasterxml.jackson.databind.DeserializationContext;
import com.databend.jdbc.com.fasterxml.jackson.databind.JsonNode;
import com.databend.jdbc.com.fasterxml.jackson.databind.ObjectMapper;
import com.databend.jdbc.com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.databend.jdbc.com.fasterxml.jackson.databind.module.SimpleModule;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class DiscoveryResponseCodec {
    public static <T> T fromJson(String json, Class<T> valueType) throws JsonProcessingException {
        ObjectMapper objectMapper = new ObjectMapper();
        SimpleModule module = new SimpleModule();
        module.addDeserializer(DiscoveryResponse.class, new DiscoveryResponseDeserializer());
        objectMapper.registerModule(module);
        return objectMapper.readValue(json, valueType);
    }

    public static class DiscoveryResponse {
        private final List<DiscoveryNode> nodes;
        private final QueryErrors error;

        public DiscoveryResponse(List<DiscoveryNode> nodes, QueryErrors error) {
            this.nodes = nodes;
            this.error = error;
        }

        public List<DiscoveryNode> getNodes() {
            return this.nodes;
        }

        public QueryErrors getError() {
            return this.error;
        }
    }

    public static class DiscoveryResponseDeserializer
    extends StdDeserializer<DiscoveryResponse> {
        public DiscoveryResponseDeserializer() {
            this((Class<?>)null);
        }

        public DiscoveryResponseDeserializer(Class<?> vc) {
            super(vc);
        }

        @Override
        public DiscoveryResponse deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException, JsonProcessingException {
            ObjectMapper mapper = (ObjectMapper)jp.getCodec();
            JsonNode rootNode = (JsonNode)mapper.readTree(jp);
            ArrayList<DiscoveryNode> nodes = new ArrayList<DiscoveryNode>();
            QueryErrors error = null;
            if (rootNode.has("error")) {
                error = mapper.treeToValue((TreeNode)rootNode.get("error"), QueryErrors.class);
            } else if (rootNode.isArray()) {
                for (JsonNode element : rootNode) {
                    DiscoveryNode node = new DiscoveryNode(element.get("address").asText());
                    nodes.add(node);
                }
            } else {
                throw new JsonProcessingException("Unrecognized JSON format"){};
            }
            return new DiscoveryResponse(nodes, error);
        }
    }
}

