/*
 * Decompiled with CFR 0.152.
 */
package com.databend.client;

import com.databend.jdbc.com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.databend.jdbc.com.fasterxml.jackson.annotation.JsonAnySetter;
import com.databend.jdbc.com.fasterxml.jackson.annotation.JsonCreator;
import com.databend.jdbc.com.fasterxml.jackson.annotation.JsonProperty;
import com.google.shaded.common.base.MoreObjects;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;

public class DatabendSession {
    private static final String DEFAULT_DATABASE = "default";
    private static final String AUTO_COMMIT = "AutoCommit";
    private static final String TXN_STATE_ACTIVE = "Active";
    private final String database;
    private final AtomicBoolean autoCommit = new AtomicBoolean(false);
    private final Map<String, String> settings;
    private String txnState;
    private Boolean needSticky;
    private Boolean needKeepAlive;
    private Map<String, Object> additionalProperties = new HashMap<String, Object>();

    @JsonCreator
    public DatabendSession(@JsonProperty(value="database") String database, @JsonProperty(value="settings") Map<String, String> settings2, @JsonProperty(value="txn_state") String txnState, @JsonProperty(value="need_sticky") Boolean needSticky, @JsonProperty(value="need_keep_alive") Boolean needKeepAlive) {
        this.database = database;
        this.settings = settings2;
        this.txnState = txnState;
        this.needSticky = needSticky != null ? needSticky : false;
        this.needKeepAlive = needKeepAlive != null ? needKeepAlive : false;
    }

    public static DatabendSession createDefault() {
        return new DatabendSession(DEFAULT_DATABASE, null, null, false, false);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonProperty
    public String getDatabase() {
        return this.database;
    }

    @JsonProperty
    public Map<String, String> getSettings() {
        return this.settings;
    }

    @JsonProperty(value="txn_state")
    public String getTxnState() {
        return this.txnState;
    }

    @JsonProperty(value="need_sticky")
    public Boolean getNeedSticky() {
        return this.needSticky;
    }

    @JsonProperty(value="need_keep_alive")
    public Boolean getNeedKeepAlive() {
        return this.needKeepAlive;
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @JsonAnySetter
    public void setAdditionalProperty(String key, Object value) {
        this.additionalProperties.put(key, value);
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).add("database", this.database).add("settings", this.settings).toString();
    }

    public boolean getAutoCommit() {
        return this.autoCommit.get();
    }

    public boolean inActiveTransaction() {
        return this.txnState != null && this.txnState.equals(TXN_STATE_ACTIVE);
    }

    public void setAutoCommit(boolean autoCommit) {
        this.autoCommit.set(autoCommit);
        if (autoCommit) {
            this.txnState = AUTO_COMMIT;
        }
    }

    public static final class Builder {
        private String database;
        private final AtomicBoolean autoCommit = new AtomicBoolean(false);
        private Map<String, String> settings;
        private String txnState;

        public Builder setDatabase(String database) {
            this.database = database;
            return this;
        }

        public Builder setSettings(Map<String, String> settings2) {
            this.settings = settings2;
            return this;
        }

        public Builder setTxnState(String txnState) {
            this.txnState = txnState;
            return this;
        }

        public boolean getAutoCommit() {
            return this.autoCommit.get();
        }

        public void setAutoCommit(boolean autoCommit) {
            this.autoCommit.set(autoCommit);
            if (autoCommit) {
                this.txnState = DatabendSession.AUTO_COMMIT;
            }
        }

        public DatabendSession build() {
            return new DatabendSession(this.database, this.settings, this.txnState, false, false);
        }
    }
}

