/*
 * Decompiled with CFR 0.152.
 */
package com.dangdang.ddframe.job.lite.lifecycle.internal.statistics;

import com.dangdang.ddframe.job.lite.internal.storage.JobNodePath;
import com.dangdang.ddframe.job.lite.lifecycle.api.ShardingStatisticsAPI;
import com.dangdang.ddframe.job.lite.lifecycle.domain.ShardingInfo;
import com.dangdang.ddframe.job.reg.base.CoordinatorRegistryCenter;
import java.beans.ConstructorProperties;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public final class ShardingStatisticsAPIImpl
implements ShardingStatisticsAPI {
    private final CoordinatorRegistryCenter regCenter;

    @Override
    public Collection<ShardingInfo> getShardingInfo(String jobName) {
        String shardingRootPath = new JobNodePath(jobName).getShardingNodePath();
        List items = this.regCenter.getChildrenKeys(shardingRootPath);
        ArrayList<ShardingInfo> result = new ArrayList<ShardingInfo>(items.size());
        for (String each : items) {
            result.add(this.getShardingInfo(jobName, each));
        }
        Collections.sort(result);
        return result;
    }

    private ShardingInfo getShardingInfo(String jobName, String item) {
        ShardingInfo result = new ShardingInfo();
        result.setItem(Integer.parseInt(item));
        JobNodePath jobNodePath = new JobNodePath(jobName);
        String instanceId = this.regCenter.get(jobNodePath.getShardingNodePath(item, "instance"));
        boolean disabled = this.regCenter.isExisted(jobNodePath.getShardingNodePath(item, "disabled"));
        boolean running = this.regCenter.isExisted(jobNodePath.getShardingNodePath(item, "running"));
        boolean shardingError = !this.regCenter.isExisted(jobNodePath.getInstanceNodePath(instanceId));
        result.setStatus(ShardingInfo.ShardingStatus.getShardingStatus(disabled, running, shardingError));
        result.setFailover(this.regCenter.isExisted(jobNodePath.getShardingNodePath(item, "failover")));
        if (null != instanceId) {
            String[] ipAndPid = instanceId.split("@-@");
            result.setServerIp(ipAndPid[0]);
            result.setInstanceId(ipAndPid[1]);
        }
        return result;
    }

    @ConstructorProperties(value={"regCenter"})
    public ShardingStatisticsAPIImpl(CoordinatorRegistryCenter regCenter) {
        this.regCenter = regCenter;
    }
}

