/*
 * Decompiled with CFR 0.152.
 */
package com.dangdang.ddframe.job.lite.internal.listener;

import com.dangdang.ddframe.job.lite.internal.instance.InstanceService;
import com.dangdang.ddframe.job.lite.internal.schedule.JobRegistry;
import com.dangdang.ddframe.job.lite.internal.schedule.JobScheduleController;
import com.dangdang.ddframe.job.lite.internal.server.ServerService;
import com.dangdang.ddframe.job.lite.internal.sharding.ExecutionService;
import com.dangdang.ddframe.job.lite.internal.sharding.ShardingService;
import com.dangdang.ddframe.job.reg.base.CoordinatorRegistryCenter;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.state.ConnectionState;
import org.apache.curator.framework.state.ConnectionStateListener;

public final class RegistryCenterConnectionStateListener
implements ConnectionStateListener {
    private final String jobName;
    private final ServerService serverService;
    private final InstanceService instanceService;
    private final ShardingService shardingService;
    private final ExecutionService executionService;

    public RegistryCenterConnectionStateListener(CoordinatorRegistryCenter regCenter, String jobName) {
        this.jobName = jobName;
        this.serverService = new ServerService(regCenter, jobName);
        this.instanceService = new InstanceService(regCenter, jobName);
        this.shardingService = new ShardingService(regCenter, jobName);
        this.executionService = new ExecutionService(regCenter, jobName);
    }

    public void stateChanged(CuratorFramework client, ConnectionState newState) {
        if (JobRegistry.getInstance().isShutdown(this.jobName)) {
            return;
        }
        JobScheduleController jobScheduleController = JobRegistry.getInstance().getJobScheduleController(this.jobName);
        if (ConnectionState.SUSPENDED == newState || ConnectionState.LOST == newState) {
            jobScheduleController.pauseJob();
        } else if (ConnectionState.RECONNECTED == newState) {
            this.serverService.persistOnline(this.serverService.isEnableServer(JobRegistry.getInstance().getJobInstance(this.jobName).getIp()));
            this.instanceService.persistOnline();
            this.executionService.clearRunningInfo(this.shardingService.getLocalShardingItems());
            jobScheduleController.resumeJob();
        }
    }
}

