/*
 * Decompiled with CFR 0.152.
 */
package com.dangdang.ddframe.job.internal.server;

import com.dangdang.ddframe.job.internal.env.LocalHostService;
import com.dangdang.ddframe.job.internal.storage.JobNodePath;

public final class ServerNode {
    public static final String ROOT = "servers";
    static final String HOST_NAME = "servers/%s/hostName";
    static final String STATUS_APPENDIX = "status";
    static final String STATUS = "servers/%s/status";
    static final String DISABLED_APPENDIX = "disabled";
    static final String DISABLED = "servers/%s/disabled";
    static final String PROCESS_SUCCESS_COUNT = "servers/%s/processSuccessCount";
    static final String PROCESS_FAILURE_COUNT = "servers/%s/processFailureCount";
    static final String STOPPED = "servers/%s/stoped";
    static final String SHUTDOWN = "servers/%s/shutdown";
    private final LocalHostService localHostService = new LocalHostService();
    private final JobNodePath jobNodePath;

    public ServerNode(String jobName) {
        this.jobNodePath = new JobNodePath(jobName);
    }

    static String getHostNameNode(String ip) {
        return String.format(HOST_NAME, ip);
    }

    static String getStatusNode(String ip) {
        return String.format(STATUS, ip);
    }

    static String getDisabledNode(String ip) {
        return String.format(DISABLED, ip);
    }

    static String getProcessSuccessCountNode(String ip) {
        return String.format(PROCESS_SUCCESS_COUNT, ip);
    }

    static String getProcessFailureCountNode(String ip) {
        return String.format(PROCESS_FAILURE_COUNT, ip);
    }

    static String getStoppedNode(String ip) {
        return String.format(STOPPED, ip);
    }

    static String getShutdownNode(String ip) {
        return String.format(SHUTDOWN, ip);
    }

    boolean isJobStoppedPath(String path) {
        return path.startsWith(this.jobNodePath.getFullPath(String.format(STOPPED, this.localHostService.getIp())));
    }

    boolean isJobShutdownPath(String path) {
        return path.startsWith(this.jobNodePath.getFullPath(String.format(SHUTDOWN, this.localHostService.getIp())));
    }

    public boolean isServerStatusPath(String path) {
        return path.startsWith(this.jobNodePath.getFullPath(ROOT)) && path.endsWith(STATUS_APPENDIX);
    }

    public boolean isServerDisabledPath(String path) {
        return path.startsWith(this.jobNodePath.getFullPath(ROOT)) && path.endsWith(DISABLED_APPENDIX);
    }
}

