/*
 * Decompiled with CFR 0.152.
 */
package com.dangdang.ddframe.job.internal.monitor;

import com.dangdang.ddframe.job.api.JobConfiguration;
import com.dangdang.ddframe.job.internal.config.ConfigurationService;
import com.dangdang.ddframe.job.internal.util.SensitiveInfoUtils;
import com.dangdang.ddframe.reg.base.CoordinatorRegistryCenter;
import com.google.common.base.Joiner;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.ArrayList;
import java.util.List;
import org.apache.curator.framework.recipes.cache.ChildData;
import org.apache.curator.framework.recipes.cache.TreeCache;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MonitorService {
    private static final Logger log = LoggerFactory.getLogger(MonitorService.class);
    public static final String DUMP_COMMAND = "dump";
    private final String jobName;
    private final CoordinatorRegistryCenter coordinatorRegistryCenter;
    private final ConfigurationService configService;
    private ServerSocket serverSocket;
    private volatile boolean closed;

    public MonitorService(CoordinatorRegistryCenter coordinatorRegistryCenter, JobConfiguration jobConfiguration) {
        this.jobName = jobConfiguration.getJobName();
        this.coordinatorRegistryCenter = coordinatorRegistryCenter;
        this.configService = new ConfigurationService(coordinatorRegistryCenter, jobConfiguration);
    }

    public void listen() {
        int port = this.configService.getMonitorPort();
        if (port < 0) {
            return;
        }
        try {
            log.info("Elastic job: monitor service is running, the port is '{}'", (Object)port);
            this.openSocketForMonitor(port);
        }
        catch (IOException ex) {
            log.warn(ex.getMessage());
        }
    }

    private void openSocketForMonitor(int port) throws IOException {
        this.serverSocket = new ServerSocket(port);
        new Thread(){

            @Override
            public void run() {
                while (!MonitorService.this.closed) {
                    try {
                        MonitorService.this.process(MonitorService.this.serverSocket.accept());
                    }
                    catch (IOException ex) {
                        log.warn(ex.getMessage());
                    }
                }
            }
        }.start();
    }

    private void process(Socket socket) {
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(socket.getInputStream()));
             BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(socket.getOutputStream()));
             Socket autoCloseSocket = socket;){
            String cmdLine = reader.readLine();
            if (null != cmdLine && DUMP_COMMAND.equalsIgnoreCase(cmdLine)) {
                ArrayList<String> result = new ArrayList<String>();
                this.dumpDirectly("/" + this.jobName, result);
                this.outputMessage(writer, Joiner.on((String)"\n").join(SensitiveInfoUtils.filterSensitiveIps(result)) + "\n");
            }
        }
        catch (IOException ex) {
            log.warn(ex.getMessage());
        }
    }

    private void dumpDirectly(String path, List<String> result) {
        for (String each : this.coordinatorRegistryCenter.getChildrenKeys(path)) {
            String treeCacheValue;
            TreeCache treeCache;
            ChildData treeCacheData;
            String zkPath = path + "/" + each;
            String zkValue = this.coordinatorRegistryCenter.get(zkPath);
            if (null == zkValue) {
                zkValue = "";
            }
            String treeCachePath = null == (treeCacheData = (treeCache = (TreeCache)this.coordinatorRegistryCenter.getRawCache("/" + this.jobName)).getCurrentData(zkPath)) ? "" : treeCacheData.getPath();
            String string = treeCacheValue = null == treeCacheData ? "" : new String(treeCacheData.getData());
            if (zkValue.equals(treeCacheValue) && zkPath.equals(treeCachePath)) {
                result.add(Joiner.on((String)" | ").join((Object)zkPath, (Object)zkValue, new Object[0]));
            } else {
                result.add(Joiner.on((String)" | ").join((Object)zkPath, (Object)zkValue, new Object[]{treeCachePath, treeCacheValue}));
            }
            this.dumpDirectly(zkPath, result);
        }
    }

    private void outputMessage(BufferedWriter outputWriter, String msg) throws IOException {
        outputWriter.append(msg);
        outputWriter.flush();
    }

    public void close() {
        this.closed = true;
        if (null != this.serverSocket && !this.serverSocket.isClosed()) {
            try {
                this.serverSocket.close();
            }
            catch (IOException ex) {
                log.warn(ex.getMessage());
            }
        }
    }
}

