/*
 * Decompiled with CFR 0.152.
 */
package com.dangdang.ddframe.job.internal.failover;

import com.dangdang.ddframe.job.api.JobConfiguration;
import com.dangdang.ddframe.job.internal.env.LocalHostService;
import com.dangdang.ddframe.job.internal.failover.FailoverNode;
import com.dangdang.ddframe.job.internal.schedule.JobRegistry;
import com.dangdang.ddframe.job.internal.server.ServerService;
import com.dangdang.ddframe.job.internal.sharding.ShardingService;
import com.dangdang.ddframe.job.internal.storage.JobNodeStorage;
import com.dangdang.ddframe.job.internal.storage.LeaderExecutionCallback;
import com.dangdang.ddframe.reg.base.CoordinatorRegistryCenter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FailoverService {
    private static final Logger log = LoggerFactory.getLogger(FailoverService.class);
    private final LocalHostService localHostService = new LocalHostService();
    private final JobConfiguration jobConfiguration;
    private final JobNodeStorage jobNodeStorage;
    private final ServerService serverService;
    private final ShardingService shardingService;

    public FailoverService(CoordinatorRegistryCenter coordinatorRegistryCenter, JobConfiguration jobConfiguration) {
        this.jobConfiguration = jobConfiguration;
        this.jobNodeStorage = new JobNodeStorage(coordinatorRegistryCenter, jobConfiguration);
        this.serverService = new ServerService(coordinatorRegistryCenter, jobConfiguration);
        this.shardingService = new ShardingService(coordinatorRegistryCenter, jobConfiguration);
    }

    public void setCrashedFailoverFlag(int item) {
        if (!this.isFailoverAssigned(item)) {
            this.jobNodeStorage.createJobNodeIfNeeded(FailoverNode.getItemsNode(item));
        }
    }

    private boolean isFailoverAssigned(Integer item) {
        return this.jobNodeStorage.isJobNodeExisted(FailoverNode.getExecutionFailoverNode(item));
    }

    public void failoverIfNecessary() {
        if (!this.needFailover()) {
            return;
        }
        this.jobNodeStorage.executeInLeader("leader/failover/latch", new FailoverLeaderExecutionCallback());
    }

    private boolean needFailover() {
        return this.jobNodeStorage.isJobNodeExisted("leader/failover/items") && !this.jobNodeStorage.getJobNodeChildrenKeys("leader/failover/items").isEmpty() && this.serverService.isServerReady();
    }

    public void updateFailoverComplete(List<Integer> items) {
        for (int each : items) {
            this.jobNodeStorage.removeJobNodeIfExisted(FailoverNode.getExecutionFailoverNode(each));
        }
    }

    public List<Integer> getLocalHostFailoverItems() {
        List<String> items = this.jobNodeStorage.getJobNodeChildrenKeys("execution");
        ArrayList<Integer> result = new ArrayList<Integer>(items.size());
        String ip = this.localHostService.getIp();
        for (String each : items) {
            int item = Integer.parseInt(each);
            String node = FailoverNode.getExecutionFailoverNode(item);
            if (!this.jobNodeStorage.isJobNodeExisted(node) || !ip.equals(this.jobNodeStorage.getJobNodeDataDirectly(node))) continue;
            result.add(item);
        }
        Collections.sort(result);
        return result;
    }

    public List<Integer> getLocalHostTakeOffItems() {
        List<Integer> shardingItems = this.shardingService.getLocalHostShardingItems();
        ArrayList<Integer> result = new ArrayList<Integer>(shardingItems.size());
        for (int each : shardingItems) {
            if (!this.jobNodeStorage.isJobNodeExisted(FailoverNode.getExecutionFailoverNode(each))) continue;
            result.add(each);
        }
        return result;
    }

    public void removeFailoverInfo() {
        for (String each : this.jobNodeStorage.getJobNodeChildrenKeys("execution")) {
            this.jobNodeStorage.removeJobNodeIfExisted(FailoverNode.getExecutionFailoverNode(Integer.parseInt(each)));
        }
    }

    class FailoverLeaderExecutionCallback
    implements LeaderExecutionCallback {
        FailoverLeaderExecutionCallback() {
        }

        @Override
        public void execute() {
            if (!FailoverService.this.needFailover()) {
                return;
            }
            int crashedItem = Integer.parseInt(FailoverService.this.jobNodeStorage.getJobNodeChildrenKeys("leader/failover/items").get(0));
            log.debug("Elastic job: failover job begin, crashed item:{}.", (Object)crashedItem);
            FailoverService.this.jobNodeStorage.fillEphemeralJobNode(FailoverNode.getExecutionFailoverNode(crashedItem), FailoverService.this.localHostService.getIp());
            FailoverService.this.jobNodeStorage.removeJobNodeIfExisted(FailoverNode.getItemsNode(crashedItem));
            JobRegistry.getInstance().getJobScheduler(FailoverService.this.jobConfiguration.getJobName()).triggerJob();
        }
    }
}

