/*
 * Decompiled with CFR 0.152.
 */
package dm.jdbc.util;

import dm.jdbc.driver.DBError;
import dm.jdbc.util.StringUtil;
import dm.jdbc.util.buffer.Buffer;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.SQLException;
import java.util.Collection;
import java.util.Iterator;

public class ConvertUtil {
    public static boolean toBoolean(String str) {
        if (StringUtil.equals(str = StringUtil.trimToEmpty(str), "0")) {
            return false;
        }
        if (StringUtil.equals(str, "1")) {
            return true;
        }
        boolean ret = false;
        try {
            ret = Boolean.valueOf(str);
        }
        catch (Exception exception) {
            DBError.throwRuntimeException(DBError.ECJDBC_DATA_CONVERTION_ERROR.reason);
        }
        return ret;
    }

    public static int toInt(long val) {
        return val > Integer.MAX_VALUE ? Integer.MAX_VALUE : (int)val;
    }

    public static Integer toInteger(String in, String start, String to) {
        if (StringUtil.isEmpty(in = StringUtil.substringBetween(in, start, to))) {
            return null;
        }
        try {
            return Integer.parseInt(in);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static long[] toLongArray(Collection<Long> collections) {
        long[] arrs = new long[collections.size()];
        Iterator<Long> iterator = collections.iterator();
        int i2 = 0;
        while (i2 < arrs.length) {
            arrs[i2] = iterator.next();
            ++i2;
        }
        return arrs;
    }

    public static final char[] ASCIIBytesToJavaChars(byte[] asciiBytes, int srcOffset, int len) throws SQLException {
        char[] javaChars = new char[len];
        int k2 = srcOffset + len;
        int i2 = srcOffset;
        int j2 = srcOffset;
        while (i2 < k2) {
            javaChars[i2] = (char)(0xFF & asciiBytes[j2]);
            ++i2;
            ++j2;
        }
        return javaChars;
    }

    public static final byte[] JavaCharsToASCIIBytes(char[] javaChars, int srcOffset, int len) {
        byte[] asciiBytes = new byte[len];
        int i2 = 0;
        while (i2 < len) {
            asciiBytes[i2] = (byte)javaChars[srcOffset + i2];
            ++i2;
        }
        return asciiBytes;
    }

    public static final byte[] StringToAsciiBytes(String paramString) {
        if (StringUtil.isEmpty(paramString)) {
            return new byte[0];
        }
        char[] chars = paramString.toCharArray();
        return ConvertUtil.JavaCharsToASCIIBytes(chars, 0, chars.length);
    }

    public static final byte[] JavaCharsToUnicodeBytes(char[] chars, int off, int len) {
        byte[] bytes = new byte[len * 2];
        int cind = off;
        int bind = 0;
        while (bind < len) {
            char c2 = chars[cind++];
            bytes[bind++] = (byte)(c2 >> 8 & 0xFF);
            bytes[bind++] = (byte)(c2 & 0xFF);
        }
        return bytes;
    }

    public static final String UnicodeBytesToString(byte[] bytes, int len) {
        int k2 = len >>> 1;
        char[] chars = new char[k2];
        int i2 = 0;
        int j2 = 0;
        while (i2 < k2) {
            int m2 = bytes[j2] << 8;
            chars[i2] = (char)(m2 | bytes[j2 + 1] & 0xFF);
            j2 += 2;
            ++i2;
        }
        return new String(chars);
    }

    public static byte[] StringToUnicodeBytes(String str) {
        if (StringUtil.isEmpty(str)) {
            return new byte[0];
        }
        char[] chars = str.toCharArray();
        return ConvertUtil.JavaCharsToASCIIBytes(chars, 0, chars.length);
    }

    public static String getClobData(Clob clob, long start, long length) throws SQLException {
        if (length < Integer.MAX_VALUE) {
            return clob.getSubString(start, (int)length);
        }
        StringBuilder buf = new StringBuilder();
        long available = length;
        int read = 0;
        long pos = start;
        while (available > 0L) {
            read = (int)(available < Integer.MAX_VALUE ? available : Integer.MAX_VALUE);
            buf.append(clob.getSubString(pos, read));
            available -= (long)read;
            pos += (long)read;
        }
        return buf.toString();
    }

    public static String getClobData(Clob clob) throws SQLException {
        long length = clob.length();
        return ConvertUtil.getClobData(clob, 1L, length);
    }

    public static byte[] getBlobData(Blob blob, long start, long length) throws SQLException {
        if (length < Integer.MAX_VALUE) {
            return blob.getBytes(start, (int)length);
        }
        Buffer buf = Buffer.allocate(Integer.MAX_VALUE, true, 0);
        long available = length;
        int read = 0;
        long pos = start;
        while (available > 0L) {
            read = (int)(available < Integer.MAX_VALUE ? available : Integer.MAX_VALUE);
            buf.writeBytes(blob.getBytes(pos, read));
            available -= (long)read;
            pos += (long)read;
        }
        buf.rewind(0);
        return buf.readBytes(buf.length());
    }

    public static byte[] getBlobData(Blob blob) throws SQLException {
        long length = blob.length();
        return ConvertUtil.getBlobData(blob, 1L, length);
    }
}

