/*
 * Decompiled with CFR 0.152.
 */
package dm.jdbc.util;

import java.nio.charset.Charset;

public class ByteUtil {
    public static int setByte(byte[] bytes, int offset, byte b2) {
        bytes[offset] = b2;
        return 1;
    }

    public static int setShort(byte[] bytes, int offset, short s2) {
        bytes[offset++] = (byte)s2;
        bytes[offset++] = (byte)(s2 >> 8);
        return 2;
    }

    public static int setInt(byte[] bytes, int offset, int i2) {
        bytes[offset++] = (byte)i2;
        bytes[offset++] = (byte)(i2 >> 8);
        bytes[offset++] = (byte)(i2 >> 16);
        bytes[offset++] = (byte)(i2 >> 24);
        return 4;
    }

    public static int setLong(byte[] bytes, int offset, long l2) {
        bytes[offset++] = (byte)l2;
        bytes[offset++] = (byte)(l2 >> 8);
        bytes[offset++] = (byte)(l2 >> 16);
        bytes[offset++] = (byte)(l2 >> 24);
        bytes[offset++] = (byte)(l2 >> 32);
        bytes[offset++] = (byte)(l2 >> 40);
        bytes[offset++] = (byte)(l2 >> 48);
        bytes[offset++] = (byte)(l2 >> 56);
        return 8;
    }

    public static int setFloat(byte[] bytes, int offset, float f2) {
        return ByteUtil.setInt(bytes, offset, Float.floatToIntBits(f2));
    }

    public static int setDouble(byte[] bytes, int offset, double d2) {
        return ByteUtil.setLong(bytes, offset, Double.doubleToLongBits(d2));
    }

    public static int setUB1(byte[] bytes, int offset, int i2) {
        bytes[offset] = (byte)i2;
        return 1;
    }

    public static int setUB2(byte[] bytes, int offset, int i2) {
        bytes[offset++] = (byte)i2;
        bytes[offset++] = (byte)(i2 >> 8);
        return 2;
    }

    public static int setUB3(byte[] bytes, int offset, int i2) {
        bytes[offset++] = (byte)i2;
        bytes[offset++] = (byte)(i2 >> 8);
        bytes[offset++] = (byte)(i2 >> 16);
        return 3;
    }

    public static int setUB4(byte[] bytes, int offset, long l2) {
        bytes[offset++] = (byte)l2;
        bytes[offset++] = (byte)(l2 >> 8);
        bytes[offset++] = (byte)(l2 >> 16);
        bytes[offset++] = (byte)(l2 >> 24);
        return 4;
    }

    public static int setBytes(byte[] bytes, int offset, byte[] srcBytes) {
        System.arraycopy(srcBytes, 0, bytes, offset, srcBytes.length);
        return srcBytes.length;
    }

    public static int setBytes(byte[] bytes, int offset, byte[] srcBytes, int srcOffset, int len) {
        System.arraycopy(srcBytes, srcOffset, bytes, offset, len);
        return len;
    }

    public static int setBytesWithLength(byte[] bytes, int offset, byte[] srcBytes) {
        offset += ByteUtil.setInt(bytes, offset, srcBytes.length);
        return 4 + ByteUtil.setBytes(bytes, offset, srcBytes);
    }

    public static int setBytesWithLength(byte[] bytes, int offset, byte[] srcBytes, int srcOffset, int len) {
        offset += ByteUtil.setInt(bytes, offset, len);
        return 4 + ByteUtil.setBytes(bytes, offset, srcBytes, srcOffset, len);
    }

    public static int setBytesWithLength2(byte[] bytes, int offset, byte[] srcBytes) {
        offset += ByteUtil.setUB2(bytes, offset, srcBytes.length);
        return 2 + ByteUtil.setBytes(bytes, offset, srcBytes);
    }

    public static int setBytesWithLength2(byte[] bytes, int offset, byte[] srcBytes, int srcOffset, int len) {
        offset += ByteUtil.setUB2(bytes, offset, len);
        return 2 + ByteUtil.setBytes(bytes, offset, srcBytes, srcOffset, len);
    }

    public static int setStringWithLength(byte[] bytes, int offset, String str, Charset encoding) {
        byte[] strBytes = ByteUtil.fromString(str, encoding);
        offset += ByteUtil.setInt(bytes, offset, strBytes.length);
        return 4 + ByteUtil.setBytes(bytes, offset, strBytes);
    }

    public static int setStringWithLength2(byte[] bytes, int offset, String str, Charset encoding) {
        byte[] strBytes = ByteUtil.fromString(str, encoding);
        offset += ByteUtil.setUB2(bytes, offset, strBytes.length);
        return 2 + ByteUtil.setBytes(bytes, offset, strBytes);
    }

    public static byte getByte(byte[] bytes, int offset) {
        return bytes[offset];
    }

    public static short getShort(byte[] bytes, int offset) {
        short val = (short)(bytes[offset++] & 0xFF);
        val = (short)(val | (short)(bytes[offset++] & 0xFF) << 8);
        return val;
    }

    public static int getInt(byte[] bytes, int offset) {
        int val = bytes[offset++] & 0xFF;
        val |= (bytes[offset++] & 0xFF) << 8;
        val |= (bytes[offset++] & 0xFF) << 16;
        return val |= (bytes[offset++] & 0xFF) << 24;
    }

    public static long getLong(byte[] bytes, int offset) {
        long val = bytes[offset++] & 0xFF;
        val |= (long)(bytes[offset++] & 0xFF) << 8;
        val |= (long)(bytes[offset++] & 0xFF) << 16;
        val |= (long)(bytes[offset++] & 0xFF) << 24;
        val |= (long)(bytes[offset++] & 0xFF) << 32;
        val |= (long)(bytes[offset++] & 0xFF) << 40;
        val |= (long)(bytes[offset++] & 0xFF) << 48;
        return val |= (long)(bytes[offset++] & 0xFF) << 56;
    }

    public static float getFloat(byte[] bytes, int offset) {
        int ival = ByteUtil.getInt(bytes, offset);
        return Float.intBitsToFloat(ival);
    }

    public static double getDouble(byte[] bytes, int offset) {
        long lval = ByteUtil.getLong(bytes, offset);
        return Double.longBitsToDouble(lval);
    }

    public static int getUB1(byte[] bytes, int offset) {
        return bytes[offset] & 0xFF;
    }

    public static int getUB2(byte[] bytes, int offset) {
        int i2 = bytes[offset++] & 0xFF;
        return i2 |= (bytes[offset++] & 0xFF) << 8;
    }

    public static int getUB3(byte[] bytes, int offset) {
        int i2 = bytes[offset++] & 0xFF;
        i2 |= (bytes[offset++] & 0xFF) << 8;
        return i2 |= (bytes[offset++] & 0xFF) << 16;
    }

    public static long getUB4(byte[] bytes, int offset) {
        long l2 = bytes[offset++] & 0xFF;
        l2 |= (long)(bytes[offset++] & 0xFF) << 8;
        l2 |= (long)(bytes[offset++] & 0xFF) << 16;
        return l2 |= (long)(bytes[offset++] & 0xFF) << 24;
    }

    public static byte[] getBytesWithLength(byte[] bytes, int offset) {
        int len = ByteUtil.getInt(bytes, offset);
        byte[] retBytes = new byte[len];
        System.arraycopy(bytes, offset + 4, retBytes, 0, len);
        return retBytes;
    }

    public static byte[] getBytesWithLength2(byte[] bytes, int offset) {
        int len = ByteUtil.getUB2(bytes, offset);
        byte[] retBytes = new byte[len];
        System.arraycopy(bytes, offset + 2, retBytes, 0, len);
        return retBytes;
    }

    public static byte[] getBytes(byte[] bytes, int offset, int len) {
        byte[] retBytes = new byte[len];
        System.arraycopy(bytes, offset, retBytes, 0, len);
        return retBytes;
    }

    public static int getBytes(byte[] bytes, int offset, byte[] objBytes) {
        return ByteUtil.getBytes(bytes, offset, objBytes, 0, objBytes.length);
    }

    public static int getBytes(byte[] bytes, int offset, byte[] objBytes, int objOffset, int len) {
        System.arraycopy(bytes, offset, objBytes, objOffset, len);
        return len;
    }

    public static String getString(byte[] bytes, int offset, int len, Charset encoding) {
        String str = new String(bytes, offset, len, encoding);
        return str;
    }

    public static String getStringWithLength(byte[] bytes, int offset, Charset encoding) {
        int len = ByteUtil.getInt(bytes, offset);
        return ByteUtil.getString(bytes, offset += 4, len, encoding);
    }

    public static String getStringWithLength2(byte[] bytes, int offset, Charset encoding) {
        int len = ByteUtil.getUB2(bytes, offset);
        return ByteUtil.getString(bytes, offset += 2, len, encoding);
    }

    public static byte[] fromByte(byte b2) {
        return new byte[]{b2};
    }

    public static byte[] fromShort(short s2) {
        return new byte[]{(byte)s2, (byte)(s2 >> 8)};
    }

    public static byte[] fromInt(int i2) {
        return new byte[]{(byte)i2, (byte)(i2 >> 8), (byte)(i2 >> 16), (byte)(i2 >> 24)};
    }

    public static byte[] fromLong(long l2) {
        return new byte[]{(byte)l2, (byte)(l2 >> 8), (byte)(l2 >> 16), (byte)(l2 >> 24), (byte)(l2 >> 32), (byte)(l2 >> 40), (byte)(l2 >> 48), (byte)(l2 >> 56)};
    }

    public static byte[] fromFloat(float f2) {
        return ByteUtil.fromInt(Float.floatToIntBits(f2));
    }

    public static byte[] fromDouble(double d2) {
        return ByteUtil.fromLong(Double.doubleToLongBits(d2));
    }

    public static byte[] fromUB1(int i2) {
        return new byte[]{(byte)i2};
    }

    public static byte[] fromUB2(int i2) {
        return new byte[]{(byte)i2, (byte)(i2 >> 8)};
    }

    public static byte[] fromUB3(int i2) {
        return new byte[]{(byte)i2, (byte)(i2 >> 8), (byte)(i2 >> 16)};
    }

    public static byte[] fromUB4(long l2) {
        return new byte[]{(byte)l2, (byte)(l2 >> 8), (byte)(l2 >> 16), (byte)(l2 >> 24)};
    }

    public static byte[] fromString(String str, Charset encoding) {
        if (str == null) {
            str = "";
        }
        byte[] strBytes = null;
        strBytes = str.getBytes(encoding);
        return strBytes;
    }

    public static byte toByte(byte[] bytes) {
        return ByteUtil.getByte(bytes, 0);
    }

    public static short toShort(byte[] bytes) {
        return ByteUtil.getShort(bytes, 0);
    }

    public static int toInt(byte[] bytes) {
        return ByteUtil.getInt(bytes, 0);
    }

    public static long toLong(byte[] bytes) {
        return ByteUtil.getLong(bytes, 0);
    }

    public static float toFloat(byte[] bytes) {
        return ByteUtil.getFloat(bytes, 0);
    }

    public static double toDouble(byte[] bytes) {
        return ByteUtil.getDouble(bytes, 0);
    }

    public static int toUB1(byte[] bytes) {
        return ByteUtil.getUB1(bytes, 0);
    }

    public static int toUB2(byte[] bytes) {
        return ByteUtil.getUB2(bytes, 0);
    }

    public static int toUB3(byte[] bytes) {
        return ByteUtil.getUB3(bytes, 0);
    }

    public static long toUB4(byte[] bytes) {
        return ByteUtil.getUB4(bytes, 0);
    }

    public static String toString(byte[] bytes, Charset encoding) {
        return new String(bytes, encoding);
    }

    public static int indexOf(byte[] bytes, byte[] subBytes) {
        int index = -1;
        int distance = bytes.length - subBytes.length;
        if (distance < 0) {
            return index;
        }
        int i2 = 0;
        while (i2 <= distance) {
            int j2 = 0;
            while (j2 < subBytes.length) {
                int i1 = subBytes[j2] & 0xFF;
                int j1 = bytes[i2 + j2] & 0xFF;
                if (i1 != j1) break;
                ++j2;
            }
            if (j2 == subBytes.length) {
                index = i2;
                break;
            }
            ++i2;
        }
        return index;
    }

    public static void main(String[] args) {
        byte[] bytes = new byte[8];
        ByteUtil.setLong(bytes, 0, -128L);
        System.out.println(ByteUtil.getLong(bytes, 0));
        ByteUtil.setUB4(bytes, 0, 0xFFFFFFFFL);
        System.out.println(ByteUtil.getUB4(bytes, 0));
    }
}

