/*
 * Decompiled with CFR 0.152.
 */
package dm.jdbc.driver;

import dm.jdbc.driver.Resource;
import dm.jdbc.filter.custom.ICustom;
import dm.jdbc.internal.conf.DmProperties;
import dm.jdbc.internal.conf.EP;
import dm.jdbc.internal.conf.EPGroup;
import dm.jdbc.internal.desc.BooleanExpression;
import dm.jdbc.internal.desc.Const;
import dm.jdbc.util.ConvertUtil;
import dm.jdbc.util.DriverUtil;
import dm.jdbc.util.ReflectUtil;
import dm.jdbc.util.StringUtil;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public class Configuration<T> {
    public static final int COLUMN_NAME_CASE_DEFAULT = 0;
    public static final int COLUMN_NAME_CASE_UPPDER = 1;
    public static final int COLUMN_NAME_CASE_LOWER = 2;
    public static final int COMPATIBLE_MODE_OFF = 0;
    public static final int COMPATIBLE_MODE_ORACLE = 1;
    public static final int COMPATIBLE_MODE_ORACLE19 = 4865;
    public static final int COMPATIBLE_MODE_MYSQL = 2;
    public static final int OSAUTH_OFF = 0;
    public static final int OSAUTH_DBA = 1;
    public static final int OSAUTH_SSO = 2;
    public static final int OSAUTH_AUDITOR = 3;
    public static final int OSAUTH_AUTOMATCH = 4;
    public static int STAT_SQL_REMOVE_LATEST = 0;
    public static int STAT_SQL_REMOVE_OLDEST = 1;
    public static int STAT_FILE_TYPE_CSV = 1;
    public static int STAT_FILE_TYPE_TXT = 0;
    public static final int LOG_OFF = 0;
    public static final int LOG_ASSERT = 1;
    public static final int LOG_ERROR = 2;
    public static final int LOG_WARN = 3;
    public static final int LOG_SQL = 4;
    public static final int LOG_INFO = 5;
    public static final int LOG_DEBUG = 6;
    public static final int LOG_ALL = 9;
    public static final int BATCH_OFF = 2;
    public static final int BATCH = 1;
    public static final int PARAM_BIND_MODE_USER = 0;
    public static final int PARAM_BIND_MODE_SERVER = 1;
    public static final int LOB_MODE_CACHE_ALL = 2;
    public static final int LOB_MODE_NO_CACHE = 1;
    public static final int MIN_BUF_PREFETCH = 32;
    public static final int MAX_BUF_PREFETCH = 65536;
    public static final int MPP_FLDR_OFF = 0;
    public static final int MPP_FLDR_INSERT = 1;
    public static final int MPP_FLDR_SELECT = 2;
    public static final int RW_SEPARATE_OFF = 0;
    public static final int RW_SEPARATE_CLIENT = 1;
    public static final int RW_SEPARATE_EP_GROUP = 2;
    public static final int RW_SEPARATE_DB = 3;
    public static final int RW_SEPARATE_DB_APPLY_WAIT = 4;
    public static final int GEN_KEY_CASE_NONE = 0;
    public static final int GEN_KEY_CASE_UPPER = 1;
    public static final int GEN_KEY_CASE_LOWER = 2;
    public static final int GEN_KEY_CASE_DEFAULT = 1;
    public static final int QUOTE_REPLACE_NONE = 0;
    public static final int QUOTE_REPLACE_DOUBLE_TO_SINGLE = 1;
    public static final String ERR_MAP = "ERR_MAP";
    public static final Map<String, Configuration> map = new HashMap<String, Configuration>();
    private static final Map<String, Configuration> aliasMap = new HashMap<String, Configuration>();
    public static final Configuration<String> addressRemap = new Configuration<Object>("addressRemap", new String[]{"ADDRESS_REMAP"}, "", null, null, false, "description.addressRemap");
    public static final Configuration<String> userRemap = new Configuration<Object>("userRemap", new String[]{"USER_REMAP"}, "", null, null, false, "description.userRemap");
    public static final Configuration<String> dmSvcConf = new Configuration<Object>("dmSvcConf", null, "", null, null, false, "description.dmSvcConf");
    public static final Configuration<String> url = new Configuration<Object>("url", null, "", null, null, true, "description.url");
    public static final Configuration<String> host = new Configuration<Object>("host", null, "localhost", null, null, true, "description.host");
    public static final Configuration<Integer> port = new Configuration<Integer>("port", null, 5236, 0, Integer.MAX_VALUE, true, "description.port");
    public static final Configuration<String> user = new Configuration<Object>("user", null, null, null, null, true, "description.user");
    public static final Configuration<String> password = new Configuration<Object>("password", null, "", null, null, true, "description.password");
    public static final Configuration<Boolean> LocalEncrypt = new Configuration<Object>("LocalEncrypt", new String[]{"LOCAL_ENCRYPT"}, false, null, null, true, "description.localEncrypt");
    public static final Configuration<String> localEncryptEngine = new Configuration<Object>("localEncryptEngine", new String[]{"LOCAL_ENCRYPT_ENGINE"}, null, null, null, true, "description.localEncryptEngine");
    public static final Configuration<Integer> language = new Configuration<Integer>("language", new String[]{"LANGUAGE"}, Const.j2dbLanguage(Locale.getDefault()), 0, 3, false, "description.language");
    public static final Configuration<String> appName = new Configuration<Object>("appName", new String[]{"APP_NAME"}, "", null, null, false, "description.appName");
    public static final Configuration<String> osName = new Configuration<Object>("osName", new String[]{"OS_NAME"}, System.getProperty("os.name", ""), null, null, false, "description.osName");
    public static final Configuration<Integer> connectTimeout = new Configuration<Integer>("connectTimeout", new String[]{"CONNECT_TIMEOUT"}, 5000, 0, Integer.MAX_VALUE, false, "description.connectTimeout");
    public static final Configuration<Integer> sessionTimeout = new Configuration<Integer>("sessionTimeout", new String[]{"SESSION_TIMEOUT"}, 0, 0, Integer.MAX_VALUE, false, "description.sessionTimeout");
    public static final Configuration<Integer> socketTimeout = new Configuration<Integer>("socketTimeout", new String[]{"SOCKET_TIMEOUT"}, 0, 0, Integer.MAX_VALUE, false, "description.socketTimeout");
    public static final Configuration<Boolean> keepAlive = new Configuration<Object>("keepAlive", new String[]{"KEEP_ALIVE"}, true, null, null, false, "description.keepAlive");
    public static final Configuration<Boolean> autoCommit = new Configuration<Object>("autoCommit", new String[]{"AUTO_COMMIT"}, true, null, null, false, "description.autoCommit");
    public static final Configuration<Boolean> alwaysAllowCommit = new Configuration<Object>("alwaysAllowCommit", new String[]{"ALWAYSE_ALLOW_COMMIT", "ALWAYS_ALLOW_COMMIT", "alwayseAllowCommit"}, true, null, null, false, "description.alwayseAllowCommit");
    public static final Configuration<Integer> localTimezone = new Configuration<Integer>("localTimezone", new String[]{"TIMEZONE", "TIME_ZONE", "LOCAL_TIME_ZONE"}, Integer.valueOf(Const.TIME_ZONE_DEFAULT), -779, 840, false, "description.localTimezone");
    public static final Configuration<String[]> keyWords = new Configuration<Object>("keyWords", new String[]{"PRIMARY_KEY", "KEY_WORDS"}, null, null, null, false, "description.keyWords");
    public static final Configuration<Integer> quoteReplace = new Configuration<Integer>("quoteReplace", new String[]{"QUOTE_REPLACE"}, 0, 0, 1, false, "description.quoteReplace");
    public static final Configuration<Integer> compatibleMode = new Configuration<Integer>("compatibleMode", new String[]{"COMPATIBLE_MODE"}, 0, new Integer[]{2, 1}, false, "description.compatibleMode");
    public static final Configuration<Integer> paramBindMode = new Configuration<Integer>("paramBindMode", new String[]{"PARAM_BIND_MODE"}, 0, new Integer[]{0, 1}, false, "description.paramBindMode");
    public static final Configuration<Integer> batchType = new Configuration<Integer>("batchType", new String[]{"BATCH_TYPE"}, 1, new Integer[]{2, 1}, false, "description.batchType");
    public static final Configuration<Boolean> batchContinueOnError = new Configuration<Object>("batchContinueOnError", new String[]{"continueBatchOnError", "BATCH_CONTINUE_ON_ERROR", "CONTINUE_BATCH_ON_ERROR"}, false, null, null, false, "description.continueBatchOnError");
    public static final Configuration<Boolean> batchNotOnCall = new Configuration<Object>("batchNotOnCall", new String[]{"callBatchNot", "CALL_BATCH_NOT", "BATCH_NOT_ON_CALL"}, false, null, null, false, "description.callBatchNot");
    public static final Configuration<Integer> batchAllowMaxErrors = new Configuration<Integer>("batchAllowMaxErrors", new String[]{"BATCH_ALLOW_MAX_ERRORS"}, 0, 0, Integer.MAX_VALUE, false, "description.batchAllowMaxErrors");
    public static final Configuration<Integer> bufPrefetch = new Configuration<Integer>("bufPrefetch", new String[]{"BUF_PREFETCH"}, 0, 32, 65536, false, "description.bufPrefetch");
    public static final Configuration<Boolean> clobAsString = new Configuration<Object>("clobAsString", new String[]{"CLOB_AS_STRING"}, false, null, null, false, "description.clobAsString");
    public static final Configuration<String> columnNameCase = new Configuration<Object>("columnNameCase", new String[]{"COLUMN_NAME_CASE", "columnNameUpperCase", "COLUMN_NAME_UPPER_CASE"}, "", null, null, false, "description.columnNameCase");
    public static final Configuration<String> databaseProductName = new Configuration<Object>("databaseProductName", new String[]{"DATABASE_PRODUCT_NAME"}, "", null, null, false, "description.databaseProductName");
    public static final Configuration<Boolean> dbmdChkPrv = new Configuration<Object>("dbmdChkPrv", new String[]{"DBMD_CHK_PRV"}, true, null, null, false, "description.dbmdChkPrv");
    public static final Configuration<Boolean> escapeProcess = new Configuration<Object>("escapeProcess", new String[]{"ESCAPE_PROCESS"}, true, null, null, false, "description.escapeProcess");
    public static final Configuration<Boolean> ignoreCase = new Configuration<Object>("ignoreCase", new String[]{"IGNORE_CASE"}, true, null, null, false, "description.ignoreCase");
    public static final Configuration<String> genKeyNameCase = new Configuration<Object>("genKeyNameCase", new String[]{"GEN_KEY_NAME_CASE"}, "", null, null, false, "description.genKeyNameCase");
    public static final Configuration<Boolean> isBdtaRS = new Configuration<Object>("isBdtaRS", new String[]{"IS_BDTA_RS"}, false, null, null, false, "description.isBdtaRS");
    public static final Configuration<Integer> lobMode = new Configuration<Integer>("lobMode", new String[]{"LOB_MODE"}, 1, new Integer[]{1, 2}, false, "description.lobMode");
    public static final Configuration<Integer> maxRows = new Configuration<Integer>("maxRows", new String[]{"MAX_ROWS"}, 0, 0, Integer.MAX_VALUE, false, "description.maxRows");
    public static final Configuration<Boolean> prepareOptimize = new Configuration<Object>("prepareOptimize", new String[]{"PREPARE_OPTIMIZE"}, false, null, null, false, "description.prepareOptimize");
    public static final Configuration<Integer> pstmtPoolSize = new Configuration<Integer>("pstmtPoolSize", new String[]{"PSTMT_POOL_SIZE"}, 0, 0, Integer.MAX_VALUE, false, "description.pstmtPoolSize");
    public static final Configuration<Integer> pstmtPoolValidTime = new Configuration<Integer>("pstmtPoolValidTime", new String[]{"PSTMT_POOL_VALID_TIME"}, 0, 0, Integer.MAX_VALUE, false, "description.pstmtPoolValidTime");
    public static final Configuration<Integer> resultSetType = new Configuration<Integer>("resultSetType", new String[]{"RESULT_SET_TYPE"}, 1003, new Integer[]{1003, 1004, 1005}, false, "description.resultSetType");
    public static final Configuration<Integer> stmtPoolSize = new Configuration<Integer>("stmtPoolSize", new String[]{"STMT_POOL_SIZE"}, 15, 0, Integer.MAX_VALUE, false, "description.stmtPoolSize");
    public static final Configuration<String> sessEncode = new Configuration<Object>("sessEncode", new String[]{"SESS_ENCODE"}, "", null, null, false, "description.sessEncode");
    public static final Configuration<Boolean> enRsCache = new Configuration<Object>("enRsCache", new String[]{"ENABLE_RS_CACHE", "EN_RS_CACHE"}, false, null, null, false, "description.enRsCache");
    public static final Configuration<Integer> rsCacheSize = new Configuration<Integer>("rsCacheSize", new String[]{"RS_CACHE_SIZE"}, 20, 0, Integer.MAX_VALUE, false, "description.rsCacheSize");
    public static final Configuration<Integer> rsRefreshFreq = new Configuration<Integer>("rsRefreshFreq", new String[]{"RS_REFRESH_FREQ"}, 10, 0, Integer.MAX_VALUE, false, "description.rsRefreshFreq");
    public static final Configuration<Integer> reconnect = new Configuration<Integer>("reconnect", new String[]{"DO_SWITCH", "AUTO_RECONNECT", "doSwitch", "autoReconnect"}, 0, null, false, "description.doSwitch");
    public static final Configuration<Integer> switchTimes = new Configuration<Integer>("switchTimes", new String[]{"SWITCH_TIME", "SWITCH_TIMES"}, 1, 1, Integer.MAX_VALUE, false, "description.switchTimes");
    public static final Configuration<Integer> switchInterval = new Configuration<Integer>("switchInterval", new String[]{"SWITCH_INTERVAL"}, 1000, 0, Integer.MAX_VALUE, false, "description.switchInterval");
    public static final Configuration<Integer> checkFreq = new Configuration<Integer>("checkFreq", new String[]{"CHECK_FREQ"}, 300000, 0, Integer.MAX_VALUE, false, "description.epStatusCheckFreq");
    public static final Configuration<Integer> allowRange = new Configuration<Integer>("allowRange", new String[]{"ALLOW_RANGE"}, 5, 0, 50, false, "description.allowRange");
    public static final Configuration<Integer> loginMode = new Configuration<Integer>("loginMode", new String[]{"LOGIN_PRIMARY", "LOGIN_MODE"}, 4, new Integer[]{0, 1, 2, 3, 4}, false, "description.loginMode");
    public static final Configuration<Integer> loginStatus = new Configuration<Integer>("loginStatus", new String[]{"LOGIN_STATUS"}, 0, new Integer[]{0, 5, 3, 4}, false, "description.loginStatus");
    public static final Configuration<Boolean> loginDscCtrl = new Configuration<Object>("loginDscCtrl", new String[]{"LOGIN_DSC_CTRL"}, false, null, null, false, "description.loginDscCtrl");
    public static final Configuration<Integer> epSelector = new Configuration<Integer>("epSelector", new String[]{"epSelection", "EP_SELECTION", "EP_SELECTOR"}, 0, new Integer[]{0, 1}, false, "description.epSelector");
    public static final Configuration<Integer> cluster = new Configuration<Integer>("cluster", null, 0, new Integer[]{0, 4, 3, 2, 1}, false, "description.cluster");
    public static final Configuration<Boolean> mppLocal = new Configuration<Object>("mppLocal", new String[]{"MPP_LOCAL"}, false, null, null, false, "description.mppLocal");
    public static final Configuration<Integer> mppOpt = new Configuration<Integer>("mppOpt", new String[]{"MPP_OPT"}, 0, new Integer[]{0, 1, 2, 0}, false, "description.mppOpt");
    public static final Configuration<Integer> rwSeparate = new Configuration<Integer>("rwSeparate", new String[]{"RW_SEPARATE"}, 0, new Integer[]{0, 3, 1, 2, 4}, false, "description.rwSeparate");
    public static final Configuration<Integer> rwPercent = new Configuration<Integer>("rwPercent", new String[]{"RW_PERCENT"}, 25, 0, 100, false, "description.rwPercent");
    public static final Configuration<Boolean> rwAutoDistribute = new Configuration<Object>("rwAutoDistribute", new String[]{"RW_AUTO_DISTRIBUTE"}, true, null, null, false, "description.rwAutoDistribute");
    public static final Configuration<Boolean> rwHA = new Configuration<Object>("rwHA", new String[]{"RW_HA"}, false, null, null, false, "description.rwHA");
    public static final Configuration<Integer> rwStandbyRecoverTime = new Configuration<Integer>("rwStandbyRecoverTime", new String[]{"RW_STANDBY_RECOVER_TIME"}, 60000, 0, Integer.MAX_VALUE, false, "description.rwStandbyRecoverTime");
    public static final Configuration<Integer> dbAliveCheckFreq = new Configuration<Integer>("dbAliveCheckFreq", new String[]{"DB_ALIVE_CHECK_FREQ"}, 0, 0, Integer.MAX_VALUE, false, "description.dbAliveCheckFreq");
    public static final Configuration<Integer> dbAliveCheckTimeout = new Configuration<Integer>("dbAliveCheckTimeout", new String[]{"DB_ALIVE_CHECK_TIMEOUT"}, 10000, 0, Integer.MAX_VALUE, false, "description.dbAliveCheckTimeout");
    public static final Configuration<Integer> logLevel = new Configuration<Integer>("logLevel", new String[]{"LOG_LEVEL"}, 0, new Integer[]{0, 1, 9, 6, 2, 5, 4, 3}, false, "description.logLevel");
    public static final Configuration<String> logDir = new Configuration<Object>("logDir", new String[]{"LOG_DIR"}, DriverUtil.formatDir(System.getProperty("user.dir")), null, null, false, "description.logDir");
    public static final Configuration<Integer> logFlushFreq = new Configuration<Integer>("logFlushFreq", new String[]{"LOG_FLUSH_FREQ"}, 30, 0, Integer.MAX_VALUE, false, "description.logFlushFreq");
    public static final Configuration<Boolean> statEnable = new Configuration<Object>("statEnable", new String[]{"STAT_ENABLE"}, false, null, null, false, "description.statEnable");
    public static final Configuration<String> statDir = new Configuration<Object>("statDir", new String[]{"STAT_DIR"}, DriverUtil.formatDir(System.getProperty("user.statDir")), null, null, false, "description.addressRemap");
    public static final Configuration<Integer> statFileType = new Configuration<Integer>("statFileType", new String[]{"STAT_FILE_TYPE"}, STAT_FILE_TYPE_CSV, new Integer[]{STAT_FILE_TYPE_CSV, STAT_FILE_TYPE_TXT}, false, "description.statFileType");
    public static final Configuration<Integer> statFlushFreq = new Configuration<Integer>("statFlushFreq", new String[]{"STAT_FLUSH_FREQ"}, 30, 0, Integer.MAX_VALUE, false, "description.statFlushFreq");
    public static final Configuration<Integer> statHighFreqSqlCount = new Configuration<Integer>("statHighFreqSqlCount", new String[]{"STAT_HIGH_FREQ_SQL_COUNT"}, 100, 0, 1000, false, "description.statHighFreqSqlCount");
    public static final Configuration<Integer> statSlowSqlCount = new Configuration<Integer>("statSlowSqlCount", new String[]{"STAT_SLOW_SQL_COUNT"}, 100, 0, 1000, false, "description.statSlowSqlCount");
    public static final Configuration<Integer> statSqlMaxCount = new Configuration<Integer>("statSqlMaxCount", new String[]{"STAT_MAX_SQL_COUNT"}, 1000, 0, 100000, false, "description.statSqlMaxCount");
    public static final Configuration<Integer> statSqlRemoveMode = new Configuration<Integer>("statSqlRemoveMode", new String[]{"STAT_SQL_REMOVE_LATEST"}, STAT_SQL_REMOVE_LATEST, new Integer[]{STAT_SQL_REMOVE_LATEST, STAT_SQL_REMOVE_OLDEST}, false, "description.statSqlRemoveMode");
    public static final Configuration<String> shakeCrypto = new Configuration<Object>("shakeCrypto", new String[]{"SHAKE_CRYPTO"}, "", null, null, false, "description.shakeCrypto");
    public static final Configuration<String> userNewPwd = new Configuration<Object>("userNewPwd", new String[]{"USER_NEW_PWD"}, "", null, null, false, "description.userNewPwd");
    public static final Configuration<String> cipherPath = new Configuration<Object>("cipherPath", new String[]{"CIPHER_PATH"}, System.getProperty("JDBC_CIPHER_PATH", ""), null, null, false, "description.cipherPath");
    public static final Configuration<String> kerberosLoginConfPath = new Configuration<Object>("kerberosLoginConfPath", new String[]{"KERBEROS_LOGIN_CONF_PATH"}, "", null, null, false, "description.kerberosLoginConfPath");
    public static final Configuration<String> loginCertificate = new Configuration<Object>("loginCertificate", new String[]{"LOGIN_CERTIFICATE"}, "", null, null, false, "description.loginCertificate");
    public static final Configuration<Integer> osAuthType = new Configuration<Integer>("osAuthType", new String[]{"OS_AUTH_TYPE"}, 0, new Integer[]{3, 4, 1, 0, 2}, false, "description.osAuthType");
    public static final Configuration<String> sslFilesPath = new Configuration<Object>("sslFilesPath", new String[]{"SSL_FILES_PATH"}, "", null, null, false, "description.sslFilesPath");
    public static final Configuration<String> sslKeystorePass = new Configuration<Object>("sslKeystorePass", new String[]{"SSL_KEYSTORE_PASS"}, "", null, null, false, "description.sslKeystorePass");
    public static final Configuration<String> sslProtocol = new Configuration<Object>("sslProtocol", new String[]{"SSL_PROTOCOL"}, null, null, false, "description.sslProtocol");
    public static final Configuration<String> uKeyName = new Configuration<Object>("uKeyName", new String[]{"UKEY_NAME"}, "", null, null, false, "description.uKeyName");
    public static final Configuration<String> uKeyPin = new Configuration<Object>("uKeyPin", new String[]{"UKEY_PIN"}, "", null, null, false, "description.uKeyPin");
    public static final Configuration<Integer> compress = new Configuration<Integer>("compress", new String[]{"COMPRESS_MSG"}, 0, new Integer[]{0, 2, 1}, false, "description.compress");
    public static final Configuration<Integer> compressID = new Configuration<Integer>("compressID", new String[]{"COMPRESS_ID"}, 0, new Integer[]{0, 1}, false, "description.compressID");
    public static final Configuration<String> schema = new Configuration<Object>("schema", new String[]{"SCHEMA"}, null, null, null, false, "description.schema");
    public static final Configuration<String> markConf = new Configuration<Object>("markConf", new String[]{"MARK_CONF"}, null, null, null, false, "description.markConf");
    public static final Configuration<String> unixSocketFile = new Configuration<Object>("unixSocketFile", new String[]{"UNIX_SOCKET_FILE"}, null, null, null, false, "description.unixSocketFile");
    public static final Configuration<Boolean> gmsslEnable = new Configuration<Object>("gmsslEnable", new String[]{"GMSSL_ENABLE"}, false, null, null, false, "description.gmsslEnable");
    public static final Configuration<String> gwdsn = new Configuration<Object>("GWDSN", null, "", null, null, false, "description.gwdsn");
    public static final Configuration<String> customFilter = new Configuration<Object>("customFilter", new String[]{"CUSTOM_FILTER"}, ReflectUtil.loadServices(ICustom.class), null, null, false, "description.custom_filter");
    public static final Configuration<String> proxyClient = new Configuration<Object>("PROXY_CLIENT", new String[]{"proxyClient"}, "", null, null, false, "description.proxyClient");
    public static final Configuration<Integer> afterGetMoreResults = new Configuration<Integer>("afterGetMoreResults", new String[]{"AFTER_GET_MORE_RESULTS"}, 1, 1, 3, false, "description.afterGetMoreResults");
    public static final Configuration<Boolean> checkExecType = new Configuration<Object>("checkExecType", new String[]{"CHECK_EXEC_TYPE"}, false, null, null, false, "description.checkExecType");
    public static final Configuration<String> ignoreWarnings = new Configuration<Object>("ignoreWarnings", new String[]{"IGNORE_WARNINGS"}, "", null, null, false, "description.ignoreWarnings");
    public static final Configuration<Boolean> highConcurrency = new Configuration<Object>("highConcurrency", new String[]{"HIGH_CONCURRENCY"}, false, null, null, false, "description.highConcurrency");
    public static final Configuration<Boolean> isCompress = new Configuration<Object>("isCompress", new String[]{"IS_COMPRESS"}, false, null, null, false, "description.isCompress");
    public static final Configuration<Boolean> comOra = new Configuration<Object>("comOra", new String[]{"COM_ORA"}, false, null, null, false, "description.comOra");
    public static final Configuration<Integer> xaRestoreAutoCommit = new Configuration<Integer>("xaRestoreAutoCommit", new String[]{"XA_RESTORE_AUTO_COMMIT"}, 0, 0, 1, false, "description.xaRestoreAutoCommitType");
    public static final Configuration<Boolean> loginEncrypt = new Configuration<Object>("loginEncrypt", new String[]{"LOGIN_ENCRYPT", "COMMUNICATION_ENCRYPT"}, true, null, null, false, "description.loginEncrypt");
    public static final Configuration<Integer> bufferType = new Configuration<Integer>("bufferType", new String[]{"BUFFER_TYPE"}, 0, new Integer[]{0, 2, 1}, false, "description.bufferType");
    public static final Configuration<Integer> logBufferSize = new Configuration<Integer>("logBufferSize", new String[]{"LOG_BUFFER_SIZE"}, 32768, 0, Integer.MAX_VALUE, false, "description.logBufferSize");
    public static final Configuration<EPGroup> epGroup = new Configuration<Object>("epGroup", null, null, null, false, "description.epGroup");
    public static final Configuration<Boolean> rwStandby = new Configuration<Object>("rwStandby", null, false, null, null, false, "description.rwStandby");
    public static final Configuration<Boolean> fetchSizeEnabled = new Configuration<Object>("fetchSizeEnabled", new String[]{"FETCH_SIZE_ENABLED"}, true, null, null, false, "description.fetchSizeEnabled");
    public static final Configuration<Boolean> rwIgnoreSql = new Configuration<Object>("rwIgnoreSql", new String[]{"RW_IGNORE_SQL"}, false, null, null, false, "description.rwIgnoreSql");
    public static final Configuration<Integer> lobOffRowLen = new Configuration<Integer>("lobOffRowLen", new String[]{"LOB_OFF_ROW_LEN"}, 16384, 0, Integer.MAX_VALUE, false, "");
    public static final Configuration<Integer> lobReadWriteLen = new Configuration<Integer>("lobReadWriteLen", new String[]{"LOB_READ_WRITE_LEN"}, 32000, 0, Integer.MAX_VALUE, false, "");
    public static final Configuration<String> serverOption = new Configuration<Object>("serverOption", new String[]{"SERVER_OPTION"}, "", null, null, false, "");
    public static final Configuration<Boolean> numTruncSwitch = new Configuration<Boolean>("numTruncSwitch", new String[]{"NUM_TRUNC_SWITCH"}, false, false, true, false, "");
    public static final Configuration<String> errMap = new Configuration<Object>("errMap", new String[]{"ERR_MAP"}, "", null, null, false, "");
    private String name;
    private boolean required;
    private T defaultValue;
    private T minValue;
    private T maxValue;
    private T[] validValues;
    private String description;

    public Configuration(String name, String[] alias, T defaultValue, T minValue, T maxValue, boolean required, String desc) {
        this.name = name;
        this.defaultValue = defaultValue;
        this.maxValue = maxValue;
        this.minValue = minValue;
        this.required = required;
        this.description = desc;
        map.put(name.toLowerCase(), this);
        if (alias != null) {
            String[] stringArray = alias;
            int n2 = alias.length;
            int n3 = 0;
            while (n3 < n2) {
                String alia = stringArray[n3];
                aliasMap.put(alia.toLowerCase(), this);
                ++n3;
            }
        }
    }

    public Configuration(String name, String[] alias, T defaultValue, T[] validValues, boolean required, String desc) {
        this(name, alias, defaultValue, null, null, required, desc);
        this.validValues = validValues;
    }

    public static Configuration valueOf(String name) {
        Configuration prop = map.get(name = name.toLowerCase());
        if (prop != null) {
            return prop;
        }
        return aliasMap.get(name);
    }

    public static Collection<Configuration> values() {
        return map.values();
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return Resource.get(this.description);
    }

    public boolean isRequired() {
        return this.required;
    }

    public T getDefault() {
        return this.defaultValue;
    }

    public T getMax() {
        return this.maxValue;
    }

    public T getMin() {
        return this.minValue;
    }

    public T[] getValidValues() {
        return this.validValues;
    }

    public static int parseCluster(DmProperties props) {
        String value = props.getProperty(cluster.getName());
        if (StringUtil.isNotEmpty(value) && !StringUtil.isDigit(value)) {
            if (StringUtil.equalsIgnoreCase(value, "dsc")) {
                return 3;
            }
            if (StringUtil.equalsIgnoreCase(value, "rw")) {
                return 1;
            }
            if (StringUtil.equalsIgnoreCase(value, "dw")) {
                return 2;
            }
            if (StringUtil.equalsIgnoreCase(value, "mpp")) {
                return 4;
            }
            if (StringUtil.equalsIgnoreCase(value, "dpc")) {
                return 5;
            }
            if (StringUtil.equalsIgnoreCase(value, "normal")) {
                return 0;
            }
            return cluster.getDefault();
        }
        return (byte)props.getInt(cluster);
    }

    public static int parseCompatibleMode(DmProperties props) {
        String value = props.getProperty(compatibleMode.getName());
        if (StringUtil.isNotEmpty(value) && !StringUtil.isDigit(value)) {
            if (value.startsWith("oracle19")) {
                return 4865;
            }
            if (value.startsWith("oracle")) {
                return 1;
            }
            if (value.startsWith("mysql")) {
                return 2;
            }
            return compatibleMode.getDefault();
        }
        value = props.getProperty(comOra.getName());
        if (StringUtil.isNotEmpty(value)) {
            return props.getBoolean(comOra) ? 1 : 0;
        }
        return props.getInt(compatibleMode);
    }

    public static int parseColumnNameCase(String str) {
        if (StringUtil.isEmpty(str)) {
            return 0;
        }
        if (StringUtil.equalsIgnoreCase("upper", str) || StringUtil.equals(String.valueOf(1), str)) {
            return 1;
        }
        if (StringUtil.equalsIgnoreCase("lower", str) || StringUtil.equals(String.valueOf(2), str)) {
            return 2;
        }
        boolean ret = ConvertUtil.toBoolean(str);
        return ret ? 1 : 0;
    }

    public static int parseGenKeyCase(String str) {
        if (StringUtil.isEmpty(str)) {
            return 1;
        }
        if (StringUtil.equalsIgnoreCase("upper", str) || StringUtil.equals(String.valueOf(1), str)) {
            return 1;
        }
        if (StringUtil.equalsIgnoreCase("lower", str) || StringUtil.equals(String.valueOf(2), str)) {
            return 2;
        }
        if (StringUtil.equalsIgnoreCase("none", str) || StringUtil.equals(String.valueOf(0), str)) {
            return 0;
        }
        return 1;
    }

    public static byte parseOsAuthType(DmProperties props) throws SQLException {
        String value = props.getProperty(osAuthType.getName());
        if (StringUtil.isNotEmpty(value) && !StringUtil.isDigit(value)) {
            if (StringUtil.equalsIgnoreCase(value, "SYSDBA")) {
                return 1;
            }
            if (StringUtil.equalsIgnoreCase(value, "SYSAUDITOR")) {
                return 3;
            }
            if (StringUtil.equalsIgnoreCase(value, "SYSSSO")) {
                return 2;
            }
            if (StringUtil.equalsIgnoreCase(value, "AUTO")) {
                return 4;
            }
            if (StringUtil.equalsIgnoreCase(value, "OFF")) {
                return 0;
            }
            return osAuthType.getDefault().byteValue();
        }
        return (byte)props.getInt(osAuthType);
    }

    public static int parseLogLevel(DmProperties props) {
        int logLevel = Configuration.logLevel.getDefault();
        String value = props.getProperty(Configuration.logLevel.getName());
        if (StringUtil.isNotEmpty(value) && !StringUtil.isDigit(value)) {
            if ("DEBUG".equalsIgnoreCase(value)) {
                logLevel = 6;
            } else if ("INFO".equalsIgnoreCase(value)) {
                logLevel = 5;
            } else if ("SQL".equalsIgnoreCase(value)) {
                logLevel = 4;
            } else if ("warn".equalsIgnoreCase(value)) {
                logLevel = 3;
            } else if ("error".equalsIgnoreCase(value)) {
                logLevel = 2;
            } else if ("off".equalsIgnoreCase(value)) {
                logLevel = 0;
            } else if ("all".equalsIgnoreCase(value)) {
                logLevel = 9;
            }
        } else {
            logLevel = props.getInt(Configuration.logLevel);
        }
        return logLevel;
    }

    public static int parseStatSqlRemoveMode(DmProperties props) {
        String value = props.getProperty(statSqlRemoveMode.getName());
        if (StringUtil.isNotEmpty(value) && !StringUtil.isDigit(value)) {
            if ("oldest".equalsIgnoreCase(value) || "eldest".equalsIgnoreCase(value)) {
                return STAT_SQL_REMOVE_OLDEST;
            }
            if ("latest".equalsIgnoreCase(value)) {
                return STAT_SQL_REMOVE_LATEST;
            }
            return statSqlRemoveMode.getDefault();
        }
        return props.getInt(statSqlRemoveMode);
    }

    public static Locale parseLanguage(DmProperties props) {
        String value = props.getProperty(language.getName());
        if ("cn".equalsIgnoreCase(value)) {
            return Locale.CHINA;
        }
        if ("tw".equalsIgnoreCase(value)) {
            return Locale.TAIWAN;
        }
        if ("hk".equalsIgnoreCase(value) || "CNT_HK".equalsIgnoreCase(value)) {
            return new Locale("zh", "HK");
        }
        if ("en".equalsIgnoreCase(value)) {
            return Locale.US;
        }
        return Locale.getDefault();
    }

    public static EPGroup parseEpGroup(String name, String value) {
        String[] values = value.split(",");
        ArrayList<EP> svrList = new ArrayList<EP>();
        int i2 = 0;
        while (i2 < values.length) {
            int tmpPort;
            String tmpName;
            EP tmp = null;
            int begin = values[i2].indexOf("[");
            int end = -1;
            if (begin != -1) {
                end = values[i2].indexOf("]", begin);
            }
            if (end != -1) {
                tmpName = values[i2].substring(begin + 1, end);
                int portIndex = values[i2].indexOf(":", end);
                tmpPort = portIndex != -1 ? Integer.parseInt(values[i2].substring(portIndex + 1).trim()) : 5236;
                tmp = new EP(tmpName, tmpPort);
                tmp.epSeqno = svrList.size();
                svrList.add(tmp);
            } else {
                String[] tmpVals = values[i2].split(":");
                tmpName = tmpVals[0].trim();
                tmpPort = tmpVals.length >= 2 ? Integer.parseInt(tmpVals[1]) : 5236;
                tmp = new EP(tmpName, tmpPort);
                tmp.epSeqno = svrList.size();
                svrList.add(tmp);
            }
            ++i2;
        }
        return svrList.size() > 0 ? new EPGroup(name, svrList) : null;
    }

    public static void parseHostPort(String protocol, DmProperties urlProps) throws SQLException {
        String host;
        int catalogIndex = protocol.lastIndexOf("/");
        if (catalogIndex != -1) {
            String catalog = StringUtil.trimToEmpty(protocol.substring(catalogIndex + 1));
            urlProps.setProperty(Configuration.schema.name, catalog);
            protocol = StringUtil.trimToEmpty(protocol.substring(0, catalogIndex));
        }
        int ipv6EndIndex = protocol.indexOf("]");
        int portIndex = protocol.lastIndexOf(":");
        if (ipv6EndIndex != -1 && portIndex < ipv6EndIndex) {
            portIndex = -1;
        }
        String port = portIndex != -1 ? StringUtil.trimToEmpty(protocol.substring(portIndex + 1)) : null;
        String string = host = portIndex != -1 ? StringUtil.trimToEmpty(protocol.substring(0, portIndex)) : StringUtil.trimToEmpty(protocol);
        if (StringUtil.isNotEmpty(host)) {
            urlProps.setProperty(Configuration.host.getName(), host);
        }
        if (StringUtil.isNotEmpty(port)) {
            urlProps.setProperty(Configuration.port.getName(), port);
        }
    }

    public static int parseStatFileType(DmProperties props) {
        String value = props.getProperty(statFileType.getName());
        if (StringUtil.isNotEmpty(value) && !StringUtil.isDigit(value)) {
            if (StringUtil.equals(value, "csv")) {
                return STAT_FILE_TYPE_CSV;
            }
            if (StringUtil.equals(value, "txt")) {
                return STAT_FILE_TYPE_TXT;
            }
            return statFileType.getDefault();
        }
        return props.getInt(statFileType);
    }

    public static List<String> parseServerOption(DmProperties props) {
        String value = props.getProperty(serverOption.getName());
        List<String> list = new ArrayList<String>();
        if (StringUtil.isEmpty(value)) {
            return list;
        }
        if (value.startsWith("{") && value.endsWith("}")) {
            value = value.substring(1, value.length() - 1);
        }
        list = Arrays.asList(value.split(","));
        return list;
    }

    public static BooleanExpression parseIgnoreWarnings(DmProperties props) {
        String[] list;
        String value = StringUtil.trimToEmpty(props.getProperty(ignoreWarnings.getName()));
        if (StringUtil.isEmpty(value)) {
            return null;
        }
        if (value.startsWith("(") && value.endsWith(")")) {
            value = value.substring(1, value.length() - 1);
        }
        if ((list = value.split(",")) == null || list.length == 0) {
            return null;
        }
        if (list.length == 1) {
            if (StringUtil.equalsIgnoreCase("all", value)) {
                return new BooleanExpression(5, 0);
            }
            if (value.startsWith("<=")) {
                value = value.substring(2);
                int intValue = Integer.valueOf(StringUtil.trimToEmpty(value));
                return new BooleanExpression(4, intValue);
            }
            if (value.startsWith("<")) {
                value = value.substring(1);
                int intValue = Integer.valueOf(StringUtil.trimToEmpty(value));
                return new BooleanExpression(3, intValue);
            }
            if (value.startsWith(">=")) {
                value = value.substring(2);
                int intValue = Integer.valueOf(StringUtil.trimToEmpty(value));
                return new BooleanExpression(6, intValue);
            }
            if (value.startsWith(">")) {
                value = value.substring(1);
                int intValue = Integer.valueOf(StringUtil.trimToEmpty(value));
                return new BooleanExpression(5, intValue);
            }
            if (value.startsWith("!")) {
                value = value.substring(1);
                int intValue = Integer.valueOf(StringUtil.trimToEmpty(value));
                return new BooleanExpression(2, intValue);
            }
            int intValue = Integer.valueOf(StringUtil.trimToEmpty(value));
            return new BooleanExpression(1, intValue);
        }
        if (list.length > 1) {
            int[] vars = new int[list.length];
            int i2 = 0;
            while (i2 < list.length) {
                vars[i2] = Integer.valueOf(StringUtil.trimToEmpty(list[i2]));
                ++i2;
            }
            return new BooleanExpression(7, vars);
        }
        return null;
    }

    public static void main(String[] args) throws Exception {
        DmProperties props = new DmProperties();
        Configuration.parseHostPort(":5236", props);
        System.out.println(props);
        props = new DmProperties();
        Configuration.parseHostPort("[fe80::d569:2082:7df0:9761]:5236", props);
        System.out.println(props);
        props = new DmProperties();
        Configuration.parseHostPort("[fe80::d569:2082:7df0:9761]", props);
        System.out.println(props);
        props = new DmProperties();
        Configuration.parseHostPort("192.168.1.123:5236", props);
        System.out.println(props);
        props = new DmProperties();
        Configuration.parseHostPort("192.168.1.123", props);
        System.out.println(props);
        props = new DmProperties();
        Configuration.parseHostPort("fe80::d569:2082:7df0:9761:5236", props);
        System.out.println(props);
    }
}

