/*
 * Decompiled with CFR 0.152.
 */
package dm.jdbc.internal.convert;

import dm.jdbc.internal.IDmdbConnection;
import dm.jdbc.internal.convert.OffRowData;
import dm.jdbc.util.ByteArrayQueue;
import dm.jdbc.util.ByteUtil;
import dm.jdbc.util.ConvertUtil;
import java.sql.Clob;
import java.sql.SQLException;

public class OffRowClobData
extends OffRowData {
    public OffRowClobData(Clob clob, IDmdbConnection conn) throws SQLException {
        super(clob, conn, -1L);
        this.init();
    }

    @Override
    public void read(ByteArrayQueue byteArray) throws SQLException {
        if (this.getBufferLeaveLen() > 0) {
            this.readFromBuffer(byteArray);
        } else if (!this.readOver) {
            Clob clob = (Clob)this.obj;
            long totalLen = clob.length();
            long leaveLen = totalLen - this.position;
            int readLen = (int)(leaveLen > (long)this.READ_LEN ? (long)this.READ_LEN : leaveLen);
            String str = clob.getSubString(this.position + 1L, readLen);
            byte[] bytes = ByteUtil.fromString(str, this.encoding);
            this.position += (long)readLen;
            if (this.position == totalLen) {
                this.readOver = true;
            }
            byteArray.putBytes(bytes, 0, bytes.length);
        }
    }

    @Override
    public byte[] readAll() throws SQLException {
        Clob clob = (Clob)this.obj;
        String str = ConvertUtil.getClobData(clob);
        return ByteUtil.fromString(str, this.encoding);
    }
}

