/*
 * Decompiled with CFR 0.152.
 */
package dm.jdbc.processor;

import dm.jdbc.processor.BaseThread;
import dm.jdbc.util.ByteArrayQueue;
import dm.jdbc.util.DateUtil;
import dm.jdbc.util.MiscUtil;
import dm.jdbc.util.StringUtil;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Date;

public abstract class BaseFlusher
extends BaseThread {
    protected String dateString = DateUtil.formatDate(new Date(System.currentTimeMillis()), 1);
    protected File logFile = null;
    protected FileOutputStream out;
    protected String filePrefix;
    protected int flushFreq;
    protected String filePath;
    public static final int MAX_FILE_SIZE = 0x6400000;
    public static final int FLUSH_SIZE = 32768;
    protected ByteArrayQueue buffer = new ByteArrayQueue();
    protected String fileExtention = ".log";
    protected int fileNum = 0;

    public BaseFlusher(String string, String string2, String string3, int n2) {
        super(string);
        this.filePath = string2;
        this.filePrefix = string3;
        this.flushFreq = n2;
    }

    protected abstract void doRun();

    @Override
    protected abstract void beforeExit();

    @Override
    public void run() {
        try {
            this.doRun();
        }
        catch (Throwable throwable) {
            try {
                this.beforeExit();
            }
            catch (Throwable throwable2) {}
            this.closeCurrentFile();
            throw throwable;
        }
        try {
            this.beforeExit();
        }
        catch (Throwable throwable) {}
        this.closeCurrentFile();
    }

    protected void doFlush(ByteArrayQueue byteArrayQueue) {
        if (this.out == null || this.needCreateNewFile()) {
            this.closeCurrentFile();
            this.out = this.createNewFile();
        }
        try {
            try {
                byteArrayQueue.writeBytes(this.out, byteArrayQueue.length());
                this.out.flush();
            }
            catch (IOException iOException) {
                MiscUtil.close(this.out);
                this.out = null;
                byteArrayQueue.clear();
            }
        }
        finally {
            byteArrayQueue.clear();
        }
    }

    protected FileOutputStream createNewFile() {
        try {
            Date date = new Date(System.currentTimeMillis());
            String string = DateUtil.formatDate(date, 1);
            if (!StringUtil.equals(string, this.dateString)) {
                this.fileNum = 0;
            }
            this.dateString = string;
            String string2 = String.valueOf(this.filePrefix) + "_" + DateUtil.formatDate(date, 3) + "_" + this.fileNum + this.fileExtention;
            if (StringUtil.isNotEmpty(this.filePath) && StringUtil.isNotEmpty(string2)) {
                File file = new File(this.filePath);
                if (!file.exists()) {
                    file.mkdirs();
                }
                this.logFile = new File(String.valueOf(this.filePath) + string2);
                if (!this.logFile.exists()) {
                    this.logFile.createNewFile();
                }
                ++this.fileNum;
                return new FileOutputStream(this.logFile, true);
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
        return null;
    }

    protected void closeCurrentFile() {
        if (this.out != null) {
            try {
                try {
                    this.out.close();
                }
                catch (IOException iOException) {
                    this.out = null;
                }
            }
            finally {
                this.out = null;
            }
        }
    }

    private boolean needCreateNewFile() {
        String string = DateUtil.formatDate(new Date(System.currentTimeMillis()), 1);
        return !string.equals(this.dateString) || this.logFile == null || this.logFile.length() > 0x6400000L;
    }
}

