/*
 * Decompiled with CFR 0.152.
 */
package dm.jdbc.driver;

import dm.jdbc.driver.DBError;
import dm.jdbc.util.ByteUtil;
import dm.jdbc.util.MathUtil;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Arrays;

public class DmdbNumeric
implements Serializable {
    private static final long serialVersionUID = 3847946444882096464L;
    public static final BigDecimal MAX_VALUE = new BigDecimal("99999999999999999999999999999999999999");
    public static final BigDecimal MIN_VALUE = new BigDecimal("-99999999999999999999999999999999999999");
    private static final int XDEC_MAX_PREC = 38;
    private static final int XDEC_SIZE = 21;
    private static final int FLAG_ZERO = 128;
    private static final int FLAG_POSITIVE = 193;
    private static final int FLAG_NEGTIVE = 62;
    private static final int EXP_MAX = 61;
    private static final int EXP_MIN = -64;
    private static final int NUM_POSITIVE = 1;
    private static final int NUM_NEGTIVE = 101;
    private int sign = 0;
    private int weight = 0;
    private String digits = "";
    private int prec;
    private int scale;
    private boolean hasScale = false;

    private DmdbNumeric(int n2, int n3) {
        this.prec = n2;
        this.scale = n3;
        this.hasScale = n2 > 0 || n3 > 0;
    }

    public DmdbNumeric(byte[] byArray, int n2, int n3) {
        this(n2, n3);
        this.decode(byArray);
    }

    public static DmdbNumeric valueOf(BigDecimal bigDecimal, int n2, int n3) {
        DmdbNumeric dmdbNumeric = new DmdbNumeric(n2, n3);
        dmdbNumeric.parse(bigDecimal);
        return dmdbNumeric;
    }

    public static DmdbNumeric valueOf(String string, int n2, int n3) {
        DmdbNumeric dmdbNumeric = new DmdbNumeric(n2, n3);
        dmdbNumeric.parse(string);
        return dmdbNumeric;
    }

    public static DmdbNumeric valueOf(long l2, int n2, int n3) {
        return DmdbNumeric.valueOf(new BigDecimal(l2), n2, n3);
    }

    public BigDecimal toBigDecimal(boolean bl) {
        if (this.isZero()) {
            return new BigDecimal("0.0");
        }
        String string = this.sign < 0 ? "-" + this.digits.toString() : this.digits.toString();
        BigDecimal bigDecimal = new BigDecimal(string);
        if (this.weight > 0) {
            bigDecimal = bigDecimal.movePointRight(this.weight);
        } else if (this.weight < 0) {
            bigDecimal = bigDecimal.movePointLeft(-this.weight);
        }
        bigDecimal = this.roundHalfup(bigDecimal);
        if (!bl && this.hasScale) {
            bigDecimal = bigDecimal.setScale(this.scale, 4);
        }
        return bigDecimal;
    }

    public String toString(boolean bl) {
        if (this.isZero()) {
            return "0";
        }
        BigDecimal bigDecimal = this.toBigDecimal(bl);
        return bigDecimal.toString();
    }

    public String toString() {
        return this.toString(false);
    }

    public boolean isZero() {
        return this.sign == 0;
    }

    public void decode(byte[] byArray) {
        if (byArray == null || byArray.length == 0 || byArray.length > 21) {
            DBError.ECJDBC_FATAL_ERROR.throwz(new Object[0]);
        }
        if (byArray[0] == 128 || byArray.length == 1) {
            this.sign = 0;
            return;
        }
        this.sign = (byArray[0] & 0x80) != 0 ? 1 : -1;
        int n2 = ByteUtil.getUB1(byArray, 0);
        int n3 = this.sign > 0 ? n2 - 193 : 62 - n2;
        StringBuilder stringBuilder = new StringBuilder();
        int n4 = 0;
        int n5 = 1;
        while (n5 < byArray.length) {
            int n6 = n4 = this.sign > 0 ? byArray[n5] - 1 : 101 - byArray[n5];
            if (n4 < 0 || n4 > 99) break;
            if (n4 < 10) {
                stringBuilder.append("0");
            }
            stringBuilder.append(n4);
            ++n5;
        }
        this.digits = stringBuilder.toString();
        this.weight = n3 * 2 - (this.digits.length() - 2);
        this.formatDigits();
    }

    public byte[] encode() {
        int n2;
        if (this.isZero()) {
            return new byte[]{-128};
        }
        this.checkPrec();
        if (MathUtil.isOdd(this.weight)) {
            this.digits = String.valueOf(this.digits) + "0";
            --this.weight;
        }
        if (MathUtil.isOdd(this.digits.length())) {
            this.digits = "0" + this.digits;
        }
        if ((n2 = (this.weight + this.digits.length()) / 2 - 1) > 61 || n2 < -64) {
            DBError.EC_DATA_OVERFLOW.throwz(new Object[0]);
        }
        int n3 = this.digits.length();
        int n4 = this.digits.length() / 2 + 1;
        int n5 = 0;
        if (n4 > 20) {
            n4 = 20;
            n3 = 2 * (n4 - 1);
            n5 = Character.digit(this.digits.charAt(n3), 10) >= 5 ? 1 : 0;
        }
        int n6 = this.sign < 0 ? n4 + 1 : n4;
        byte[] byArray = new byte[n6];
        int n7 = 0;
        int n8 = n4 - 1;
        boolean bl = true;
        int n9 = n3 - 1;
        while (n9 > 0 && n8 > 0) {
            int n10 = n5 = (n7 = Character.digit(this.digits.charAt(n9--), 10) + Character.digit(this.digits.charAt(n9--), 10) * 10 + n5) > 99 ? 1 : 0;
            if (n7 > 99) {
                n7 %= 100;
            }
            boolean bl2 = bl = bl && n7 == 0;
            if (bl) {
                --n4;
            }
            byArray[n8] = (byte)(this.sign > 0 ? n7 + 1 : 101 - n7);
            --n8;
        }
        if (bl && n5 > 0) {
            ++n2;
            n7 = n5;
            byArray[n4] = (byte)(this.sign > 0 ? n7 + 1 : 101 - n7);
            ++n4;
        }
        byArray[0] = (byte)(this.sign > 0 ? n2 + 193 : 62 - n2);
        if (this.sign < 0) {
            byArray[n4++] = 102;
        }
        if (n4 < byArray.length) {
            byte[] byArray2 = new byte[n4];
            System.arraycopy(byArray, 0, byArray2, 0, n4);
            byArray = byArray2;
        }
        return byArray;
    }

    private void parse(BigDecimal bigDecimal) {
        bigDecimal = this.roundHalfup(bigDecimal);
        this.sign = bigDecimal.signum();
        if (this.isZero()) {
            return;
        }
        String string = bigDecimal.toPlainString();
        string = this.sign < 0 ? string.substring(1) : string;
        int n2 = string.indexOf(".");
        if (n2 != -1) {
            this.weight = -(string.length() - (n2 + 1));
            this.digits = String.valueOf(string.substring(0, n2)) + string.substring(n2 + 1);
        } else {
            this.digits = string;
            this.weight = 0;
        }
        this.formatDigits();
    }

    private BigDecimal roundHalfup(BigDecimal bigDecimal) {
        if (this.hasScale && bigDecimal.scale() > this.scale) {
            bigDecimal = bigDecimal.setScale(this.scale, 4);
        }
        int n2 = bigDecimal.precision();
        if (this.hasScale && n2 > this.prec) {
            if (bigDecimal.scale() >= n2 - this.prec) {
                bigDecimal = bigDecimal.setScale(bigDecimal.scale() - (n2 - this.prec), 4);
            } else if (bigDecimal.scale() < n2 - this.prec) {
                int n3 = n2 - this.prec - bigDecimal.scale();
                bigDecimal = bigDecimal.movePointLeft(n2 - this.prec - bigDecimal.scale());
                this.weight += n3;
                bigDecimal = bigDecimal.setScale(0, 4);
            }
        }
        return bigDecimal;
    }

    private void formatDigits() {
        int n2 = 0;
        char[] cArray = this.digits.toCharArray();
        int n3 = 0;
        while (n3 < cArray.length) {
            if (cArray[n3] != '0') break;
            ++n2;
            ++n3;
        }
        if (n2 > 0) {
            this.digits = this.digits.substring(n2);
        }
        n2 = 0;
        cArray = this.digits.toCharArray();
        n3 = cArray.length - 1;
        while (n3 >= 0) {
            if (cArray[n3] != '0') break;
            ++n2;
            --n3;
        }
        if (n2 > 0) {
            this.digits = this.digits.substring(0, this.digits.length() - n2);
            this.weight += n2;
        }
    }

    private void parse(String string) {
        BigDecimal bigDecimal = null;
        try {
            bigDecimal = new BigDecimal(string);
        }
        catch (Exception exception) {
            DBError.ECJDBC_DATA_CONVERTION_ERROR.throwz(new Object[0]);
        }
        this.parse(bigDecimal);
    }

    private boolean checkPrec() {
        int n2 = this.digits.length();
        if (this.hasScale && (n2 > this.prec || n2 > 38)) {
            DBError.EC_DATA_OVERFLOW.throwz(new Object[0]);
            return false;
        }
        return true;
    }

    public static void main(String[] stringArray) {
        BigDecimal bigDecimal = new BigDecimal("1.2e+12");
        bigDecimal = bigDecimal.setScale(3);
        System.out.println(bigDecimal.toPlainString());
        System.out.println(bigDecimal.toEngineeringString());
        System.out.println(new BigDecimal(String.valueOf(214748364700000L)));
        System.out.println(DmdbNumeric.valueOf("1.10", 0, 0));
        System.out.println(DmdbNumeric.valueOf("1.10", 16, 6));
        System.out.println(DmdbNumeric.valueOf("100.0", 0, 0));
        System.out.println(DmdbNumeric.valueOf("100.0", 16, 6));
        System.out.println(DmdbNumeric.valueOf("100.010", 0, 0));
        System.out.println(DmdbNumeric.valueOf("100.0200", 16, 6));
        System.out.println(DmdbNumeric.valueOf("0.12300", 0, 0));
        System.out.println(DmdbNumeric.valueOf("0.00012300", 16, 6));
        System.out.println(DmdbNumeric.valueOf("1.43532", 16, 2));
        System.out.println(DmdbNumeric.valueOf("1.3e+12", 16, 6));
        System.out.println(DmdbNumeric.valueOf("1.13e-12", 16, 6));
        System.out.println(DmdbNumeric.valueOf("1.1", 0, 0));
        System.out.println(Arrays.toString(DmdbNumeric.valueOf("1.1", 0, 0).encode()));
        System.out.println(Arrays.toString(new DmdbNumeric(new byte[]{-63, 2, 11}, 0, 0).encode()));
        System.out.println(DmdbNumeric.valueOf("10.1", 0, 0));
        System.out.println(Arrays.toString(DmdbNumeric.valueOf("10.1", 0, 0).encode()));
        System.out.println(Arrays.toString(new DmdbNumeric(new byte[]{-63, 11, 11}, 0, 0).encode()));
        System.out.println(DmdbNumeric.valueOf("100.1", 0, 0));
        System.out.println(Arrays.toString(DmdbNumeric.valueOf("100.1", 0, 0).encode()));
        System.out.println(Arrays.toString(new DmdbNumeric(new byte[]{-62, 2, 1, 11}, 0, 0).encode()));
        System.out.println(DmdbNumeric.valueOf("-1.1", 0, 0));
        System.out.println(Arrays.toString(DmdbNumeric.valueOf("-1.1", 0, 0).encode()));
        System.out.println(Arrays.toString(new DmdbNumeric(new byte[]{62, 100, 91, 102}, 0, 0).encode()));
        System.out.println(DmdbNumeric.valueOf("-10.1", 0, 0));
        System.out.println(Arrays.toString(DmdbNumeric.valueOf("-10.1", 0, 0).encode()));
        System.out.println(Arrays.toString(new DmdbNumeric(new byte[]{62, 91, 91, 102}, 0, 0).encode()));
        System.out.println(DmdbNumeric.valueOf("-100.1", 0, 0));
        System.out.println(Arrays.toString(DmdbNumeric.valueOf("-100.1", 0, 0).encode()));
        System.out.println(Arrays.toString(new DmdbNumeric(new byte[]{61, 100, 101, 91, 102}, 0, 0).encode()));
        System.out.println(Arrays.toString(DmdbNumeric.valueOf("800000.0000000000000000000000000000000001", 0, 0).encode()));
        System.out.println(Arrays.toString(new DmdbNumeric(new byte[]{-61, 81}, 0, 0).encode()));
        System.out.println(Arrays.toString(DmdbNumeric.valueOf("999999.9999999999999999999999999999999999", 0, 0).encode()));
        System.out.println(Arrays.toString(new DmdbNumeric(new byte[]{-60, 2}, 0, 0).encode()));
        System.out.println(Arrays.toString(DmdbNumeric.valueOf("-999999.9999999999999999999999999999999999", 0, 0).encode()));
        System.out.println(Arrays.toString(new DmdbNumeric(new byte[]{59, 100, 102}, 0, 0).encode()));
    }
}

