/*
 * Decompiled with CFR 0.152.
 */
package com.ctrip.framework.apollo.mockserver;

import com.ctrip.framework.apollo.build.ApolloInjector;
import com.ctrip.framework.apollo.core.dto.ApolloConfig;
import com.ctrip.framework.apollo.core.dto.ApolloConfigNotification;
import com.ctrip.framework.apollo.core.utils.ResourceUtils;
import com.ctrip.framework.apollo.internals.ConfigServiceLocator;
import com.ctrip.framework.apollo.internals.LocalFileConfigRepository;
import com.ctrip.framework.apollo.util.ConfigUtil;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import okhttp3.mockwebserver.Dispatcher;
import okhttp3.mockwebserver.MockResponse;
import okhttp3.mockwebserver.MockWebServer;
import okhttp3.mockwebserver.RecordedRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ApolloTestingServer
implements AutoCloseable {
    private static final Logger logger = LoggerFactory.getLogger(ApolloTestingServer.class);
    private static final Type notificationType = new TypeToken<List<ApolloConfigNotification>>(){}.getType();
    private static String someAppId = "someAppId";
    private static Method CONFIG_SERVICE_LOCATOR_CLEAR;
    private static ConfigServiceLocator CONFIG_SERVICE_LOCATOR;
    private static ConfigUtil CONFIG_UTIL;
    private static Method RESOURCES_UTILS_CLEAR;
    private static ResourceUtils RESOURCES_UTILS;
    private static final Gson GSON;
    private final Map<String, Map<String, String>> addedOrModifiedPropertiesOfNamespace = Maps.newConcurrentMap();
    private final Map<String, Set<String>> deletedKeysOfNamespace = Maps.newConcurrentMap();
    private MockWebServer server;
    private boolean started;
    private boolean closed;

    public void start() throws IOException {
        this.clear();
        this.server = new MockWebServer();
        Dispatcher dispatcher = new Dispatcher(){

            public MockResponse dispatch(RecordedRequest request) throws InterruptedException {
                if (request.getPath().startsWith("/notifications/v2")) {
                    String notifications = request.getRequestUrl().queryParameter("notifications");
                    return new MockResponse().setResponseCode(200).setBody(ApolloTestingServer.this.mockLongPollBody(notifications));
                }
                if (request.getPath().startsWith("/configs")) {
                    List pathSegments = request.getRequestUrl().pathSegments();
                    String appId = (String)pathSegments.get(1);
                    String cluster = (String)pathSegments.get(2);
                    String namespace = (String)pathSegments.get(3);
                    return new MockResponse().setResponseCode(200).setBody(ApolloTestingServer.this.loadConfigFor(namespace));
                }
                return new MockResponse().setResponseCode(404);
            }
        };
        this.server.setDispatcher(dispatcher);
        this.server.start();
        this.mockConfigServiceUrl("http://localhost:" + this.server.getPort());
        this.started = true;
    }

    @Override
    public void close() {
        try {
            this.clear();
            this.server.close();
        }
        catch (Exception e) {
            logger.error("stop apollo server error", (Throwable)e);
        }
        finally {
            this.closed = true;
        }
    }

    public boolean isClosed() {
        return this.closed;
    }

    public boolean isStarted() {
        return this.started;
    }

    private void clear() {
        this.resetOverriddenProperties();
    }

    private void mockConfigServiceUrl(String url) {
        System.setProperty("apollo.config-service", url);
        try {
            CONFIG_SERVICE_LOCATOR_CLEAR.invoke((Object)CONFIG_SERVICE_LOCATOR, new Object[0]);
        }
        catch (Exception e) {
            throw new IllegalStateException("Invoke config service locator clear failed.", e);
        }
    }

    private String loadConfigFor(String namespace) {
        Properties prop = this.loadPropertiesOfNamespace(namespace);
        HashMap configurations = Maps.newHashMap();
        for (String propertyName : prop.stringPropertyNames()) {
            configurations.put(propertyName, prop.getProperty(propertyName));
        }
        ApolloConfig apolloConfig = new ApolloConfig("someAppId", "someCluster", namespace, "someReleaseKey");
        Map<String, String> mergedConfigurations = this.mergeOverriddenProperties(namespace, configurations);
        apolloConfig.setConfigurations(mergedConfigurations);
        return GSON.toJson((Object)apolloConfig);
    }

    private Properties loadPropertiesOfNamespace(String namespace) {
        String filename = String.format("mockdata-%s.properties", namespace);
        Object mockdataPropertiesExits = null;
        try {
            mockdataPropertiesExits = RESOURCES_UTILS_CLEAR.invoke((Object)RESOURCES_UTILS, filename);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            logger.error("invoke resources util locator clear failed.", (Throwable)e);
        }
        if (!Objects.isNull(mockdataPropertiesExits)) {
            logger.debug("load {} from {}", (Object)namespace, (Object)filename);
            return ResourceUtils.readConfigFile((String)filename, (Properties)new Properties());
        }
        return new LocalFileConfigRepository(someAppId, namespace).getConfig();
    }

    private String mockLongPollBody(String notificationsStr) {
        List oldNotifications = (List)GSON.fromJson(notificationsStr, notificationType);
        ArrayList<ApolloConfigNotification> newNotifications = new ArrayList<ApolloConfigNotification>();
        for (ApolloConfigNotification notification : oldNotifications) {
            newNotifications.add(new ApolloConfigNotification(notification.getNamespaceName(), notification.getNotificationId() + 1L));
        }
        return GSON.toJson(newNotifications);
    }

    private Map<String, String> mergeOverriddenProperties(String namespace, Map<String, String> configurations) {
        if (this.addedOrModifiedPropertiesOfNamespace.containsKey(namespace)) {
            configurations.putAll(this.addedOrModifiedPropertiesOfNamespace.get(namespace));
        }
        if (this.deletedKeysOfNamespace.containsKey(namespace)) {
            for (String k : this.deletedKeysOfNamespace.get(namespace)) {
                configurations.remove(k);
            }
        }
        return configurations;
    }

    public void addOrModifyProperty(String namespace, String someKey, String someValue) {
        if (this.addedOrModifiedPropertiesOfNamespace.containsKey(namespace)) {
            this.addedOrModifiedPropertiesOfNamespace.get(namespace).put(someKey, someValue);
        } else {
            ConcurrentMap m = Maps.newConcurrentMap();
            m.put(someKey, someValue);
            this.addedOrModifiedPropertiesOfNamespace.put(namespace, m);
        }
    }

    public void deleteProperty(String namespace, String someKey) {
        if (this.deletedKeysOfNamespace.containsKey(namespace)) {
            this.deletedKeysOfNamespace.get(namespace).add(someKey);
        } else {
            Set m = Sets.newConcurrentHashSet();
            m.add(someKey);
            this.deletedKeysOfNamespace.put(namespace, m);
        }
    }

    public void resetOverriddenProperties() {
        this.addedOrModifiedPropertiesOfNamespace.clear();
        this.deletedKeysOfNamespace.clear();
    }

    static {
        GSON = new Gson();
        try {
            System.setProperty("apollo.longPollingInitialDelayInMills", "0");
            CONFIG_SERVICE_LOCATOR = (ConfigServiceLocator)ApolloInjector.getInstance(ConfigServiceLocator.class);
            CONFIG_SERVICE_LOCATOR_CLEAR = ConfigServiceLocator.class.getDeclaredMethod("initConfigServices", new Class[0]);
            CONFIG_SERVICE_LOCATOR_CLEAR.setAccessible(true);
            CONFIG_UTIL = (ConfigUtil)ApolloInjector.getInstance(ConfigUtil.class);
            RESOURCES_UTILS = (ResourceUtils)ApolloInjector.getInstance(ResourceUtils.class);
            RESOURCES_UTILS_CLEAR = ResourceUtils.class.getDeclaredMethod("loadConfigFileFromDefaultSearchLocations", String.class);
            RESOURCES_UTILS_CLEAR.setAccessible(true);
        }
        catch (NoSuchMethodException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
    }
}

