/*
 * Decompiled with CFR 0.152.
 */
package com.ctrip.framework.apollo.spi;

import com.ctrip.framework.apollo.build.ApolloInjector;
import com.ctrip.framework.apollo.spi.ConfigFactory;
import com.ctrip.framework.apollo.spi.ConfigRegistry;
import com.ctrip.framework.apollo.util.ConfigUtil;
import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Table;
import com.google.common.collect.Tables;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultConfigRegistry
implements ConfigRegistry {
    private static final Logger s_logger = LoggerFactory.getLogger(DefaultConfigRegistry.class);
    private ConfigUtil m_configUtil;
    private Table<String, String, ConfigFactory> m_instances = Tables.synchronizedTable((Table)HashBasedTable.create());

    public DefaultConfigRegistry() {
        this.m_configUtil = ApolloInjector.getInstance(ConfigUtil.class);
    }

    @Override
    public void register(String namespace, ConfigFactory factory) {
        this.register(this.m_configUtil.getAppId(), namespace, factory);
    }

    @Override
    public void register(String appId, String namespace, ConfigFactory factory) {
        if (this.m_instances.contains((Object)appId, (Object)namespace)) {
            s_logger.warn("ConfigFactory({}-{}) is overridden by {}!", new Object[]{appId, namespace, factory.getClass()});
        }
        this.m_instances.put((Object)appId, (Object)namespace, (Object)factory);
    }

    @Override
    public ConfigFactory getFactory(String namespace) {
        return this.getFactory(this.m_configUtil.getAppId(), namespace);
    }

    @Override
    public ConfigFactory getFactory(String appId, String namespace) {
        ConfigFactory config = (ConfigFactory)this.m_instances.get((Object)appId, (Object)namespace);
        return config;
    }
}

